/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.CompatiblePropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.xml.sax.SAXException;

class CompatibleOperatorState
extends CompatiblePropertyState {
    private static final String NULL_VALUE = "null";
    private static final String NOT_NULL_VALUE = "not-null";
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";

    public CompatibleOperatorState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
        super(theHandler, element, propDefn, struct);
    }

    public void end() throws SAXException {
        String value = this.text.toString();
        assert (this.struct != null);
        if (NULL_VALUE.equalsIgnoreCase(value)) {
            if ("operator".equalsIgnoreCase(this.propDefn.getName())) {
                value = "is-null";
            } else if ("operator".equalsIgnoreCase(this.propDefn.getName())) {
                value = "is-null";
            }
        }
        if (NOT_NULL_VALUE.equalsIgnoreCase(value)) {
            if ("operator".equalsIgnoreCase(this.propDefn.getName())) {
                value = "is-not-null";
            } else if ("operator".equalsIgnoreCase(this.propDefn.getName())) {
                value = "is-not-null";
            }
        }
        if (TRUE_VALUE.equalsIgnoreCase(value)) {
            if ("operator".equalsIgnoreCase(this.propDefn.getName())) {
                value = "is-true";
            } else if ("operator".equalsIgnoreCase(this.propDefn.getName())) {
                value = "is-true";
            }
        }
        if (FALSE_VALUE.equalsIgnoreCase(value)) {
            if ("operator".equalsIgnoreCase(this.propDefn.getName())) {
                value = "is-false";
            } else if ("operator".equalsIgnoreCase(this.propDefn.getName())) {
                value = "is-false";
            }
        }
        this.setMember(this.struct, this.propDefn.getName(), this.name, value);
    }
}

