/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;

public abstract class ExtensibilityProvider
implements IExtendableElement {
    protected DesignElement element;
    protected ExtensionElementDefn cachedExtDefn = null;

    public ExtensibilityProvider(DesignElement element) {
        this.element = element;
    }

    public List getPropertyDefns() {
        ExtensionElementDefn extDefn = this.getExtDefn();
        if (extDefn != null && extDefn.getProperties() != null) {
            List props = extDefn.getProperties();
            List userProps = this.element.getUserProperties();
            if (userProps != null) {
                props.addAll(userProps);
            }
            return props;
        }
        return Collections.EMPTY_LIST;
    }

    public IPropertyDefn getPropertyDefn(String propName) {
        ExtensionElementDefn extDefn = this.getExtDefn();
        if (extDefn != null) {
            return extDefn.getProperty(propName);
        }
        return null;
    }

    public IPropertyDefn getExtensionPropertyDefn(String propName) {
        ExtensionElementDefn extDefn = this.getExtDefn();
        if (extDefn != null && extDefn.getLocalProperties() != null) {
            return extDefn.getProperty(propName);
        }
        return null;
    }

    public abstract void checkExtends(DesignElement var1) throws ExtendsException;

    public boolean hasLocalPropertyValues() {
        return false;
    }
}

