/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.elements.table.LayoutHelper;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.validators.InconsistentColumnsValidator;
import org.eclipse.birt.report.model.api.validators.TableHeaderContextContainmentValidator;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.CellHelper;
import org.eclipse.birt.report.model.elements.ColumnHelper;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.interfaces.ITableItemModel;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;

public class TableItem
extends ListingElement
implements ITableItemModel {
    private LayoutTable table = null;
    private Map<Long, TableColumn> cachedColumn = null;

    public TableItem() {
    }

    public TableItem(String theName) {
        super(theName);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitTable(this);
    }

    public String getElementName() {
        return "Table";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public TableHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new TableHandle(module, this);
        }
        return (TableHandle)this.handle;
    }

    public int getColumnCount(Module module) {
        int colCount = this.getColDefnCount(module);
        if (colCount != 0) {
            return colCount;
        }
        return this.findMaxCols(module);
    }

    public int findMaxCols(Module module) {
        if (this.table == null) {
            this.refreshRenderModel(module);
        }
        return this.table.getColumnCount();
    }

    public int getColDefnCount(Module module) {
        int colCount = 0;
        ContainerSlot cols = this.getSlot(4);
        int colDefnCount = cols.getCount();
        int i = 0;
        while (i < colDefnCount) {
            TableColumn col = (TableColumn)cols.getContent(i);
            colCount += col.getIntProperty(module, "repeat");
            ++i;
        }
        return colCount;
    }

    public int getColumnPosition4Cell(Module module, Cell target) {
        if (target == null) {
            return 0;
        }
        if (this.table == null) {
            this.refreshRenderModel(module);
        }
        int slotId = target.getContainer().getContainerInfo().getSlotID();
        TableRow row = (TableRow)target.getContainer();
        DesignElement grandPa = row.getContainer();
        int rowId = grandPa.getSlot(slotId).findPosn(row);
        if (grandPa instanceof TableItem) {
            assert (grandPa == this);
            return this.table.getColumnPos(slotId, rowId, target);
        }
        return this.table.getColumnPos(((TableGroup)grandPa).getGroupLevel(), slotId, rowId, target);
    }

    public TableColumn getColumn(Module module, ContainerSlot columnSlot, Cell target) {
        if (module.isCached()) {
            if (this.cachedColumn == null) {
                return null;
            }
            return this.cachedColumn.get(new Long(target.getID()));
        }
        int columnNum = this.getColumnNum(module, target);
        if (columnNum == 0) {
            return null;
        }
        return ColumnHelper.findColumn(module, columnSlot, columnNum);
    }

    public void cacheValues() {
        ContainerSlot columnSlot = this.getSlot(4);
        if (columnSlot.getCount() == 0) {
            return;
        }
        Module module = this.getRoot();
        this.cachedColumn = new HashMap<Long, TableColumn>();
        TableColumn[] cachedColumnArray = ColumnHelper.getTableColumnArray(module, columnSlot);
        ContainerSlot slot = this.getSlot(0);
        List<Cell> cellList = CellHelper.getCells(slot);
        slot = this.getSlot(2);
        cellList.addAll(CellHelper.getCells(slot));
        slot = this.getSlot(3);
        cellList.addAll(CellHelper.getCells(slot));
        slot = this.getSlot(1);
        cellList.addAll(CellHelper.getCellsInTableGroup(slot));
        int i = 0;
        while (i < cellList.size()) {
            TableColumn column;
            Cell cell = cellList.get(i);
            int columnNum = this.getColumnNum(module, cell);
            if (columnNum != 0 && (column = ColumnHelper.getColumnInArray(cachedColumnArray, columnNum)) != null) {
                this.cachedColumn.put(new Long(cell.getID()), column);
            }
            ++i;
        }
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(InconsistentColumnsValidator.getInstance().validate(module, this));
        list.addAll(TableHeaderContextContainmentValidator.getInstance().validate(module, this));
        return list;
    }

    public LayoutTable getLayoutModel(Module module) {
        if (this.table == null) {
            this.refreshRenderModel(module);
        }
        return this.table;
    }

    public void refreshRenderModel(Module module) {
        this.table = LayoutHelper.applyLayout(module, this);
    }

    public List checkContent(Module module, ContainerContext containerInfo, DesignElement content) {
        List errors = super.checkContent(module, containerInfo, content);
        if (!errors.isEmpty()) {
            return errors;
        }
        errors.addAll(TableHeaderContextContainmentValidator.getInstance().validateForAdding(module, containerInfo, content));
        return errors;
    }

    public List checkContent(Module module, ContainerContext containerInfo, IElementDefn defn) {
        List errors = super.checkContent(module, containerInfo, defn);
        if (!errors.isEmpty()) {
            return errors;
        }
        errors.addAll(TableHeaderContextContainmentValidator.getInstance().validateForAdding(module, containerInfo.getElement(), defn));
        return errors;
    }

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        TableItem clonedTable = (TableItem)super.doClone(policy);
        clonedTable.refreshRenderModel(this.table.getTable().getModule());
        return clonedTable;
    }

    private int getColumnNum(Module module, Cell cell) {
        int columnNum = cell.getColumn(module);
        if (columnNum == 0) {
            columnNum = this.getColumnPosition4Cell(module, cell);
        }
        return columnNum;
    }
}

