/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.DataSetRequiredValidator;
import org.eclipse.birt.report.model.api.validators.GroupNameValidator;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.interfaces.IListingElementModel;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.ContentExceptionFactory;
import org.eclipse.birt.report.model.util.ModelUtil;

public abstract class ListingElement
extends ReportItem
implements IListingElementModel {
    public ListingElement() {
        this.initSlots();
    }

    public ListingElement(String theName) {
        super(theName);
        this.initSlots();
    }

    public List getGroups() {
        return this.slots[1].getContents();
    }

    public ContainerSlot getSlot(int slot) {
        assert (slot >= 0 && slot < this.getDefn().getSlotCount());
        return this.slots[slot];
    }

    public String getDisplayLabel(Module module, int level) {
        String displayLabel = super.getDisplayLabel(module, level);
        if (level == 2) {
            String name = this.getStringProperty(module, "dataSet");
            if (!StringUtil.isBlank(name = this.limitStringLength(name))) {
                displayLabel = String.valueOf(displayLabel) + "(" + name + ")";
            }
        }
        return displayLabel;
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(this.validateStructureList(module, "sort"));
        list.addAll(this.validateStructureList(module, "filter"));
        if (this.getDataSetElement(module) == null) {
            list.addAll(DataSetRequiredValidator.getInstance().validate(module, this));
        } else {
            list.addAll(GroupNameValidator.getInstance().validate(module, this));
        }
        return list;
    }

    public List checkContent(Module module, ContainerContext containerInfo, IElementDefn defn) {
        List errors = super.checkContent(module, containerInfo, defn);
        if (!errors.isEmpty()) {
            return errors;
        }
        if (defn.isKindOf(MetaDataDictionary.getInstance().getElement("ListingGroup")) && this.isDataBindingReferring(module)) {
            errors.add(ContentExceptionFactory.createContentException(containerInfo, null, "Error.ContentException.GROUPS_CHANGE_FORBIDDEN"));
            return errors;
        }
        return errors;
    }

    public List checkContent(Module module, ContainerContext containerInfo, DesignElement content) {
        List errors = super.checkContent(module, containerInfo, content);
        if (!errors.isEmpty()) {
            return errors;
        }
        if (content instanceof GroupElement) {
            if (this.isDataBindingReferring(module)) {
                errors.add(ContentExceptionFactory.createContentException(containerInfo, content, "Error.ContentException.GROUPS_CHANGE_FORBIDDEN"));
                return errors;
            }
            String checkedName = (String)content.getLocalProperty(module, "groupName");
            if (StringUtil.isBlank(checkedName)) {
                return errors;
            }
            errors.addAll(GroupNameValidator.getInstance().validateForAddingGroup((ListingHandle)this.getHandle(module), checkedName));
        }
        return errors;
    }

    public List findReferredListingElements(Module module) {
        ArrayList<DesignElement> returnList = new ArrayList<DesignElement>();
        List clients = this.getClientList();
        int i = 0;
        while (i < clients.size()) {
            BackRef ref = (BackRef)clients.get(i);
            DesignElement refElement = ref.getElement();
            if ("dataBindingRef".equalsIgnoreCase(ref.getPropertyName()) && ModelUtil.isCompatibleDataBindingElements(this, refElement)) {
                returnList.add(refElement);
            }
            ++i;
        }
        return returnList;
    }
}

