/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.interfaces.ILabelModel;

public class Label
extends ReportItem
implements ILabelModel {
    public Label() {
    }

    public Label(String theName) {
        super(theName);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitLabel(this);
    }

    public String getElementName() {
        return "Label";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public LabelHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new LabelHandle(module, this);
        }
        return (LabelHandle)this.handle;
    }

    public String getDisplayLabel(Module module, int level) {
        String displayLabel = super.getDisplayLabel(module, level);
        if (level == 2) {
            String text = this.handle(module).getText();
            if (!StringUtil.isBlank(text)) {
                text = this.limitStringLength(text);
                displayLabel = String.valueOf(displayLabel) + "(\"" + text + "\")";
                return displayLabel;
            }
            String resourceKey = this.handle(module).getTextKey();
            if (!StringUtil.isBlank(resourceKey)) {
                resourceKey = this.limitStringLength(resourceKey);
                displayLabel = String.valueOf(displayLabel) + "(" + resourceKey + ")";
                return displayLabel;
            }
        }
        return displayLabel;
    }
}

