/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetParserException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.css.CssErrorHandler;
import org.eclipse.birt.report.model.css.CssStyle;

public final class CssStyleSheet {
    protected LinkedHashMap styles = new LinkedHashMap();
    private ArrayList warnings = new ArrayList();
    private HashMap unsupportedStyles = new HashMap();
    private HashMap warningsForStyles = new HashMap();
    private CssErrorHandler errorHandler = null;
    private String fileName = null;
    private DesignElement container = null;

    public CssStyleSheetHandle handle(Module module) {
        return new CssStyleSheetHandle((ModuleHandle)module.getHandle(module), this);
    }

    public StyleElement findStyle(String name) {
        return (StyleElement)this.styles.get(name);
    }

    public void addStyle(DesignElement style) {
        assert (this.styles.get(style.getName()) == null);
        this.styles.put(style.getName(), style);
    }

    public void removeStyle(String name) {
        assert (this.styles.get(name) != null);
        this.styles.remove(name);
    }

    public List getStyles() {
        return new ArrayList(this.styles.values());
    }

    public void addWarning(List warnings) {
        warnings.addAll(warnings);
    }

    public List getWarnings() {
        return this.warnings;
    }

    public void addUnsupportedStyle(String styleName, StyleSheetParserException e) {
        this.unsupportedStyles.put(styleName, e);
    }

    public List getUnsupportedStyle() {
        ArrayList styles = new ArrayList();
        styles.addAll(this.unsupportedStyles.keySet());
        return styles;
    }

    public void addWarnings(String styleName, List errors) {
        this.warningsForStyles.put(styleName, errors);
    }

    public List getWarnings(String styleName) {
        return (List)this.warningsForStyles.get(styleName);
    }

    public CssErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(CssErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public DesignElement getContainer() {
        return this.container;
    }

    public void setContainer(DesignElement container) {
        this.container = container;
        List tmpStyles = this.getStyles();
        int i = 0;
        while (i < tmpStyles.size()) {
            CssStyle tmpStyle = (CssStyle)tmpStyles.get(i);
            tmpStyle.setContainer(container);
            ++i;
        }
    }
}

