/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.model.core.DesignElement;

public final class NameSpace
implements Cloneable {
    private HashMap names = new LinkedHashMap();

    public void insert(DesignElement element) {
        assert (element.getName() != null);
        assert (this.names.get(element.getName()) == null);
        this.names.put(element.getName(), element);
    }

    public void remove(DesignElement element) {
        assert (element.getName() != null);
        assert (this.names.get(element.getName()) == element);
        this.names.remove(element.getName());
    }

    public void rename(DesignElement element, String oldName, String newName) {
        if (oldName != null) {
            assert (this.names.get(oldName) == element);
            this.names.remove(oldName);
        }
        if (newName != null) {
            assert (this.names.get(newName) == null);
            this.names.put(newName, element);
        }
    }

    public boolean contains(String name) {
        return this.names.containsKey(name);
    }

    public DesignElement getElement(String name) {
        return (DesignElement)this.names.get(name);
    }

    public int getCount() {
        return this.names.size();
    }

    public List getElements() {
        return new ArrayList(this.names.values());
    }

    public Object clone() throws CloneNotSupportedException {
        NameSpace ns = (NameSpace)super.clone();
        ns.names = new LinkedHashMap();
        return ns;
    }
}

