/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class PropertyReplaceRecord
extends SimpleRecord {
    protected DesignElement element = null;
    protected MemberRef listRef = null;
    IStructure oldItem = null;
    IStructure newItem = null;
    protected List list = null;
    private int position;

    public PropertyReplaceRecord(DesignElement obj, MemberRef ref, List theList, int posn, IStructure newItem) {
        assert (obj != null);
        assert (ref != null);
        assert (theList != null);
        assert (ref.isListRef());
        assert (obj.getPropertyDefn(ref.getPropDefn().getName()) == ref.getPropDefn());
        this.element = obj;
        this.listRef = ref;
        this.list = theList;
        this.position = posn;
        this.oldItem = (IStructure)this.list.get(posn);
        this.newItem = newItem;
        assert (this.oldItem != null && newItem != null);
        this.label = CommandLabelFactory.getCommandLabel("Message.ReplaceItem");
    }

    protected void perform(boolean undo) {
        if (undo) {
            StructureContext context = ((Structure)this.newItem).getContext();
            context.remove((Structure)this.newItem);
            context.add(this.position, (Structure)this.oldItem);
        } else {
            StructureContext context = ((Structure)this.oldItem).getContext();
            context.remove((Structure)this.oldItem);
            context.add(this.position, (Structure)this.newItem);
        }
    }

    public DesignElement getTarget() {
        if (this.eventTarget != null) {
            return this.eventTarget.getElement();
        }
        return this.element;
    }

    public NotificationEvent getEvent() {
        if (this.eventTarget != null) {
            return new PropertyEvent(this.eventTarget.getElement(), this.eventTarget.getPropName());
        }
        return new PropertyEvent(this.element, this.listRef.getPropDefn().getName());
    }

    protected List getPostTasks() {
        ArrayList<NotificationRecordTask> retList = new ArrayList<NotificationRecordTask>();
        retList.addAll(super.getPostTasks());
        retList.add(new NotificationRecordTask(this.element, this.getEvent()));
        if (this.oldItem != null && this.oldItem.isReferencable()) {
            ReferencableStructure refValue = (ReferencableStructure)this.oldItem;
            retList.add(new NotificationRecordTask(refValue, this.getEvent()));
        }
        return retList;
    }
}

