/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.CssEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssNameManager;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;

public class CssRecord
extends SimpleRecord {
    protected Module module;
    private DesignElement element;
    private CssStyleSheet css;
    private boolean add = true;
    private int position = -1;

    CssRecord(Module module, DesignElement element, CssStyleSheet css, boolean add) {
        this.module = module;
        this.element = element;
        this.css = css;
        this.add = add;
    }

    CssRecord(Module module, DesignElement element, CssStyleSheet css, boolean add, int pos) {
        this.module = module;
        this.element = element;
        this.css = css;
        this.add = add;
        this.position = pos;
    }

    protected void perform(boolean undo) {
        assert (this.element instanceof ICssStyleSheetOperation);
        ICssStyleSheetOperation operation = (ICssStyleSheetOperation)((Object)this.element);
        if (this.add && !undo || !this.add && undo) {
            if (this.position == -1) {
                operation.addCss(this.css);
                this.setContainer(this.element, this.css);
                int size = operation.getCsses().size();
                CssNameManager.adjustStylesForAdd(this.module, operation, this.css, size - 1);
            } else {
                operation.insertCss(this.css, this.position);
                this.setContainer(this.element, this.css);
                CssNameManager.adjustStylesForAdd(this.module, operation, this.css, this.position);
            }
        } else {
            operation.dropCss(this.css);
            this.setContainer(null, this.css);
            CssNameManager.adjustStylesForRemove(this.css);
        }
    }

    private void setContainer(DesignElement element, CssStyleSheet sheet) {
        if (sheet == null) {
            return;
        }
        sheet.setContainer(element);
        List styles = sheet.getStyles();
        for (CssStyle style : styles) {
            style.setCssStyleSheet(sheet);
        }
    }

    public NotificationEvent getEvent() {
        if (this.add && this.state != 2 || !this.add && this.state == 2) {
            return new CssEvent(this.css, 1);
        }
        return new CssEvent(this.css, 2);
    }

    public DesignElement getTarget() {
        return this.element;
    }
}

