/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.command.AbstractPropertyCommand;
import org.eclipse.birt.report.model.command.ContentElementCommand;
import org.eclipse.birt.report.model.command.ElementRefRecord;
import org.eclipse.birt.report.model.command.MemberRecord;
import org.eclipse.birt.report.model.command.MoveListItemRecord;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.command.PropertyListRecord;
import org.eclipse.birt.report.model.command.PropertyReplaceRecord;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ComplexPropertyCommand
extends AbstractPropertyCommand {
    public ComplexPropertyCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    private void addItem(MemberRef ref, IStructure item) throws SemanticException {
        assert (ref != null);
        this.checkAllowedOperation();
        if (item == null) {
            return;
        }
        Structure struct = (Structure)item;
        if (struct.getContext() != null) {
            struct = (Structure)struct.copy();
        }
        ModelUtil.setupStructureContext(struct);
        ElementPropertyDefn propDefn = ref.getPropDefn();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        if (struct.isReferencable()) assert (!((ReferencableStructure)struct).hasReferences());
        this.checkListMemberRef(ref);
        this.checkItem(ref, struct);
        ArrayList list = ref.getList(this.module, this.element);
        PropertyDefn memberDefn = ref.getMemberDefn();
        if (memberDefn != null) {
            this.element.checkStructureList(this.module, memberDefn, list, struct);
        } else {
            this.element.checkStructureList(this.module, propDefn, list, struct);
        }
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.AddItem"));
        this.makeLocalCompositeValue(ref);
        list = ref.getList(this.module, this.element);
        if (list == null) {
            list = new ArrayList();
            MemberRecord memberRecord = new MemberRecord(this.module, this.element, ref, list);
            stack.execute(memberRecord);
        }
        PropertyListRecord record = this.constructStructureRecord(ref, struct, list.size());
        record.setEventTarget(this.getEventTarget(ref.getPropDefn()));
        stack.execute(record);
        stack.commit();
    }

    public void addItem(MemberRef ref, Object item) throws SemanticException {
        ElementRefValue refValue;
        if (item instanceof IStructure) {
            this.addItem(ref, (IStructure)item);
            return;
        }
        assert (ref != null);
        this.checkAllowedOperation();
        if (item == null) {
            return;
        }
        assert (!(item instanceof IStructure));
        PropertyDefn prop = ref.getPropDefn();
        PropertyDefn memberDefn = ref.getMemberDefn();
        this.assertExtendedElement(this.module, this.element, prop);
        if (memberDefn != null) {
            prop = memberDefn;
        }
        this.checkListProperty(prop);
        Object value = this.checkItem(prop, item);
        if (this.element instanceof ContentElement && !((ContentElement)this.element).isLocal()) {
            ContentElementCommand attrCmd = new ContentElementCommand(this.module, this.element, ((ContentElement)this.element).getValueContainer());
            attrCmd.addItem(ref, value);
            return;
        }
        ArrayList list = ref.getList(this.module, this.element);
        if (prop.getTypeCode() == 20) {
            this.element.checkSimpleList(this.module, prop, list, value);
        }
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.AddItem"));
        this.makeLocalCompositeValue(ref);
        list = ref.getList(this.module, this.element);
        if (list == null) {
            list = new ArrayList();
            MemberRecord memberRecord = new MemberRecord(this.module, this.element, ref, list);
            stack.execute(memberRecord);
        }
        PropertyListRecord record = new PropertyListRecord(this.element, ref.getPropDefn(), list, value, list.size());
        record.setEventTarget(this.getEventTarget(ref.getPropDefn()));
        stack.execute(record);
        if (value instanceof ElementRefValue && (refValue = (ElementRefValue)value).isResolved()) {
            ElementRefRecord refRecord = new ElementRefRecord(this.element, refValue.getTargetElement(), prop.getName(), true);
            stack.execute(refRecord);
        }
        stack.commit();
    }

    public void insertItem(MemberRef ref, IStructure item, int posn) throws SemanticException {
        assert (ref != null);
        this.checkAllowedOperation();
        if (item == null) {
            return;
        }
        Structure struct = (Structure)item;
        if (struct.getContext() != null) {
            struct = (Structure)struct.copy();
        }
        ElementPropertyDefn propDefn = ref.getPropDefn();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        this.checkListMemberRef(ref);
        this.checkItem(ref, struct);
        ArrayList list = ref.getList(this.module, this.element);
        this.element.checkStructureList(this.module, ref.getPropDefn(), list, struct);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.InsertItem"));
        this.makeLocalCompositeValue(ref);
        list = ref.getList(this.module, this.element);
        if (list == null) {
            list = new ArrayList();
            MemberRecord memberRecord = new MemberRecord(this.module, this.element, ref, list);
            stack.execute(memberRecord);
        }
        if (posn < 0 || posn > list.size()) {
            throw new IndexOutOfBoundsException("Posn: " + posn + ", List Size: " + list.size());
        }
        PropertyListRecord record = this.constructStructureRecord(ref, struct, posn);
        record.setEventTarget(this.getEventTarget(ref.getPropDefn()));
        stack.execute(record);
        stack.commit();
    }

    public void removeItem(MemberRef ref, int posn) throws SemanticException {
        assert (ref != null);
        PropertyDefn propDefn = ref.getPropDefn();
        this.checkAllowedOperation();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        PropertyDefn memberDefn = ref.getMemberDefn();
        List list = null;
        if (memberDefn != null) {
            propDefn = memberDefn;
        }
        if (propDefn.getTypeCode() == 20) {
            list = ref.getList(this.module, this.element);
        } else {
            this.checkListMemberRef(ref);
            list = ref.getList(this.module, this.element);
        }
        if (list == null) {
            throw new PropertyValueException(this.element, ref.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        if (posn < 0 || posn >= list.size()) {
            throw new IndexOutOfBoundsException("Posn: " + posn + ", List Size: " + list.size());
        }
        if (this.element instanceof ContentElement && !((ContentElement)this.element).isLocal()) {
            ContentElementCommand attrCmd = new ContentElementCommand(this.module, this.element, ((ContentElement)this.element).getValueContainer());
            attrCmd.removeItem(new CachedMemberRef(ref, posn));
            return;
        }
        this.doRemoveItem(new CachedMemberRef(ref, posn));
    }

    public void removeItem(MemberRef ref, IStructure structure) throws PropertyValueException {
        this.checkAllowedOperation();
        ElementPropertyDefn propDefn = ref.getPropDefn();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        this.checkListMemberRef(ref);
        List list = ref.getList(this.module, this.element);
        if (list == null) {
            throw new PropertyValueException(this.element, ref.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        int posn = list.indexOf(structure);
        if (posn == -1) {
            throw new PropertyValueException(this.element, ref.getPropDefn().getName(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        this.doRemoveItem(new CachedMemberRef(ref, posn));
    }

    private void doRemoveItem(MemberRef memberRef) {
        ElementRefValue refValue;
        String label = CommandLabelFactory.getCommandLabel("Message.RemoveItem");
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(label);
        this.makeLocalCompositeValue(memberRef);
        List list = memberRef.getList(this.module, this.element);
        assert (list != null);
        Structure struct = memberRef.getStructure(this.module, this.element);
        if (struct != null) {
            if (struct.isReferencable()) {
                this.adjustReferenceClients((ReferencableStructure)struct);
            }
            this.adjustReferenceClients(struct, memberRef);
        }
        Object item = list.get(memberRef.getIndex());
        PropertyListRecord record = null;
        record = struct != null ? new PropertyListRecord(this.element, struct.getContext(), item) : new PropertyListRecord(this.element, memberRef.getPropDefn(), list, item);
        record.setEventTarget(this.getEventTarget(memberRef.getPropDefn()));
        stack.execute(record);
        if (item instanceof ElementRefValue && (refValue = (ElementRefValue)item).isResolved()) {
            ElementRefRecord refRecord = new ElementRefRecord(this.element, refValue.getTargetElement(), memberRef.getPropDefn().getName(), false);
            stack.execute(refRecord);
        }
        stack.commit();
    }

    public void replaceItem(MemberRef ref, IStructure oldItem, IStructure newItem) throws SemanticException {
        assert (ref != null);
        this.checkAllowedOperation();
        ElementPropertyDefn propDefn = ref.getPropDefn();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        this.checkListMemberRef(ref);
        List list = ref.getList(this.module, this.element);
        if (list == null) {
            throw new PropertyValueException(this.element, ref.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        Structure struct = (Structure)newItem;
        if (newItem != null) {
            if (struct.getContext() != null) {
                struct = (Structure)struct.copy();
            }
            this.checkItem(ref, struct);
            this.element.checkStructureList(this.module, ref.getPropDefn(), list, struct);
        }
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ReplaceItem"));
        this.makeLocalCompositeValue(ref);
        list = ref.getList(this.module, this.element);
        assert (list != null);
        int index = list.indexOf(oldItem);
        if (index == -1) {
            throw new PropertyValueException(this.element, ref.getPropDefn().getName(), (Object)oldItem, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        PropertyReplaceRecord record = new PropertyReplaceRecord(this.element, ref, list, index, struct);
        record.setEventTarget(this.getEventTarget(propDefn));
        stack.execute(record);
        if (oldItem.isReferencable()) {
            this.adjustReferenceClients((ReferencableStructure)oldItem);
        }
        stack.commit();
    }

    public void removeAllItems(MemberRef ref) throws SemanticException {
        this.checkAllowedOperation();
        this.checkListMemberRef(ref);
        ElementPropertyDefn propDefn = ref.getPropDefn();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        if (ref.refType == 0) {
            PropertyCommand cmd = new PropertyCommand(this.module, this.element);
            cmd.setProperty(ref.getPropDefn(), null);
        } else {
            PropertyCommand cmd = new PropertyCommand(this.module, this.element);
            cmd.setMember(ref, null);
        }
    }

    public void moveItem(MemberRef ref, int oldPosn, int newPosn) throws PropertyValueException {
        assert (ref != null);
        this.checkAllowedOperation();
        ElementPropertyDefn propDefn = ref.getPropDefn();
        assert (propDefn != null);
        this.checkListMemberRef(ref);
        List list = ref.getList(this.module, this.element);
        if (list == null) {
            throw new PropertyValueException(this.element, ref.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        ActivityStack stack = this.getActivityStack();
        String label = CommandLabelFactory.getCommandLabel("Message.MoveItem");
        int adjustedNewPosn = ComplexPropertyCommand.checkAndAdjustPosition(oldPosn, newPosn, list.size());
        if (oldPosn == adjustedNewPosn) {
            return;
        }
        stack.startTrans(label);
        this.makeLocalCompositeValue(ref);
        list = ref.getList(this.module, this.element);
        assert (list != null);
        MoveListItemRecord record = new MoveListItemRecord(this.element, ref, list, oldPosn, adjustedNewPosn);
        record.setEventTarget(this.getEventTarget(ref.getPropDefn()));
        stack.execute(record);
        stack.commit();
    }

    private void checkListProperty(PropertyDefn prop) throws PropertyValueException {
        if (prop.getTypeCode() != 20) {
            throw new PropertyValueException(this.element, prop, null, "Error.PropertyValueException.NOT_LIST_TYPE");
        }
    }

    protected void checkListMemberRef(MemberRef ref) throws PropertyValueException {
        if (!ref.isListRef()) {
            throw new PropertyValueException(this.element, ref.getPropDefn(), null, "Error.PropertyValueException.NOT_LIST_TYPE");
        }
    }

    private void checkAllowedOperation() {
        if (this.element != null && this.element instanceof CssStyle) {
            throw new IllegalOperationException("Error.CssException.READONLY");
        }
    }

    private PropertyListRecord constructStructureRecord(MemberRef ref, Structure struct, int posn) {
        PropertyListRecord record = null;
        Structure parentStruct = ref.getStructure(this.module, this.element);
        PropertyDefn tmpPropDefn = ref.getMemberDefn();
        if (tmpPropDefn == null) {
            tmpPropDefn = ref.getPropDefn();
        }
        StructureContext context = null;
        context = parentStruct == null ? new StructureContext(this.element, tmpPropDefn.getName()) : new StructureContext(parentStruct, tmpPropDefn.getName());
        record = new PropertyListRecord(this.element, context, struct, posn);
        return record;
    }
}

