/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.validators.StructureListValidator;
import org.eclipse.birt.report.model.command.ContentElementInfo;
import org.eclipse.birt.report.model.command.ElementBackRefRecord;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.command.StructBackRefRecord;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public abstract class AbstractPropertyCommand
extends AbstractElementCommand {
    public AbstractPropertyCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    protected void assertExtendedElement(Module module, DesignElement element, PropertyDefn prop) {
        ExtendedItem extendedItem;
        if (element instanceof ExtendedItem && ((extendedItem = (ExtendedItem)element).isExtensionModelProperty(prop.getName()) || extendedItem.isExtensionXMLProperty(prop.getName()))) assert (((ExtendedItem)element).getExtendedElement() != null);
    }

    protected void checkItem(MemberRef ref, IStructure item) throws SemanticException {
        this.checkItem(ref.getPropDefn(), (StructPropertyDefn)ref.getMemberDefn(), item);
    }

    private void checkItems(PropertyDefn propDefn, PropertyDefn memberDefn, List items) throws SemanticException {
        if (items == null) {
            return;
        }
        ArrayList<IStructure> currentList = new ArrayList<IStructure>();
        int i = 0;
        while (i < items.size()) {
            IStructure struct = (IStructure)items.get(i);
            this.checkItem(propDefn, (StructPropertyDefn)memberDefn, struct);
            StructureListValidator.getInstance().validateForAdding(this.element.getHandle(this.module), memberDefn, currentList, struct);
            currentList.add(struct);
            ++i;
        }
    }

    private void checkItem(PropertyDefn propDefn, StructPropertyDefn memberDefn, IStructure item) throws SemanticException {
        List errorList;
        assert (item != null);
        PropertyDefn currentDefn = propDefn;
        if (memberDefn == null) {
            if (item.getDefn() != propDefn.getStructDefn()) {
                throw new PropertyValueException(this.element, propDefn, (Object)item, "Error.PropertyValueException.WRONG_ITEM_TYPE");
            }
        } else {
            if (item.getDefn() != memberDefn.getStructDefn()) {
                throw new PropertyValueException(this.element, propDefn, propDefn, item, "Error.PropertyValueException.WRONG_ITEM_TYPE");
            }
            currentDefn = memberDefn;
        }
        Iterator iter = item.getDefn().propertiesIterator();
        while (iter.hasNext()) {
            PropertyDefn tmpMemberDefn = (PropertyDefn)iter.next();
            if ("libReference".equals(tmpMemberDefn.getName())) continue;
            Object value = ((Structure)item).getLocalProperty(this.module, tmpMemberDefn);
            if (value instanceof ElementRefValue && tmpMemberDefn.getTypeCode() == 15) {
                ElementRefValue refValue = (ElementRefValue)value;
                if (refValue.isResolved()) {
                    refValue.unresolved(refValue.getElement().getName());
                }
                value = tmpMemberDefn.validateValue(this.module, refValue.getQualifiedReference());
                this.checkRecursiveElementReference(tmpMemberDefn, (ElementRefValue)value);
            } else if (tmpMemberDefn.isList() && tmpMemberDefn.getStructDefn() != null) {
                this.checkItems(currentDefn, tmpMemberDefn, (List)value);
            } else {
                value = tmpMemberDefn.validateValue(this.module, value);
            }
            item.setProperty(tmpMemberDefn, value);
        }
        if (item instanceof Structure && (errorList = ((Structure)item).validate(this.module, this.element)).size() > 0) {
            throw (SemanticException)((Object)errorList.get(0));
        }
    }

    protected void adjustReferenceClients(ReferencableStructure struct) {
        assert (struct != null);
        if (!struct.hasReferences()) {
            return;
        }
        ArrayList clients = new ArrayList(struct.getClientList());
        for (BackRef ref : clients) {
            DesignElement client = ref.getElement();
            StructBackRefRecord record = new StructBackRefRecord(this.module, struct, client, ref.getPropertyName());
            this.getActivityStack().execute(record);
        }
    }

    protected void checkRecursiveElementReference(PropertyDefn memberDefn, ElementRefValue refValue) throws SemanticException {
        DesignElement reference;
        assert (refValue != null);
        if (refValue.isResolved() && this.element instanceof IReferencableElement && ModelUtil.isRecursiveReference(reference = refValue.getElement(), (IReferencableElement)((Object)this.element))) {
            throw new SemanticError(this.element, new String[]{reference.getIdentifier()}, "Error.SemanticError.CIRCULAR_ELEMENT_REFERNECE");
        }
    }

    protected void checkItemName(MemberRef memberRef, String newName) throws SemanticException {
        ElementPropertyDefn propDefn = memberRef.getPropDefn();
        Structure structure = memberRef.getStructure(this.module, this.element);
        List errors = StructureListValidator.getInstance().validateForRenaming(this.element.getHandle(this.module), propDefn, memberRef.getList(this.module, this.element), structure, memberRef.getMemberDefn(), newName);
        if (errors.size() > 0) {
            throw (PropertyValueException)((Object)errors.get(0));
        }
    }

    protected void adjustReferenceClients(Structure referred, MemberRef memberRef) {
        IStructureDefn structDefn = referred.getDefn();
        Iterator memberDefns = structDefn.getPropertyIterator();
        while (memberDefns.hasNext()) {
            ReferenceValue refValue;
            StructPropertyDefn memberDefn = (StructPropertyDefn)memberDefns.next();
            if (memberDefn.getTypeCode() != 15 || (refValue = (ReferenceValue)referred.getLocalProperty(this.module, memberDefn)) == null || !refValue.isResolved()) continue;
            IReferencableElement client = (IReferencableElement)((Object)((ElementRefValue)refValue).getElement());
            ElementBackRefRecord record = new ElementBackRefRecord(this.module, client, referred, memberDefn.getName());
            this.getActivityStack().execute(record);
        }
    }

    void makeLocalCompositeValue(MemberRef ref) {
        assert (ref != null);
        ElementPropertyDefn propDefn = ref.getPropDefn();
        if (propDefn.isListType()) {
            List list = (ArrayList)this.element.getLocalProperty(this.module, propDefn);
            if (list != null) {
                return;
            }
            ArrayList inherited = (ArrayList)this.element.getProperty(this.module, propDefn);
            if (inherited != null) {
                list = (List)ModelUtil.copyValue(propDefn, inherited);
                if (propDefn.getTypeCode() == 16) {
                    AbstractPropertyCommand.setupStructureContext(list);
                }
            } else {
                list = new ArrayList();
            }
            PropertyRecord propRecord = new PropertyRecord(this.element, propDefn, list);
            this.getActivityStack().execute(propRecord);
            if (ref instanceof CachedMemberRef) {
                ((CachedMemberRef)ref).cacheStructureInForce(this.module, this.element);
            }
            return;
        }
        Structure struct = (Structure)this.element.getLocalProperty(this.module, propDefn);
        if (struct != null) {
            return;
        }
        Structure inherited = (Structure)this.element.getProperty(this.module, propDefn);
        if (inherited != null) {
            IStructure copy = inherited.copy();
            ModelUtil.setupStructureContext((Structure)copy);
            PropertyRecord propRecord = new PropertyRecord(this.element, propDefn, (Object)copy);
            this.getActivityStack().execute(propRecord);
        }
        if (ref instanceof CachedMemberRef) {
            ((CachedMemberRef)ref).cacheStructureInForce(this.module, this.element);
        }
    }

    private static void setupStructureContext(List values) {
        int i = 0;
        while (i < values.size()) {
            Structure child = (Structure)values.get(i);
            ModelUtil.setupStructureContext(child);
            ++i;
        }
    }

    protected Object checkItem(PropertyDefn prop, Object item) throws PropertyValueException {
        assert (item != null);
        assert (prop.getTypeCode() == 20);
        Object value = item;
        if (item instanceof DesignElementHandle) {
            value = ((DesignElementHandle)item).getElement();
        }
        PropertyType type = prop.getSubType();
        assert (type != null);
        Object result = type.validateValue(this.module, prop, value);
        return result;
    }

    protected ContentElementInfo getEventTarget(PropertyDefn propDefn) {
        DesignElement tmpContainer = this.element.getContainer();
        if (tmpContainer == null) {
            return null;
        }
        String tmpPropName = this.element.getContainerInfo().getPropertyName();
        if (tmpPropName == null) {
            return null;
        }
        return ModelUtil.getContentContainer(this.element, tmpContainer.getPropertyDefn(tmpPropName));
    }
}

