/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.Point;
import org.eclipse.birt.report.model.api.util.Rectangle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.GraphicMasterPage;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class MasterPageMultiColumnValidator
extends AbstractElementValidator {
    private static final MasterPageMultiColumnValidator instance = new MasterPageMultiColumnValidator();

    public static MasterPageMultiColumnValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof GraphicMasterPage)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, (GraphicMasterPage)element);
    }

    private List doValidate(Module module, GraphicMasterPage toValidate) {
        double columnSpacing;
        int columns;
        ArrayList<SemanticError> list = new ArrayList<SemanticError>();
        Rectangle margins = toValidate.getContentArea(module);
        Point size = toValidate.getSize(module);
        if (!(margins.x >= size.x || margins.y >= size.y || margins.height <= 0.0 || margins.width <= 0.0 || !(margins.width < (double)((columns = toValidate.getIntProperty(module, "columns")) - 1) * (columnSpacing = toValidate.getFloatProperty(module, "columnSpacing"))))) {
            list.add(new SemanticError(toValidate, "Error.SemanticError.INVALID_MULTI_COLUMN"));
        }
        return list;
    }
}

