/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.model.api.metadata.ValidationValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;

public class ParameterValidationUtil {
    private static final ULocale DEFAULT_LOCALE = ULocale.US;
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DISPLAY_DATE_FORMAT = "Long Date";
    public static final String DISPLAY_TIME_FORMAT = "Medium Time";
    private static final int DATETIME_FORMAT_TYPE = 0;
    private static final int DATE_FORMAT_TYPE = 1;
    private static final int TIME_FORMAT_TYPE = 2;
    private static DateFormatter[] defaultDateFormatters = null;
    private static NumberFormatter defaultNumberFormatter = null;
    private static StringFormatter defaultStringFormatter = null;

    static {
        defaultDateFormatters = new DateFormatter[3];
        DateFormatter dateFormatter = new DateFormatter(DEFAULT_LOCALE);
        dateFormatter.applyPattern(DEFAULT_DATETIME_FORMAT);
        ParameterValidationUtil.defaultDateFormatters[0] = dateFormatter;
        dateFormatter = new DateFormatter(DEFAULT_LOCALE);
        dateFormatter.applyPattern(DEFAULT_DATE_FORMAT);
        ParameterValidationUtil.defaultDateFormatters[1] = dateFormatter;
        dateFormatter = new DateFormatter(DEFAULT_LOCALE);
        dateFormatter.applyPattern(DEFAULT_TIME_FORMAT);
        ParameterValidationUtil.defaultDateFormatters[2] = dateFormatter;
        defaultNumberFormatter = new NumberFormatter(DEFAULT_LOCALE);
        defaultStringFormatter = new StringFormatter(DEFAULT_LOCALE);
        defaultStringFormatter.setTrim(false);
    }

    private static Object validate(String dataType, String value, ULocale locale) throws ValidationValueException {
        return ParameterValidationUtil.validate(dataType, value, locale, null);
    }

    private static Object validate(String dataType, String value, ULocale locale, TimeZone timeZone) throws ValidationValueException {
        if (value == null) {
            return null;
        }
        if ("dateTime".equalsIgnoreCase(dataType)) {
            return ParameterValidationUtil.doValidateDateTime(value, locale, timeZone);
        }
        if ("date".equalsIgnoreCase(dataType)) {
            try {
                return new Date(DataTypeUtil.toDate((String)value, (ULocale)locale).getTime());
            }
            catch (Exception exception) {
                try {
                    return Date.valueOf(value);
                }
                catch (Exception exception2) {
                    throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", dataType);
                }
            }
        }
        if ("time".equalsIgnoreCase(dataType)) {
            try {
                return new Time(DataTypeUtil.toDate((String)value, (ULocale)locale).getTime());
            }
            catch (Exception exception) {
                try {
                    return Time.valueOf(value);
                }
                catch (Exception exception3) {
                    throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", dataType);
                }
            }
        }
        if ("float".equalsIgnoreCase(dataType)) {
            Number number = ParameterValidationUtil.doValidateNumber(dataType, value, locale);
            if (number == null) {
                return null;
            }
            return new Double(number.doubleValue());
        }
        if ("decimal".equalsIgnoreCase(dataType)) {
            Number number = ParameterValidationUtil.doValidateNumber(dataType, value, locale);
            if (number == null) {
                return null;
            }
            if (number instanceof BigDecimal) {
                return number;
            }
            return new BigDecimal(number.toString());
        }
        if ("integer".equalsIgnoreCase(dataType)) {
            Number number = ParameterValidationUtil.doValidateNumber(dataType, value, locale);
            if (number == null) {
                return null;
            }
            return new Integer(number.intValue());
        }
        if ("boolean".equalsIgnoreCase(dataType)) {
            return ParameterValidationUtil.doValidateBoolean(value, locale);
        }
        if ("string".equalsIgnoreCase(dataType)) {
            return value;
        }
        assert (false);
        return null;
    }

    private static final java.util.Date doValidateDateTime(String value, ULocale locale, TimeZone timeZone) throws ValidationValueException {
        try {
            return DataTypeUtil.toDate((String)value, (ULocale)locale, (TimeZone)timeZone);
        }
        catch (BirtException birtException) {
            throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "dateTime");
        }
    }

    static final Number doValidateNumber(String dataType, String value, ULocale locale) throws ValidationValueException {
        assert ("float".equalsIgnoreCase(dataType) || "decimal".equalsIgnoreCase(dataType) || "integer".equalsIgnoreCase(dataType));
        if ((value = StringUtil.trimString(value)) == null) {
            return null;
        }
        NumberFormat localeFormatter = null;
        if ("integer".equalsIgnoreCase(dataType)) {
            localeFormatter = NumberFormat.getIntegerInstance(locale.toLocale());
        } else if ("decimal".equalsIgnoreCase(dataType)) {
            localeFormatter = NumberFormat.getNumberInstance(locale.toLocale());
            if (localeFormatter instanceof DecimalFormat) {
                ((DecimalFormat)localeFormatter).setParseBigDecimal(true);
            }
        } else {
            localeFormatter = NumberFormat.getNumberInstance(locale.toLocale());
        }
        try {
            return localeFormatter.parse(value);
        }
        catch (ParseException parseException) {
            throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", dataType);
        }
    }

    public static Object validate(String dataType, String format, String value, Locale locale) throws ValidationValueException {
        return ParameterValidationUtil.validate(dataType, format, value, ULocale.forLocale((Locale)locale));
    }

    public static Object validate(String dataType, String format, String value, Locale locale, TimeZone timeZone) throws ValidationValueException {
        return ParameterValidationUtil.validate(dataType, format, value, ULocale.forLocale((Locale)locale), timeZone);
    }

    public static Object validate(String dataType, String format, String value, TimeZone timeZone) throws ValidationValueException {
        return ParameterValidationUtil.validate(dataType, format, value, DEFAULT_LOCALE, timeZone);
    }

    public static Object validate(String dataType, String format, String value, ULocale locale) throws ValidationValueException {
        return ParameterValidationUtil.validate(dataType, format, value, locale, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object validate(String dataType, String format, String value, ULocale locale, TimeZone timeZone) throws ValidationValueException {
        if (value == null) {
            return null;
        }
        if (StringUtil.isBlank(format)) {
            return ParameterValidationUtil.validate(dataType, value, locale, timeZone);
        }
        String newFormat = ParameterValidationUtil.transformDateFormat(dataType, format, value);
        try {
            if ("date".equalsIgnoreCase(dataType)) {
                try {
                    return new Date(ParameterValidationUtil.doValidateDateTimeByPattern(newFormat, value, locale, null).getTime());
                }
                catch (Exception exception) {
                    try {
                        return Date.valueOf(value);
                    }
                    catch (Exception exception2) {
                        throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", dataType);
                    }
                }
            }
            if ("time".equalsIgnoreCase(dataType)) {
                try {
                    return new Time(ParameterValidationUtil.doValidateDateTimeByPattern(newFormat, value, locale, null).getTime());
                }
                catch (Exception exception) {
                    try {
                        return Time.valueOf(value);
                    }
                    catch (Exception exception3) {
                        throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", dataType);
                    }
                }
            }
            if ("dateTime".equalsIgnoreCase(dataType)) {
                return ParameterValidationUtil.doValidateDateTimeByPattern(newFormat, value, locale, timeZone);
            }
            if ("float".equalsIgnoreCase(dataType)) {
                Number number = ParameterValidationUtil.doValidateNumberByPattern(dataType, newFormat, value, locale);
                if (number == null) {
                    return null;
                }
                return new Double(number.doubleValue());
            }
            if ("decimal".equalsIgnoreCase(dataType)) {
                Number number = ParameterValidationUtil.doValidateNumberByPattern(dataType, newFormat, value, locale);
                if (number == null) {
                    return null;
                }
                if (number instanceof BigDecimal) {
                    return number;
                }
                return new BigDecimal(number.toString());
            }
            if ("integer".equalsIgnoreCase(dataType)) {
                Number number = ParameterValidationUtil.doValidateNumberByPattern(dataType, newFormat, value, locale);
                if (number == null) {
                    return null;
                }
                return new Integer(number.intValue());
            }
            if ("boolean".equalsIgnoreCase(dataType)) {
                return ParameterValidationUtil.doValidateBoolean(value, locale);
            }
            if ("string".equalsIgnoreCase(dataType)) {
                if (StringUtil.isBlank(value)) {
                    return value;
                }
                if ("Unformatted".equalsIgnoreCase(newFormat)) {
                    return value;
                }
                StringFormatter formatter = new StringFormatter(locale);
                formatter.applyPattern(newFormat);
                try {
                    return formatter.parser(value);
                }
                catch (ParseException parseException) {
                    throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "string");
                }
            }
            assert (false);
            return null;
        }
        catch (ValidationValueException validationValueException) {
            return ParameterValidationUtil.validate(dataType, value, locale);
        }
    }

    private static String transformDateFormat(String dataType, String format, Object value) {
        if ("Unformatted".equalsIgnoreCase(format)) {
            if (!StringUtil.isBlank(dataType)) {
                if ("date".equalsIgnoreCase(dataType)) {
                    return "DateUnformatted";
                }
                if ("time".equalsIgnoreCase(dataType)) {
                    return "TimeUnformatted";
                }
                if ("dateTime".equalsIgnoreCase(dataType)) {
                    return "DateTimeUnformatted";
                }
            } else {
                if (value instanceof java.util.Date) {
                    return "DateTimeUnformatted";
                }
                if (value instanceof Date) {
                    return "DateUnformatted";
                }
                if (value instanceof Time) {
                    return "TimeUnformatted";
                }
            }
        }
        return format;
    }

    public static Object validate(String dataType, String format, String value) throws ValidationValueException {
        return ParameterValidationUtil.validate(dataType, format, value, DEFAULT_LOCALE);
    }

    private static Boolean doValidateBoolean(String value, ULocale locale) throws ValidationValueException {
        if (StringUtil.isBlank(value)) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (value.equalsIgnoreCase(ParameterValidationUtil.getMessage(locale, "Property.Boolean.True"))) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase(ParameterValidationUtil.getMessage(locale, "Property.Boolean.False"))) {
            return Boolean.FALSE;
        }
        throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "boolean");
    }

    private static String getMessage(ULocale locale, String key) {
        ULocale baseLocale = ThreadResources.getLocale();
        if (locale != null) {
            ThreadResources.setLocale(locale);
        }
        String msg = ModelMessages.getMessage(key);
        ThreadResources.setLocale(baseLocale);
        return msg;
    }

    private static java.util.Date doValidateDateTimeByPattern(String format, String value, ULocale locale, TimeZone timeZone) throws ValidationValueException {
        assert (!StringUtil.isBlank(format));
        if (StringUtil.isBlank(value)) {
            return null;
        }
        try {
            DateFormatter formatter = null;
            formatter = timeZone != null ? new DateFormatter(locale, timeZone) : new DateFormatter(locale);
            formatter.applyPattern(format);
            return formatter.parse(value);
        }
        catch (ParseException parseException) {
            throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "dateTime");
        }
    }

    private static Number doValidateNumberByPattern(String dataType, String format, String value, ULocale locale) throws ValidationValueException {
        assert ("float".equalsIgnoreCase(dataType) || "decimal".equalsIgnoreCase(dataType) || "integer".equalsIgnoreCase(dataType));
        if ("Unformatted".equalsIgnoreCase(format)) {
            return ParameterValidationUtil.doValidateNumber(dataType, value, locale);
        }
        assert (!StringUtil.isBlank(format));
        if (StringUtil.isBlank(value)) {
            return null;
        }
        NumberFormatter formatter = new NumberFormatter(locale);
        formatter.applyPattern(format);
        if ("decimal".equalsIgnoreCase(dataType)) {
            formatter.setParseBigDecimal(true);
        }
        try {
            return formatter.parse(value);
        }
        catch (ParseException parseException) {
            throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", dataType);
        }
    }

    public static String getDisplayValue(String dataType, String format, Object value, Locale locale) {
        return ParameterValidationUtil.getDisplayValue(dataType, format, value, ULocale.forLocale((Locale)locale));
    }

    public static String getDisplayValue(Object value) {
        return ParameterValidationUtil.getDisplayValue(value, null);
    }

    public static String getDisplayValue(Object value, TimeZone timeZone) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date && !(value instanceof Date) && !(value instanceof Time)) {
            DateFormatter formatter = null;
            if (timeZone != null) {
                formatter = new DateFormatter(DEFAULT_LOCALE, timeZone);
                formatter.applyPattern(DEFAULT_DATETIME_FORMAT);
            } else {
                formatter = defaultDateFormatters[0];
            }
            return formatter.format((java.util.Date)value);
        }
        if (value instanceof Date) {
            DateFormatter formatter = defaultDateFormatters[1];
            return formatter.format(new java.util.Date(((Date)value).getTime()));
        }
        if (value instanceof Time) {
            DateFormatter formatter = defaultDateFormatters[2];
            return formatter.format(new java.util.Date(((Time)value).getTime()));
        }
        if (value instanceof Float) {
            NumberFormatter formatter = defaultNumberFormatter;
            return formatter.format((double)((Number)value).floatValue());
        }
        if (value instanceof Double) {
            NumberFormatter formatter = defaultNumberFormatter;
            return formatter.format(((Number)value).doubleValue());
        }
        if (value instanceof BigDecimal) {
            NumberFormatter formatter = defaultNumberFormatter;
            return formatter.format((BigDecimal)value);
        }
        if (value instanceof Integer || value instanceof Long) {
            NumberFormatter formatter = defaultNumberFormatter;
            return formatter.format(((Number)value).longValue());
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ParameterValidationUtil.getMessage(DEFAULT_LOCALE, "Property.Boolean.True");
            }
            return ParameterValidationUtil.getMessage(DEFAULT_LOCALE, "Property.Boolean.False");
        }
        if (value instanceof String) {
            StringFormatter formatter = defaultStringFormatter;
            return formatter.format((String)value);
        }
        StringFormatter formatter = defaultStringFormatter;
        return formatter.format(value.toString());
    }

    public static String getDisplayValue(String dataType, String format, Object value, ULocale locale) {
        return ParameterValidationUtil.getDisplayValue(dataType, format, value, locale, null);
    }

    public static String getDisplayValue(String dataType, String format, Object value, ULocale locale, TimeZone timeZone) {
        if (value == null) {
            return null;
        }
        format = StringUtil.trimString(format);
        format = ParameterValidationUtil.transformDateFormat(dataType, format, value);
        if ("dateTime".equalsIgnoreCase(dataType) || value instanceof java.util.Date && !(value instanceof Date) && !(value instanceof Time)) {
            DateFormatter formatter = new DateFormatter(locale, timeZone);
            formatter.applyPattern(format);
            return formatter.format((java.util.Date)value);
        }
        if ("date".equalsIgnoreCase(dataType) || value instanceof Date) {
            DateFormatter formatter = new DateFormatter(locale);
            if (format == null) {
                format = DISPLAY_DATE_FORMAT;
            }
            formatter.applyPattern(format);
            return formatter.format(new java.util.Date(((Date)value).getTime()));
        }
        if ("time".equalsIgnoreCase(dataType) || value instanceof Time) {
            DateFormatter formatter = new DateFormatter(locale);
            if (format == null) {
                format = DISPLAY_TIME_FORMAT;
            }
            formatter.applyPattern(format);
            return formatter.format(new java.util.Date(((Time)value).getTime()));
        }
        if ("float".equalsIgnoreCase(dataType) || value instanceof Float || value instanceof Double) {
            if (value instanceof Float) {
                NumberFormatter formatter = new NumberFormatter(locale);
                formatter.applyPattern(format);
                return formatter.format((double)((Number)value).floatValue());
            }
            NumberFormatter formatter = new NumberFormatter(locale);
            formatter.applyPattern(format);
            return formatter.format(((Number)value).doubleValue());
        }
        if ("decimal".equalsIgnoreCase(dataType) || value instanceof BigDecimal) {
            NumberFormatter formatter = new NumberFormatter(locale);
            formatter.applyPattern(format);
            return formatter.format((BigDecimal)value);
        }
        if ("integer".equalsIgnoreCase(dataType) || value instanceof Integer || value instanceof Long) {
            NumberFormatter formatter = new NumberFormatter(locale);
            formatter.applyPattern(format);
            return formatter.format(((Number)value).longValue());
        }
        if ("boolean".equalsIgnoreCase(dataType) || value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ParameterValidationUtil.getMessage(locale, "Property.Boolean.True");
            }
            return ParameterValidationUtil.getMessage(locale, "Property.Boolean.False");
        }
        if ("string".equalsIgnoreCase(dataType) || value instanceof String) {
            StringFormatter formatter = new StringFormatter(locale);
            formatter.applyPattern(format);
            formatter.setTrim(false);
            return formatter.format((String)value);
        }
        StringFormatter formatter = new StringFormatter(locale);
        formatter.applyPattern(format);
        formatter.setTrim(false);
        return formatter.format(value.toString());
    }

    public static String getDisplayValue(String dataType, String format, Object value) {
        return ParameterValidationUtil.getDisplayValue(dataType, format, value, DEFAULT_LOCALE);
    }
}

