/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.elements.structures.AggregationArgument;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertyStructure;

public class ComputedColumn
extends PropertyStructure {
    public static final String COMPUTED_COLUMN_STRUCT = "ComputedColumn";
    public static final String NAME_MEMBER = "name";
    public static final String DISPLAY_NAME_MEMBER = "displayName";
    public static final String DISPLAY_NAME_ID_MEMBER = "displayNameID";
    public static final String COLUMN_NAME_MEMBER = "columnName";
    public static final String EXPRESSION_MEMBER = "expression";
    public static final String DATA_TYPE_MEMBER = "dataType";
    public static final String AGGREGATEON_MEMBER = "aggregateOn";
    public static final String AGGREGRATEON_MEMBER = "aggregrateOn";
    public static final String AGGREGATEON_FUNCTION_MEMBER = "aggregateFunction";
    public static final String ARGUMENTS_MEMBER = "arguments";
    public static final String FILTER_MEMBER = "filterExpr";

    public String getStructName() {
        return COMPUTED_COLUMN_STRUCT;
    }

    public String getColumnName() {
        return this.getName();
    }

    public String getName() {
        return (String)this.getProperty(null, NAME_MEMBER);
    }

    public String getDisplayName() {
        return (String)this.getProperty(null, DISPLAY_NAME_MEMBER);
    }

    public String getDisplayNameID() {
        return (String)this.getProperty(null, DISPLAY_NAME_ID_MEMBER);
    }

    public void setDisplayName(String columnDisplayName) {
        this.setProperty(DISPLAY_NAME_MEMBER, (Object)columnDisplayName);
    }

    public void setDisplayNameID(String displayNameID) {
        this.setProperty(DISPLAY_NAME_ID_MEMBER, (Object)displayNameID);
    }

    public void setColumnName(String columnName) {
        this.setName(columnName);
    }

    public void setName(String name) {
        this.setProperty(NAME_MEMBER, (Object)name);
    }

    public String getExpression() {
        return (String)this.getProperty(null, EXPRESSION_MEMBER);
    }

    public void setExpression(String expression) {
        this.setProperty(EXPRESSION_MEMBER, (Object)expression);
    }

    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new ComputedColumnHandle(valueHandle, index);
    }

    public List validate(Module module, DesignElement element) {
        List list = super.validate(module, element);
        String columnName = this.getName();
        if (StringUtil.isBlank(columnName)) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(NAME_MEMBER), (Object)columnName, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }

    public String getDataType() {
        return (String)this.getProperty(null, DATA_TYPE_MEMBER);
    }

    public void setDataType(String dataType) {
        this.setProperty(DATA_TYPE_MEMBER, (Object)dataType);
    }

    public String getAggregrateOn() {
        return this.getAggregateOn();
    }

    public void setAggregrateOn(String aggregateOn) {
        this.setAggregateOn(aggregateOn);
    }

    public String getAggregateOn() {
        List aggres = this.getAggregateOnList();
        if (aggres == null || aggres.isEmpty()) {
            return null;
        }
        return (String)aggres.get(0);
    }

    public List getAggregateOnList() {
        List value = (List)this.getProperty(null, AGGREGATEON_MEMBER);
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        return value;
    }

    public void setAggregateOn(String aggregateOn) {
        if (aggregateOn == null) {
            this.setProperty(AGGREGATEON_MEMBER, null);
            return;
        }
        ArrayList<String> value = new ArrayList<String>();
        value.add(aggregateOn);
        this.setProperty(AGGREGATEON_MEMBER, value);
    }

    public void addAggregateOn(String aggreValue) {
        ArrayList<String> aggregationOn = (ArrayList<String>)this.getProperty(null, AGGREGATEON_MEMBER);
        if (aggregationOn == null) {
            aggregationOn = new ArrayList<String>();
        }
        aggregationOn.add(aggreValue);
        this.propValues.put(AGGREGATEON_MEMBER, aggregationOn);
    }

    public void removeAggregateOn(String aggreValue) {
        List aggregationOn = (List)this.getProperty(null, AGGREGATEON_MEMBER);
        if (aggregationOn == null) {
            return;
        }
        aggregationOn.remove(aggreValue);
    }

    public String getAggregateFunction() {
        return (String)this.getProperty(null, AGGREGATEON_FUNCTION_MEMBER);
    }

    public String getFilterExpression() {
        return (String)this.getProperty(null, FILTER_MEMBER);
    }

    public void setAggregateFunction(String expression) {
        this.setProperty(AGGREGATEON_FUNCTION_MEMBER, (Object)expression);
    }

    public void setFilterExpression(String expression) {
        this.setProperty(FILTER_MEMBER, (Object)expression);
    }

    public void clearAggregateOnList() {
        this.setProperty(AGGREGATEON_MEMBER, null);
    }

    public void addArgument(AggregationArgument argument) {
        ArrayList<AggregationArgument> arguments = (ArrayList<AggregationArgument>)this.getProperty(null, ARGUMENTS_MEMBER);
        if (arguments == null) {
            arguments = new ArrayList<AggregationArgument>();
            this.propValues.put(ARGUMENTS_MEMBER, arguments);
        }
        arguments.add(argument);
    }

    public void removeArgument(AggregationArgument argument) {
        List arguments = (List)this.getProperty(null, ARGUMENTS_MEMBER);
        if (arguments == null) {
            return;
        }
        arguments.remove(argument);
    }
}

