/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public abstract class GroupElementHandle {
    public abstract List getElements();

    public abstract Module getModule();

    public abstract ModuleHandle getModuleHandle();

    public abstract boolean isSameType();

    public abstract List getCommonProperties();

    public final Iterator propertyIterator() {
        return new GroupPropertyIterator(this.getCommonProperties());
    }

    public abstract Iterator visiblePropertyIterator();

    protected abstract boolean isPropertyVisible(String var1);

    public abstract void clearLocalProperties() throws SemanticException;

    public abstract boolean isExtendedElements();

    public final boolean hasLocalPropertiesForExtendedElements() {
        if (!this.isSameType()) {
            return false;
        }
        if (!this.allExtendedElements()) {
            return false;
        }
        List elements = this.getElements();
        for (DesignElementHandle elementHandle : elements) {
            boolean hasLocalProperties = elementHandle.hasLocalProperties();
            if (!hasLocalProperties) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean allExtendedElements();

    protected abstract boolean isPropertyReadOnly(String var1);

    public abstract GroupPropertyHandle getPropertyHandle(String var1);

    public final String getStringProperty(String propName) {
        GroupPropertyHandle propHandle = this.getPropertyHandle(propName);
        if (propHandle == null) {
            return null;
        }
        return propHandle.getStringValue();
    }

    public final String getDisplayProperty(String propName) {
        GroupPropertyHandle propHandle = this.getPropertyHandle(propName);
        if (propHandle == null) {
            return null;
        }
        return propHandle.getDisplayValue();
    }

    public final String getLocalStringProperty(String propName) {
        GroupPropertyHandle propHandle = this.getPropertyHandle(propName);
        if (propHandle == null) {
            return null;
        }
        return propHandle.getLocalStringValue();
    }

    public final boolean shareSameValue(String propName) {
        GroupPropertyHandle propHandle = this.getPropertyHandle(propName);
        if (propHandle == null) {
            return false;
        }
        return propHandle.shareSameValue();
    }

    public final void setProperty(String propName, Object value) throws SemanticException {
        GroupPropertyHandle propHandle = this.getPropertyHandle(propName);
        if (propHandle == null) {
            return;
        }
        propHandle.setValue(value);
    }

    public final void clearProperty(String propName) throws SemanticException {
        this.setProperty(propName, null);
    }

    public final void setStringProperty(String propName, String value) throws SemanticException {
        this.setProperty(propName, value);
    }

    protected abstract boolean isInGroup(DesignElementHandle var1);

    class GroupPropertyIterator
    implements Iterator {
        Iterator propIterator;

        GroupPropertyIterator(List list) {
            this.propIterator = list.iterator();
        }

        public void remove() {
        }

        public boolean hasNext() {
            if (this.propIterator == null) {
                return false;
            }
            return this.propIterator.hasNext();
        }

        public Object next() {
            if (!this.propIterator.hasNext()) {
                return null;
            }
            return new GroupPropertyHandle(GroupElementHandle.this, (ElementPropertyDefn)this.propIterator.next());
        }
    }
}

