/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedShort;

public class WaitableShort
extends SynchronizedShort {
    public WaitableShort(short initialValue) {
        super(initialValue);
    }

    public WaitableShort(short initialValue, Object lock) {
        super(initialValue, lock);
    }

    public short set(short newValue) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            short s = super.set(newValue);
            return s;
        }
    }

    public boolean commit(short assumedValue, short newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success = super.commit(assumedValue, newValue);
            if (success) {
                this.lock_.notifyAll();
            }
            boolean bl = success;
            return bl;
        }
    }

    public short increment() {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            short s = super.increment();
            return s;
        }
    }

    public short decrement() {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            short s = super.decrement();
            return s;
        }
    }

    public short add(short amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            short s = super.add(amount);
            return s;
        }
    }

    public short subtract(short amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            short s = super.subtract(amount);
            return s;
        }
    }

    public short multiply(short factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            short s = super.multiply(factor);
            return s;
        }
    }

    public short divide(short factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            short s = super.divide(factor);
            return s;
        }
    }

    public void whenEqual(short c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenNotEqual(short c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLessEqual(short c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ > c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLess(short c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ >= c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreaterEqual(short c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ < c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreater(short c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ <= c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }
}

