/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils.tablemodelbase;

import de.bielefeld.umweltamt.aui.utils.tablemodelbase.BasicTableModel;
import java.util.ArrayList;
import java.util.List;

public abstract class ListTableModel
extends BasicTableModel {
    private List dataList = null;
    private boolean removeAllowed;

    public ListTableModel(String[] columns, boolean updateAtInit) {
        this(columns, updateAtInit, false);
    }

    public ListTableModel(String[] columns, boolean updateAtInit, boolean removeAllowed) {
        super(columns);
        this.removeAllowed = removeAllowed;
        this.dataList = new ArrayList();
        if (updateAtInit) {
            try {
                this.updateList();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ListTableModel(String[] columns, List liste, boolean removeAllowed) {
        super(columns);
        this.removeAllowed = removeAllowed;
        this.dataList = liste;
        try {
            this.updateList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getRowCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    public Object getObjectAtRow(int rowIndex) {
        if (this.rowExists(rowIndex)) {
            return this.dataList.get(rowIndex);
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        if (this.getList() != null && rowIndex < this.getList().size() && columnIndex < this.columns.length) {
            Object objectAtRow = this.getObjectAtRow(rowIndex);
            value = this.getColumnValue(objectAtRow, columnIndex);
        }
        return value;
    }

    public boolean rowExists(int rowIndex) {
        return rowIndex >= 0 && rowIndex < this.getList().size();
    }

    public boolean removeRow(int rowIndex) {
        Object removed;
        boolean wasRemoved = false;
        if (this.removeAllowed && this.rowExists(rowIndex) && (wasRemoved = this.objectRemoved(removed = this.getList().get(rowIndex)))) {
            this.getList().remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
        return wasRemoved;
    }

    public List getList() {
        return this.dataList;
    }

    public void setList(List newList) {
        this.dataList = newList;
    }

    public boolean objectRemoved(Object objectAtRow) {
        return false;
    }

    public abstract void updateList() throws Exception;

    public abstract Object getColumnValue(Object var1, int var2);
}

