/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils.tablemodelbase;

import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

public abstract class EditableListTableModel
extends ListTableModel {
    private boolean hasChanged = false;

    public EditableListTableModel(String[] columns, boolean updateAtInit) {
        this(columns, updateAtInit, true);
    }

    public EditableListTableModel(String[] columns, boolean updateAtInit, boolean removeAllowed) {
        super(columns, updateAtInit, removeAllowed);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        if (this.getList() != null && rowIndex < this.getList().size() && columnIndex < this.columns.length) {
            Object objectAtRow = this.getObjectAtRow(rowIndex);
            value = this.getColumnValue(objectAtRow, columnIndex);
        }
        return value;
    }

    @Override
    public Object getObjectAtRow(int rowIndex) {
        if (this.rowExists(rowIndex)) {
            return super.getObjectAtRow(rowIndex);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return super.getRowCount() + 1;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.rowExists(rowIndex)) {
            this.editObject(this.getObjectAtRow(rowIndex), columnIndex, aValue);
        } else {
            Object tmp = this.newObject();
            this.getList().add(tmp);
            this.editObject(tmp, columnIndex, aValue);
            this.fireTableRowsInserted(rowIndex + 1, rowIndex + 1);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
        this.hasChanged = true;
    }

    @Override
    public boolean removeRow(int rowIndex) {
        boolean tmp = super.removeRow(rowIndex);
        if (tmp) {
            this.hasChanged = true;
        }
        return tmp;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public abstract void editObject(Object var1, int var2, Object var3);

    public abstract Object newObject();
}

