/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils.charts;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import de.bielefeld.umweltamt.aui.utils.charts.APosDataItem;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.jfree.data.time.Minute;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;

public class ChartDataSets {
    public static TimeSeriesCollection createDataset(TimeSeries series) {
        TimeSeriesCollection dataset = new TimeSeriesCollection(series);
        dataset.setDomainIsPointsInTime(true);
        return dataset;
    }

    public static TimeSeries createAnalysePositionenSeries(List list, String name, String einheit) {
        TimeSeries result = new TimeSeries(name, "Datum", einheit, Minute.class);
        AUIKataster.debugOutput("Erzeuge TimeSeries: " + name, "ChartDataSets.createAnalysepositionenSeries");
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof AtlAnalyseposition)) continue;
                AtlAnalyseposition pos = (AtlAnalyseposition)list.get(i);
                APosDataItem item = new APosDataItem(pos);
                ChartDataSets.addPosToMinuteSeries(result, item);
            }
        }
        return result;
    }

    public static TimeSeries createAnalysePositionenSielhautSeries(List list, String name, String einheit) {
        TimeSeries result = new TimeSeries(name, "Datum", einheit, Minute.class);
        AUIKataster.debugOutput("Erzeuge TimeSeries: " + name, "ChartDataSets.createAnalysepositionenSielhautSeries");
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof AtlAnalyseposition)) continue;
                AtlAnalyseposition pos = (AtlAnalyseposition)list.get(i);
                APosDataItem item = new APosDataItem("Normwert", pos);
                ChartDataSets.addPosToMinuteSielhautSeries(result, item);
            }
        }
        return result;
    }

    private static void addPosToMinuteSeries(TimeSeries series, APosDataItem item) {
        if (series.getDataItem(item.getPeriod()) == null) {
            series.add((TimeSeriesDataItem)item);
        } else {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(item.getAnalysePosition().getAtlProbenahmen().getDatumDerEntnahme());
            Minute minute = item.getMinute();
            APosDataItem item2 = new APosDataItem(item.getAnalysePosition(), new Minute(minute.getMinute() + 1, minute.getHour().getHour(), cal.get(5), cal.get(2) + 1, cal.get(1)));
            ChartDataSets.addPosToMinuteSeries(series, item2);
        }
    }

    private static void addPosToMinuteSielhautSeries(TimeSeries series, APosDataItem item) {
        if (series.getDataItem(item.getPeriod()) == null) {
            series.add((TimeSeriesDataItem)item);
        } else {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(item.getAnalysePosition().getAtlProbenahmen().getDatumDerEntnahme());
            Minute minute = item.getMinute();
            APosDataItem item2 = new APosDataItem("Normwert", item.getAnalysePosition(), new Minute(minute.getMinute() + 1, minute.getHour().getHour(), cal.get(5), cal.get(2) + 1, cal.get(1)));
            ChartDataSets.addPosToMinuteSielhautSeries(series, item2);
        }
    }

    private ChartDataSets() {
    }
}

