/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils.charts;

import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesDataItem;

public class APosDataItem
extends TimeSeriesDataItem {
    private AtlAnalyseposition pos;

    public APosDataItem(AtlAnalyseposition pos) {
        this(pos, APosDataItem.createMinuteFromDate(new Timestamp(pos.getAtlProbenahmen().getDatumDerEntnahme().getTime()), pos.getAtlProbenahmen().getDatumDerEntnahme().toString().substring(11, 16)));
    }

    public APosDataItem(String norm, AtlAnalyseposition pos) {
        this("normwert", pos, APosDataItem.createMinuteFromDate(new Timestamp(pos.getAtlProbenahmen().getDatumDerEntnahme().getTime()), pos.getAtlProbenahmen().getZeitDerEntnahmen()));
    }

    public APosDataItem(AtlAnalyseposition pos, Minute minute) {
        super((RegularTimePeriod)minute, (Number)pos.getWert());
        this.pos = pos;
    }

    public APosDataItem(String norm, AtlAnalyseposition pos, Minute minute) {
        super((RegularTimePeriod)minute, (Number)pos.getNormwert());
        this.pos = pos;
    }

    public Minute getMinute() {
        return (Minute)this.getPeriod();
    }

    public AtlAnalyseposition getAnalysePosition() {
        return this.pos;
    }

    public static Minute createMinuteFromDate(Timestamp date, String zeit) {
        int hour = 0;
        int minute = 0;
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        if (zeit != null) {
            hour = Integer.parseInt(zeit.substring(0, 2));
            minute = Integer.parseInt(zeit.substring(3, 5));
        }
        return new Minute(minute, hour, cal.get(5), cal.get(2) + 1, cal.get(1));
    }
}

