/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils;

import com.toedter.calendar.JCalendar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TextFieldDateChooser
extends JPanel
implements ActionListener,
FocusListener,
PropertyChangeListener {
    protected String[] patterns = null;
    protected SimpleDateFormat dateFormat = null;
    protected JTextField textField = null;
    protected JCalendar jcalendar = null;
    protected JButton calendarButton = null;
    protected JPopupMenu popup = null;
    protected boolean dateSelected = false;
    protected Date lastSelectedDate = null;
    protected Calendar workingCalendar = null;
    protected Date todaysDate = null;
    protected boolean ignorePropertyChangeEvent = false;

    public TextFieldDateChooser() {
        this((String[])null);
    }

    public TextFieldDateChooser(String[] patterns) {
        super(new BorderLayout());
        this.patterns = patterns;
        if (this.patterns == null) {
            this.patterns = new String[]{"dd-MMM-yyyy", "MM/dd/yyyy", "MM-dd-yyyy", "MMddyyyy", "ddMMMyyyy", "yyyyMMdd", "yyyy/MM/dd", "yyyy-mm-dd"};
        }
        this.dateFormat = new SimpleDateFormat(this.patterns[0]);
        this.textField = new JTextField(10);
        this.textField.addFocusListener(this);
        super.add((Component)this.textField, "Center");
        this.todaysDate = new Date();
        this.jcalendar = new JCalendar(this.todaysDate);
        this.jcalendar.getDayChooser().addPropertyChangeListener((PropertyChangeListener)this);
        this.jcalendar.getDayChooser().setAlwaysFireDayProperty(true);
        URL iconURL = this.jcalendar.getClass().getResource("images/JDateChooserIcon.gif");
        this.calendarButton = new JButton(new ImageIcon(iconURL));
        this.calendarButton.setMargin(new Insets(0, 0, 0, 0));
        this.calendarButton.addActionListener(this);
        super.add((Component)this.calendarButton, "After");
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                if (b || !b && TextFieldDateChooser.this.dateSelected || isCanceled != null && !b && isCanceled.booleanValue()) {
                    super.setVisible(b);
                }
            }
        };
        this.popup.setLightWeightPopupEnabled(true);
        this.popup.add((Component)this.jcalendar);
    }

    public void setDate(Date date) {
        this.lastSelectedDate = date;
        this.ignorePropertyChangeEvent = true;
        if (date == null) {
            this.textField.setText("");
            this.jcalendar.setDate(this.todaysDate);
        } else {
            this.textField.setText(this.dateFormat.format(date));
            this.jcalendar.setDate(date);
        }
        if (super.getParent() != null) {
            super.getParent().validate();
        }
    }

    public Date getDate() {
        return this.lastSelectedDate;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JButton getCalendarButton() {
        return this.calendarButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int x = this.calendarButton.getWidth() - (int)this.popup.getPreferredSize().getWidth();
        int y = this.calendarButton.getY() + this.calendarButton.getHeight();
        this.popup.show(this.calendarButton, x, y);
        this.dateSelected = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.ignorePropertyChangeEvent && evt.getPropertyName().equals("day")) {
            this.dateSelected = true;
            this.popup.setVisible(false);
            this.lastSelectedDate = this.jcalendar.getDate();
            this.textField.setText(this.dateFormat.format(this.lastSelectedDate));
        }
        this.ignorePropertyChangeEvent = false;
    }

    @Override
    public void focusLost(FocusEvent evt) {
        if (evt.isTemporary()) {
            return;
        }
        String enteredDate = this.textField.getText().trim();
        if (enteredDate == null || enteredDate.length() == 0) {
            this.setDate(null);
            return;
        }
        Date date = null;
        for (int i = 0; i < this.patterns.length; ++i) {
            this.dateFormat.applyPattern(this.patterns[i]);
            try {
                date = this.dateFormat.parse(enteredDate);
                break;
            }
            catch (ParseException e) {
                continue;
            }
        }
        this.dateFormat.applyPattern(this.patterns[0]);
        if (date == null) {
            this.displayErrorMessage();
            this.textField.selectAll();
            this.textField.requestFocus();
        }
        this.setDate(date);
    }

    protected void displayErrorMessage() {
        StringBuffer message = new StringBuffer();
        message.append("Bitte eins der folgenden Formate benutzen: ");
        message.append("\n");
        for (int i = 0; i < this.patterns.length; ++i) {
            message.append(this.patterns[i]);
            if (i >= this.patterns.length - 1) continue;
            message.append(", ");
        }
        JOptionPane.showMessageDialog(this.textField, message, "Falsches Datumsformat", 0);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.jcalendar != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getTextField().setEnabled(enabled);
        this.getCalendarButton().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

