/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.utils.GlassPane;
import java.awt.Component;
import javax.swing.SwingUtilities;
import org.hibernate.HibernateException;

public abstract class SwingWorkerVariant {
    private Thread thread;
    private ThreadVar threadVar;
    private GlassPane glassPane;
    private Component aComponent;
    protected boolean fatalError = false;

    public SwingWorkerVariant(Component aComponent) {
        this.setAComponent(aComponent);
        final Runnable doFinished = new Runnable(){

            @Override
            public void run() {
                SwingWorkerVariant.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SwingWorkerVariant.this.construct();
                }
                finally {
                    SwingWorkerVariant.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(Thread.currentThread().getThreadGroup(), doConstruct);
        this.threadVar = new ThreadVar(t);
    }

    private void activateGlassPane() {
        GlassPane aPane = GlassPane.mount(this.getAComponent(), true);
        this.setGlassPane(aPane);
        if (this.getGlassPane() != null) {
            this.getGlassPane().setVisible(true);
        }
    }

    private void construct() {
        this.activateGlassPane();
        try {
            this.doNonUILogic();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof HibernateException) {
                AUIKataster.handleDBException(e, "SwingWorker.doNonUILogic", this.fatalError);
            }
            throw new RuntimeException("SwingWorker error in doNonUILogic", e);
        }
    }

    private void deactivateGlassPane() {
        if (this.getGlassPane() != null) {
            this.getGlassPane().setVisible(false);
        }
    }

    protected abstract void doNonUILogic() throws RuntimeException;

    protected abstract void doUIUpdateLogic() throws RuntimeException;

    protected void finished() {
        try {
            this.deactivateGlassPane();
            this.doUIUpdateLogic();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("SwingWorker error in doUIUpdateLogic", e);
        }
        finally {
            if (this.getAComponent() != null) {
                this.getAComponent().requestFocus();
            }
        }
    }

    protected Component getAComponent() {
        return this.aComponent;
    }

    protected GlassPane getGlassPane() {
        return this.glassPane;
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    protected void setAComponent(Component newAComponent) {
        this.aComponent = newAComponent;
    }

    protected void setGlassPane(GlassPane newGlassPane) {
        this.glassPane = newGlassPane;
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

