/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils;

import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RetractablePanel
extends JPanel {
    private JLabel iconLabel = null;
    private JPanel topPanel = null;
    private JPanel panel = null;
    private JComponent topComp = null;
    private Icon boxOpen = AuikUtils.getIcon("box_minus.png", "Open");
    private Icon boxClosed = AuikUtils.getIcon("box_plus.png", "Closed");
    private boolean open;

    public RetractablePanel(String name, JPanel content) {
        this(name, content, false, null);
    }

    public RetractablePanel(String name, JPanel content, String toolTip) {
        this(name, content, false, toolTip);
    }

    public RetractablePanel(String name, JPanel content, boolean isOpen, String toolTip) {
        this(new JLabel(name, 10), content, isOpen, toolTip);
    }

    public RetractablePanel(JComponent top, JPanel content, boolean isOpen, String toolTip) {
        super(new BorderLayout());
        this.iconLabel = new JLabel(this.boxOpen, 10);
        this.iconLabel.setToolTipText(toolTip);
        this.iconLabel.setAlignmentX(0.0f);
        this.topComp = top;
        this.topComp.setAlignmentX(0.0f);
        this.panel = content;
        this.topPanel = new JPanel();
        BoxLayout box = new BoxLayout(this.topPanel, 2);
        this.topPanel.setLayout(box);
        Cursor handCursor = Cursor.getPredefinedCursor(12);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    RetractablePanel.this.toggleOpen();
                }
            }
        };
        this.topPanel.add(this.iconLabel);
        this.topPanel.add(Box.createHorizontalStrut(5));
        this.topPanel.add(this.topComp);
        this.topPanel.setCursor(handCursor);
        this.iconLabel.addMouseListener(ml);
        this.topPanel.addMouseListener(ml);
        this.add((Component)this.topPanel, "North");
        this.setOpen(isOpen);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        Dimension newSize;
        this.open = open;
        if (open) {
            this.opening();
        } else {
            this.closing();
        }
        Dimension topSize = this.topPanel.getPreferredSize();
        Dimension contentSize = this.panel.getPreferredSize();
        if (open) {
            this.iconLabel.setIcon(this.boxOpen);
            this.add((Component)this.panel, "Center");
            int newHeight = topSize.height + contentSize.height;
            newSize = new Dimension(Math.max(topSize.width, contentSize.width), newHeight);
        } else {
            this.iconLabel.setIcon(this.boxClosed);
            this.remove(this.panel);
            newSize = topSize;
        }
        this.setMinimumSize(newSize);
        this.setPreferredSize(newSize);
        Container parent = this.getParent();
        if (parent != null) {
            if (parent instanceof JComponent) {
                ((JComponent)parent).revalidate();
            } else {
                parent.validate();
            }
            parent.repaint();
        }
    }

    public void toggleOpen() {
        this.setOpen(!this.isOpen());
    }

    public void opening() {
    }

    public void closing() {
    }
}

