/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils;

import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;

public class PDFExporter {
    private static PDFExporter INSTANCE;

    private PDFExporter() {
    }

    public static PDFExporter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PDFExporter();
        }
        return INSTANCE;
    }

    protected static JasperPrint export(Map fields, InputStream reportFile, String dest) throws Exception {
        JasperPrint print = JasperFillManager.fillReport((InputStream)reportFile, (Map)fields, (JRDataSource)new JREmptyDataSource(1));
        JasperExportManager.exportReportToPdfFile((JasperPrint)print, (String)dest);
        return print;
    }

    public JasperPrint exportAuftrag(Map fields, JRDataSource subdata, String dest, boolean printPDF) throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream("/reports/probenahmeauftrag.jasper");
        if (inputStream == null) {
            throw new Exception("Konnte Template 'probenahmeauftrag.jasper' nicht finden.");
        }
        fields.put("SUBDATA", subdata);
        try {
            JasperPrint jprint = PDFExporter.export(fields, inputStream, dest);
            if (printPDF) {
                PDFExporter.print(jprint);
            }
            return jprint;
        }
        catch (JRException jre) {
            throw new Exception("Druck des Probenahmeauftrag schlug fehl: " + jre.getMessage());
        }
    }

    public JasperPrint exportBescheid(Map fields, JRDataSource subdata, String dest, boolean printPDF) throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream("/reports/gebuehrenbescheid.jasper");
        if (inputStream == null) {
            throw new Exception("Konnte Template 'gebuehrenbescheid.jasper' nicht finden.");
        }
        fields.put("SUBDATA", subdata);
        try {
            JasperPrint jprint = PDFExporter.export(fields, inputStream, dest);
            if (printPDF) {
                PDFExporter.print(jprint);
            }
            return jprint;
        }
        catch (JRException jre) {
            throw new Exception("Druck des Geb\u00fchrenbescheid schlug fehl: " + jre.getMessage());
        }
    }

    public static void print(JasperPrint jprint) throws Exception {
        JasperPrintManager.printReport((JasperPrint)jprint, (boolean)true);
    }
}

