/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class JRMapDataSource
implements JRDataSource {
    protected int index;
    protected String[] columns;
    protected Map indexBuffer;
    protected Object[] current;
    protected Object[][] values;

    protected JRMapDataSource() {
        this.index = 0;
        this.indexBuffer = new HashMap();
        this.current = null;
    }

    public JRMapDataSource(String[] columns, Object[][] values) {
        this.columns = columns;
        this.values = values;
    }

    public int size() {
        return this.values != null ? this.values.length : -1;
    }

    public boolean next() {
        ++this.index;
        if (this.index <= this.size()) {
            this.current = this.values[this.index - 1];
            return true;
        }
        return false;
    }

    public Object getFieldValue(JRField field) throws JRException {
        String col = field.getName();
        int idx = this.getIndexOf(col);
        return idx >= 0 ? this.current[idx] : "";
    }

    public int getIndexOf(String col) {
        Object ib;
        if (this.indexBuffer == null) {
            this.indexBuffer = new HashMap();
        }
        if ((ib = this.indexBuffer.get(col)) != null) {
            return (Integer)ib;
        }
        int idx = 0;
        for (String column : this.columns) {
            if (column.equals(col)) {
                this.indexBuffer.put(col, new Integer(idx));
                return idx;
            }
            ++idx;
        }
        return -1;
    }
}

