/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils;

import de.bielefeld.umweltamt.aui.utils.BasicFormattedField;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class DoubleField
extends BasicFormattedField {
    public DoubleField(int minNachKommaStellen) {
        this(minNachKommaStellen, -1);
    }

    public DoubleField(int minNachKommaStellen, int maxNachKommaStellen) {
        NumberFormat doubleFormat = NumberFormat.getNumberInstance();
        doubleFormat.setGroupingUsed(false);
        doubleFormat.setMinimumFractionDigits(minNachKommaStellen);
        if (maxNachKommaStellen >= minNachKommaStellen && maxNachKommaStellen != -1) {
            doubleFormat.setMaximumFractionDigits(maxNachKommaStellen);
        } else {
            doubleFormat.setMaximumFractionDigits(5);
        }
        this.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(doubleFormat)));
    }

    public Double getDoubleValue() {
        Double nummer;
        try {
            this.commitEdit();
            nummer = this.getValue() instanceof Long ? new Double(((Long)this.getValue()).doubleValue()) : (Double)this.getValue();
        }
        catch (ParseException e) {
            nummer = null;
        }
        return nummer;
    }

    public Float getFloatValue() {
        Double val = this.getDoubleValue();
        if (val != null) {
            return new Float(val.floatValue());
        }
        return null;
    }
}

