/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class DoubleEditor
extends DefaultCellEditor {
    JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
    NumberFormat doubleFormat = NumberFormat.getNumberInstance();
    private boolean DEBUG = false;

    public DoubleEditor() {
        super(new JFormattedTextField());
        NumberFormatter doubleFormatter = new NumberFormatter(this.doubleFormat);
        doubleFormatter.setFormat(this.doubleFormat);
        this.ftf.setFormatterFactory(new DefaultFormatterFactory(doubleFormatter));
        this.ftf.setValue(new Double(0.0));
        this.ftf.setHorizontalAlignment(11);
        this.ftf.setFocusLostBehavior(3);
        this.setBorderNormal();
        this.ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.ftf.getActionMap().put("check", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DoubleEditor.this.ftf.isEditValid()) {
                    DoubleEditor.this.setBorderRed();
                    if (DoubleEditor.this.DEBUG) {
                        System.out.println("check: '" + DoubleEditor.this.ftf.getText() + "' is invalid!");
                    }
                } else {
                    try {
                        DoubleEditor.this.ftf.commitEdit();
                        DoubleEditor.this.setBorderNormal();
                        DoubleEditor.this.ftf.postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ftf.setValue(value);
        if (this.DEBUG) {
            System.out.println("getTableCellEditorComp: " + isSelected + ", " + row + ", " + column);
        }
        return ftf;
    }

    @Override
    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof Double) {
            return o;
        }
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        if (this.DEBUG) {
            System.out.println("getCellEditorValue: o isn't a Number");
        }
        try {
            return this.doubleFormat.parseObject(o.toString());
        }
        catch (ParseException exc) {
            System.err.println("getCellEditorValue: can't parse o: " + o);
            return null;
        }
    }

    @Override
    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (ftf.isEditValid()) {
            this.setBorderNormal();
            try {
                ftf.commitEdit();
            }
            catch (ParseException parseException) {}
        } else {
            this.setBorderRed();
            if (this.DEBUG) {
                System.out.println("stopCellEditing: '" + ftf.getText() + "' is invalid!");
            }
            return false;
        }
        return super.stopCellEditing();
    }

    public void setBorderNormal() {
        this.ftf.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    public void setBorderRed() {
        this.ftf.setBorder(BorderFactory.createLineBorder(Color.RED));
    }
}

