/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final String FORMAT_DATETIME = "dd.MM.yyyy hh:mm";
    public static final String FORMAT_DATE = "dd.MM.yyyy";
    public static final String FORMAT_TIME = "HH:mm";
    public static final String FORMAT_KASSE = "ddmmyyyy";
    public static final int BILLING_DEADLINE = 31;

    public static String format(Date date, String format) {
        if (format == null || date == null || format.equals("")) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static Date parse(String date, String format) throws ParseException {
        if (format == null || date == null || format.equals("")) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_TIME);
        return df.parse(date);
    }

    public static String getDuration(Date start, Date end) {
        if (start == null || end == null) {
            return "--:--";
        }
        long duration = (end.getTime() - start.getTime()) / 1000L;
        int seconds = DateUtils.getSeconds(duration);
        int minutes = DateUtils.getMinutes(duration);
        int hours = DateUtils.getHours(duration);
        String h = hours <= 9 ? "0" + hours : "" + hours;
        String m = minutes <= 9 ? "0" + minutes : "" + minutes;
        return h + ":" + m;
    }

    public static double getDurationHours(Date start, Date end) {
        if (start == null || end == null) {
            return 0.0;
        }
        long duration = (end.getTime() - start.getTime()) / 1000L;
        int hours = DateUtils.getHours(duration);
        int minutes = DateUtils.getMinutes(duration);
        return (double)hours + (double)minutes / 60.0;
    }

    protected static int getSeconds(long seconds) {
        return (int)seconds % 60;
    }

    protected static int getMinutes(long seconds) {
        return (int)(seconds /= 60L) % 60;
    }

    protected static int getHours(long seconds) {
        return (int)(seconds /= 3600L) % 60;
    }

    public static Date getDateOfBill(Date notification) throws NullPointerException {
        if (notification == null) {
            throw new NullPointerException("Empty Date object not permitted.");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(notification);
        int index = 0;
        do {
            cal.add(5, 1);
            int day = cal.get(7);
            if (day == 7 || day == 1) continue;
            ++index;
        } while (index != 31);
        return cal.getTime();
    }
}

