/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils;

import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class Charts {
    private Charts() {
    }

    public static JFreeChart createDefaultTimeSeriesChart(String titel, TimeSeriesCollection dataset) {
        String tmp = null;
        return Charts.createDefaultTimeSeriesChart(titel, tmp, dataset);
    }

    public static JFreeChart createDefaultTimeSeriesChart(String titel, String unterTitel, TimeSeriesCollection dataset) {
        String tmp = null;
        return Charts.createDefaultTimeSeriesChart(titel, unterTitel, tmp, dataset);
    }

    public static JFreeChart createDefaultTimeSeriesChart(String titel, String unterTitel, String yTitel, TimeSeriesCollection dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)titel, (String)"Datum", (String)yTitel, (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(true);
        if (unterTitel != null && !unterTitel.equals("")) {
            TextTitle subTitle = new TextTitle(unterTitel);
            subTitle.setPosition(RectangleEdge.TOP);
            chart.addSubtitle((Title)subTitle);
        }
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        if (yTitel == null && dataset.getSeriesCount() > 0) {
            TimeSeries series = dataset.getSeries(0);
            axis.setLabel(series.getRangeDescription());
        }
        StandardXYToolTipGenerator ttgen = new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("dd.MM.yy HH:mm"), NumberFormat.getInstance());
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        renderer.setDefaultShapesVisible(true);
        renderer.setDefaultShapesFilled(true);
        renderer.setToolTipGenerator((XYToolTipGenerator)ttgen);
        DateAxis datumsAchse = (DateAxis)plot.getDomainAxis();
        datumsAchse.setVerticalTickLabels(true);
        return chart;
    }

    public static JFreeChart createDefaultTimeSeriesChart(String titel, TimeSeriesCollection dataset1, TimeSeriesCollection dataset2) {
        return Charts.createDefaultTimeSeriesChart(titel, null, null, null, dataset1, dataset2);
    }

    public static JFreeChart createDefaultTimeSeriesChart(String titel, String unterTitel, TimeSeriesCollection dataset1, TimeSeriesCollection dataset2) {
        return Charts.createDefaultTimeSeriesChart(titel, unterTitel, null, null, dataset1, dataset2);
    }

    public static JFreeChart createDefaultTimeSeriesChart(String titel, String unterTitel, String yTitel1, String yTitel2, TimeSeriesCollection dataset1, TimeSeriesCollection dataset2) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)titel, (String)"Datum", (String)yTitel1, (XYDataset)dataset1, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(true);
        if (unterTitel != null && !unterTitel.equals("")) {
            TextTitle subTitle = new TextTitle(unterTitel);
            subTitle.setPosition(RectangleEdge.TOP);
            chart.addSubtitle((Title)subTitle);
        }
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        NumberAxis axis1 = (NumberAxis)plot.getRangeAxis();
        if (yTitel1 == null && dataset1.getSeriesCount() > 0) {
            TimeSeries series = dataset1.getSeries(0);
            axis1.setLabel(series.getRangeDescription());
        }
        NumberAxis axis2 = new NumberAxis(yTitel2);
        axis2.setAutoRangeIncludesZero(false);
        if (yTitel2 == null && dataset2.getSeriesCount() > 0) {
            TimeSeries series = dataset2.getSeries(0);
            axis2.setLabel(series.getRangeDescription());
        }
        plot.setRangeAxis(1, (ValueAxis)axis2);
        plot.setDataset(1, (XYDataset)dataset2);
        plot.setRenderer(1, (XYItemRenderer)new XYLineAndShapeRenderer());
        plot.mapDatasetToRangeAxis(1, 1);
        DateAxis datumsAchse = (DateAxis)plot.getDomainAxis();
        datumsAchse.setVerticalTickLabels(true);
        StandardXYToolTipGenerator ttgen = new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("dd.MM.yy hh:mm"), NumberFormat.getInstance());
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        renderer.setDefaultShapesVisible(true);
        renderer.setDefaultShapesFilled(true);
        renderer.setToolTipGenerator((XYToolTipGenerator)ttgen);
        if (dataset1.getSeriesCount() == 1) {
            axis1.setLabelPaint(renderer.getSeriesPaint(0));
        }
        XYLineAndShapeRenderer renderer2 = (XYLineAndShapeRenderer)plot.getRenderer(1);
        renderer2.setDefaultShapesVisible(true);
        renderer2.setDefaultShapesFilled(true);
        renderer2.setToolTipGenerator((XYToolTipGenerator)ttgen);
        if (dataset2.getSeriesCount() == 1) {
            axis2.setLabelPaint(renderer2.getSeriesPaint(0));
        }
        LegendTitle l1 = new LegendTitle((LegendItemSource)renderer);
        l1.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 5.0));
        l1.setBorder(new BlockBorder());
        LegendTitle l2 = new LegendTitle((LegendItemSource)renderer2);
        l2.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 5.0));
        l2.setBorder(new BlockBorder());
        BlockContainer cont = new BlockContainer();
        cont.add((Block)l1, (Object)RectangleEdge.LEFT);
        cont.add((Block)l2, (Object)RectangleEdge.RIGHT);
        CompositeTitle compLegend = new CompositeTitle(cont);
        compLegend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        compLegend.setPosition(RectangleEdge.BOTTOM);
        chart.addSubtitle((Title)compLegend);
        return chart;
    }
}

