/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class ChartDataSets {
    private ChartDataSets() {
    }

    public static TimeSeriesCollection createDataset(TimeSeries series) {
        TimeSeriesCollection dataset = new TimeSeriesCollection(series);
        dataset.setDomainIsPointsInTime(true);
        return dataset;
    }

    public static TimeSeries createAnalysePositionenSeries(List list, String name, String einheit) {
        TimeSeries result = new TimeSeries(name, "Datum", "[" + einheit + "]", Minute.class);
        AUIKataster.debugOutput("Erzeuge TimeSeries: " + name, "ChartDataSets.createAnalysepositionenSeries");
        Calendar cal = GregorianCalendar.getInstance();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof AtlAnalyseposition)) continue;
                AtlAnalyseposition pos = (AtlAnalyseposition)list.get(i);
                int hour = 0;
                int minute = 0;
                cal.setTime(pos.getAtlProbenahmen().getDatumDerEntnahme());
                if (pos.getAtlProbenahmen().getZeitDerEntnahmen() != null) {
                    String zeit = pos.getAtlProbenahmen().getZeitDerEntnahmen();
                    hour = Integer.parseInt(zeit.substring(0, 2));
                    minute = Integer.parseInt(zeit.substring(3, 5));
                }
                Minute min = new Minute(minute, hour, cal.get(5), cal.get(2) + 1, cal.get(1));
                ChartDataSets.addPosToMinuteSeries(result, min, pos);
            }
        }
        return result;
    }

    private static void addPosToMinuteSeries(TimeSeries series, Minute minute, AtlAnalyseposition pos) {
        if (series.getDataItem((RegularTimePeriod)minute) == null) {
            series.add((RegularTimePeriod)minute, (Number)pos.getWert());
        } else {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(pos.getAtlProbenahmen().getDatumDerEntnahme());
            Minute min2 = new Minute(minute.getMinute() + 1, minute.getHour().getHour(), cal.get(5), cal.get(2) + 1, cal.get(1));
            ChartDataSets.addPosToMinuteSeries(series, min2, pos);
        }
    }
}

