/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.utils;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import javax.swing.text.MaskFormatter;

public class AuikUtils {
    public static final String DATUMSFORMAT = "dd.MM.yy";
    public static final String[] DATUMSFORMATE = new String[]{"dd.MM.yy", "dd.MM.yyyy"};
    private static Calendar cal = null;

    public static void spawnFileProg(File f) {
        if (f.exists() && f.isFile() && f.canRead()) {
            String comspec = "cmd";
            if (comspec == null) {
                comspec = "cmd";
            }
            try {
                Runtime.getRuntime().exec(comspec + " /c start \"Bitte warten...\" " + f.getName(), null, f.getParentFile());
            }
            catch (IOException e) {
                throw new RuntimeException("Konnte den Betrachter f\u00fcr " + f + " nicht starten!", e);
            }
        } else {
            AUIKataster.debugOutput("Fehler beim spawnFileProg f\u00fcr " + f, "AuikUtils");
        }
    }

    public static String getExtension(File f) {
        String s;
        int i;
        String ext = null;
        if (f != null && (i = (s = f.getName()).lastIndexOf(46)) > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static FileFilter getExtensionFilter(final String extension) {
        FileFilter tmp = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fExtension = AuikUtils.getExtension(f);
                if (fExtension != null) {
                    return fExtension.equals(extension);
                }
                return false;
            }

            @Override
            public String getDescription() {
                return AuikUtils.getFileDescription(extension);
            }
        };
        return tmp;
    }

    public static FileFilter getExtensionsFilter(final String[] extensions) {
        FileFilter tmp = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fExtension = AuikUtils.getExtension(f);
                if (fExtension != null) {
                    for (int i = 0; i < extensions.length; ++i) {
                        if (!fExtension.equals(extensions[i])) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                String desc = "Alle unterst\u00fctzten Dateitypen";
                if (extensions.length < 6) {
                    desc = desc + " (";
                    for (int i = 0; i < extensions.length; ++i) {
                        if (i != 0) {
                            desc = desc + ", ";
                        }
                        desc = desc + "*." + extensions[i];
                    }
                    desc = desc + ")";
                }
                return desc;
            }
        };
        return tmp;
    }

    public static String getFileDescription(String extension) {
        String ext = extension.toLowerCase();
        String desc = ext.equals("txt") ? "Textdatei" : (ext.equals("csv") ? "CSV (Trennzeichen getrennt)" : (ext.equals("png") ? "PNG-Datei (Portable Network Graphics)" : extension.toUpperCase() + "-Datei"));
        return desc + " (*." + ext + ")";
    }

    public static void saveTabelle(JTable tabelle, HauptFrame frame) {
        File exportDatei = frame.saveFile(new String[]{"csv"});
        if (exportDatei != null) {
            String ext = AuikUtils.getExtension(exportDatei);
            if (ext == null) {
                String newExt = exportDatei.getName().endsWith(".") ? "csv" : ".csv";
                exportDatei = new File(exportDatei.getParent(), exportDatei.getName() + newExt);
            }
            boolean doIt = false;
            if (exportDatei.exists()) {
                boolean answer = frame.showQuestion("Soll die vorhandene Datei " + exportDatei.getName() + " wirklich \u00fcberschrieben werden?", "Datei bereits vorhanden!");
                if (answer && exportDatei.canWrite()) {
                    doIt = true;
                }
            } else if (exportDatei.getParentFile().canWrite()) {
                doIt = true;
            }
            if (doIt) {
                AUIKataster.debugOutput("Speichere nach '" + exportDatei.getName() + "' (Ext: '" + ext + "') in '" + exportDatei.getParent() + "' !");
                if (AuikUtils.exportTableDataToCVS(tabelle, exportDatei)) {
                    AUIKataster.debugOutput("Speichern erfolgreich!");
                } else {
                    AUIKataster.debugOutput("Fehler beim Speichern!");
                    frame.showErrorMessage("Beim Speichern der Datei '" + exportDatei + "' trat ein Fehler auf!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportTableDataToCVS(JTable table, File file) {
        boolean success;
        TableModel model = table.getModel();
        BufferedWriter bw = null;
        try {
            file.createNewFile();
            bw = new BufferedWriter(new FileWriter(file));
            for (int h = 0; h < model.getColumnCount(); ++h) {
                bw.write(model.getColumnName(h));
                if (h + 1 == model.getColumnCount()) continue;
                bw.write(";");
            }
            bw.newLine();
            int clmCnt = model.getColumnCount();
            int rowCnt = model.getRowCount();
            for (int i = 0; i < rowCnt; ++i) {
                for (int j = 0; j < clmCnt; ++j) {
                    if (model.getValueAt(i, j) != null) {
                        String value = model.getValueAt(i, j).toString();
                        value = value.replace('\n', ' ');
                        bw.write(value);
                    }
                    if (j + 1 == clmCnt) continue;
                    bw.write(";");
                }
                bw.newLine();
            }
            bw.flush();
            success = true;
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e1) {
                    throw new RuntimeException("Datei-Fehler (AuIKUtils)", e1);
                }
            }
        }
        return success;
    }

    public static MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            AUIKataster.debugOutput("formatter is bad: " + exc.getMessage(), "AuikUtils.createFormatter");
        }
        return formatter;
    }

    public static String sanitizeQueryInput(String input) {
        return input.replaceAll(";", "").replaceAll("'", "").replaceAll("\\(", "").replaceAll("\\)", "").trim();
    }

    public static String getStringFromDate(Date date) {
        if (date != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            int day = cal.get(5);
            String dayString = day < 10 ? "0" + day : "" + day;
            int month = cal.get(2) + 1;
            String monthString = month < 10 ? "0" + month : "" + month;
            return dayString + "." + monthString + "." + cal.get(1);
        }
        return null;
    }

    public static String getStringFromCurrentDate() {
        return AuikUtils.getStringFromDate(AuikUtils.getCurrentDate());
    }

    public static Date getCurrentDate() {
        if (cal == null) {
            cal = GregorianCalendar.getInstance();
        } else {
            cal.setTimeInMillis(System.currentTimeMillis());
        }
        return cal.getTime();
    }

    public static Icon getIcon(String filename) {
        return AuikUtils.getIcon(filename, null);
    }

    public static Icon getIcon(int size, String filename) {
        return AuikUtils.getIcon(size, filename, null);
    }

    public static Icon getIcon(String filename, String description) {
        return AuikUtils.getIcon(-1, filename, description);
    }

    public static Icon getIcon(int size, String filename, String description) {
        if (filename == null) {
            filename = "default.png";
        }
        if (description == null) {
            description = "Icon: " + filename;
        }
        String sSize = size == -1 ? "" : size + "/";
        String iconPath = "icons/" + sSize + filename;
        URL iconURL = AUIKataster.class.getResource(iconPath);
        if (iconURL != null) {
            return new ImageIcon(iconURL, description);
        }
        AUIKataster.debugOutput("Konnte Icon " + iconPath + " nicht finden!", "AuikUtils.getIcon");
        return null;
    }

    public static boolean isUsingXpStyle() {
        Toolkit toolkit;
        boolean themeActive;
        LookAndFeel laf = UIManager.getLookAndFeel();
        boolean tmp = laf instanceof WindowsLookAndFeel && !laf.getClass().getName().endsWith("WindowsClassicLookAndFeel") ? (System.getProperty("swing.noxp") != null ? false : (themeActive = Boolean.TRUE.equals((toolkit = Toolkit.getDefaultToolkit()).getDesktopProperty("win.xpstyle.themeActive")))) : false;
        return tmp;
    }
}

