/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.tests;

import de.bielefeld.umweltamt.aui.mappings.atl.AtlSielhaut;
import java.util.List;
import junit.framework.TestCase;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

public class SielhautTest
extends TestCase {
    private SessionFactory _sessionFactory;
    private static final String Messstelle = "JUnit";
    private int _id;

    protected void setUp() throws Exception {
        super.setUp();
        Configuration configuration = new Configuration().configure();
        this._sessionFactory = configuration.buildSessionFactory();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._sessionFactory.close();
    }

    public void testErzeugen() {
        String id = "leer";
        this._id = this.erzeugeSielhaut(Messstelle);
        if (this._id != 0) {
            id = "vorhanden";
        }
        SielhautTest.assertEquals((String)id, (String)"vorhanden");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtlSielhaut testQuery() {
        Session session = null;
        try {
            session = this._sessionFactory.openSession();
            List result = AtlSielhaut.findPunkte(Messstelle);
            AtlSielhaut sielhaut = (AtlSielhaut)result.get(0);
            SielhautTest.assertEquals((String)Messstelle, (String)sielhaut.getBezeichnung());
            AtlSielhaut atlSielhaut = sielhaut;
            return atlSielhaut;
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdate() {
        Session session = null;
        try {
            session = this._sessionFactory.openSession();
            AtlSielhaut sielhaut = this.testQuery();
            Transaction transaction = session.beginTransaction();
            sielhaut.setBemerkungen("neue");
            AtlSielhaut.saveSielhautPunkt(sielhaut);
            transaction.commit();
            session.close();
            session = this._sessionFactory.openSession();
            sielhaut = this.testQuery();
            SielhautTest.assertEquals((String)Messstelle, (String)sielhaut.getBezeichnung());
            SielhautTest.assertEquals((String)"neue", (String)sielhaut.getBemerkungen());
            this.Delete();
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Delete() {
        Session session = null;
        try {
            session = this._sessionFactory.openSession();
            AtlSielhaut sielhaut = this.testQuery();
            Transaction transaction = session.beginTransaction();
            session.delete((Object)sielhaut);
            transaction.commit();
            session.close();
            session = this._sessionFactory.openSession();
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int erzeugeSielhaut(String messstelle) {
        AtlSielhaut sielhaut = new AtlSielhaut();
        sielhaut.setBezeichnung(messstelle);
        Session session = null;
        Transaction transaction = null;
        try {
            session = this._sessionFactory.openSession();
            transaction = session.beginTransaction();
            AtlSielhaut.saveSielhautPunkt(sielhaut);
            transaction.commit();
        }
        catch (HibernateException e) {
            if (transaction != null) {
                transaction.rollback();
                throw e;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return sielhaut.getId();
    }
}

