/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.tests;

import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektarten;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektchrono;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStandort;
import java.util.List;
import junit.framework.TestCase;

public class ObjektTest
extends TestCase {
    private int _id;
    private int chronoid;
    private BasisStandort standort;
    private BasisBetreiber betreiber;
    private BasisObjektarten objektart;

    protected void setUp() throws Exception {
        super.setUp();
        this.betreiber = this.findeBetreiber();
        this.standort = this.findeStandort();
        this.objektart = this.findeObjektart();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testErzeugen() {
        String id = "leer";
        this._id = this.erzeugeObjekt(this.betreiber, this.standort, this.objektart);
        if (this._id != 0) {
            id = "vorhanden";
        }
        ObjektTest.assertEquals((String)id, (String)"vorhanden");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasisObjekt testQuery() {
        Object session = null;
        List result = BasisObjekt.getObjekteByStandort(this.standort, null, 16);
        BasisObjekt objekt = (BasisObjekt)result.get(0);
        ObjektTest.assertEquals((Object)this.betreiber, (Object)objekt.getBasisBetreiber());
        BasisObjekt basisObjekt = objekt;
        return basisObjekt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdate() {
        BasisObjekt objekt = this.testQuery();
        objekt.setBeschreibung("neue");
        BasisObjekt.saveBasisObjekt(objekt);
        objekt = this.testQuery();
        ObjektTest.assertEquals((Object)this.betreiber, (Object)objekt.getBasisBetreiber());
        ObjektTest.assertEquals((String)"neue", (String)objekt.getBeschreibung());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChrono() {
        BasisObjekt objekt = this.testQuery();
        List chronolist = BasisObjektchrono.getChronoByObjekt(objekt);
        BasisObjektchrono chrono = (BasisObjektchrono)chronolist.get(0);
        ObjektTest.assertEquals((int)1, (int)chronolist.size());
        ObjektTest.assertEquals((String)"JUNIT", (String)chrono.getSachbearbeiter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelete() {
        BasisObjekt objekt = this.testQuery();
        List chronolist = BasisObjektchrono.getChronoByObjekt(objekt);
        BasisObjektchrono chrono = (BasisObjektchrono)chronolist.get(0);
        BasisObjektchrono.removeObjektChrono(chrono);
        BasisObjekt.removeBasisObjekt(objekt);
        List result = BasisObjekt.getObjekteByStandort(this.standort, 1);
        ObjektTest.assertEquals((int)0, (int)result.size());
    }

    private int erzeugeObjekt(BasisBetreiber betreiber, BasisStandort standort, BasisObjektarten objektart) {
        BasisObjekt objekt = new BasisObjekt();
        objekt.setBasisBetreiber(betreiber);
        objekt.setBasisObjektarten(objektart);
        objekt.setBasisStandort(standort);
        BasisObjektchrono chrono = new BasisObjektchrono();
        objekt = BasisObjekt.saveBasisObjekt(objekt);
        chrono.setBasisObjekt(objekt);
        chrono.setSachbearbeiter("JUNIT");
        BasisObjektchrono.saveObjektChrono(chrono);
        this.chronoid = chrono.getId();
        return objekt.getObjektid();
    }

    private BasisStandort findeStandort() {
        BasisStandort standort = BasisStandort.getStandort(1);
        return standort;
    }

    private BasisBetreiber findeBetreiber() {
        BasisBetreiber betreiber = BasisBetreiber.getBetreiber(1);
        return betreiber;
    }

    private BasisObjektarten findeObjektart() {
        BasisObjektarten objektart = BasisObjektarten.getObjektart(1);
        return objektart;
    }
}

