/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.tests;

import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh40Fachdaten;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Abscheiderdetails;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Fachdaten;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh50Fachdaten;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh52Fachdaten;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh53Fachdaten;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh55Fachdaten;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh56Fachdaten;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AnhSuevFachdaten;
import de.bielefeld.umweltamt.aui.mappings.indeinl.IndeinlGenehmigung;
import de.bielefeld.umweltamt.aui.mappings.indeinl.IndeinlUebergabestelle;
import de.bielefeld.umweltamt.aui.mappings.indeinl.ViewBwk;
import java.util.List;
import junit.framework.TestCase;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

public class AuswertungTest
extends TestCase {
    private SessionFactory _sessionFactory;

    protected void setUp() throws Exception {
        super.setUp();
        Configuration configuration = new Configuration().configure();
        this._sessionFactory = configuration.buildSessionFactory();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._sessionFactory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusAnh40() {
        Session session = null;
        try {
            List listquery;
            session = this._sessionFactory.openSession();
            List list = Anh40Fachdaten.getAuswertungsListe();
            String query = "from Anh40Fachdaten as anh40 order by anh40.basisObjekt.inaktiv, anh40.id";
            try {
                listquery = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)listquery.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusAnh49() {
        Session session = null;
        try {
            List listquery;
            session = this._sessionFactory.openSession();
            List list = Anh49Fachdaten.findAlle();
            String query = "from Anh49Fachdaten anh49 where anh49.basisObjekt.basisObjektarten.objektart not like 'Fettabscheider' order by anh49.basisObjekt.inaktiv, anh49.sachbearbeiterIn";
            try {
                listquery = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)listquery.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusAnh50() {
        Session session = null;
        try {
            List listquery;
            session = this._sessionFactory.openSession();
            List list = Anh50Fachdaten.findByWiedervorlage(false);
            String query = "from Anh50Fachdaten as ah50 where ah50.erloschen = 'f' order by ah50.basisObjekt.inaktiv, ah50.wiedervorlage, ah50.basisObjekt.basisBetreiber.betrname";
            try {
                listquery = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)listquery.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusAnh52() {
        Session session = null;
        try {
            List listquery;
            session = this._sessionFactory.openSession();
            List list = Anh52Fachdaten.getAuswertungsListe();
            String query = "from Anh52Fachdaten as anh52 order by anh52.basisObjekt.inaktiv, anh52.id";
            try {
                listquery = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)listquery.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusAnh53() {
        Session session = null;
        try {
            List listquery;
            session = this._sessionFactory.openSession();
            List list = Anh53Fachdaten.getAuswertungsListe();
            String query = "from Anh53Fachdaten as anh53 order by anh53.basisObjekt.inaktiv, anh53.basisObjekt.basisObjektarten.objektartid, anh53.basisObjekt.basisStandort.strasse, anh53.basisObjekt.basisStandort.hausnr";
            try {
                listquery = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)listquery.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusAnh55() {
        Session session = null;
        try {
            List listquery;
            session = this._sessionFactory.openSession();
            List list = Anh55Fachdaten.getAuswertungsListe();
            String query = "from Anh55Fachdaten as anh55 order by anh55.basisObjekt.inaktiv, anh55.id";
            try {
                listquery = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)listquery.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusAnh56() {
        Session session = null;
        try {
            List listquery;
            session = this._sessionFactory.openSession();
            List list = Anh56Fachdaten.getAuswertungsListe();
            String query = "from Anh56Fachdaten as anh56 order by anh56.basisObjekt.inaktiv, anh56.basisObjekt.basisStandort.strasse, anh56.basisObjekt.basisStandort.hausnr";
            try {
                listquery = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)listquery.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusFettabsch() {
        Session session = null;
        try {
            List fettabsch;
            session = this._sessionFactory.openSession();
            List list = Anh49Abscheiderdetails.getFettabschListe();
            String query = "from Anh49Abscheiderdetails details where details.Anh49Fachdaten.basisObjekt.basisObjektarten.objektart like 'Fettabscheider' order by details.Anh49Fachdaten.basisObjekt.inaktiv, details.Anh49Fachdaten.basisObjekt.basisBetreiber.betrname";
            try {
                fettabsch = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            String query2 = "from Anh49Fachdaten anh49 where anh49.basisObjekt.basisObjektarten.objektart like 'Fettabscheider' order by anh49.basisObjekt.inaktiv, anh49.basisObjekt.basisBetreiber.betrname";
            List fettabsch2 = session.createQuery(query2).list();
            for (int j = 0; j < fettabsch2.size(); ++j) {
                Anh49Fachdaten item = (Anh49Fachdaten)fettabsch2.get(j);
                if (Anh49Abscheiderdetails.getAbscheiderDetails(item).size() != 0) continue;
                fettabsch.add(item);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)fettabsch.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusUebergabe() {
        Session session = null;
        try {
            List listquery;
            session = this._sessionFactory.openSession();
            List list = IndeinlUebergabestelle.getAuswertungsListe();
            String query = "from IndeinlUebergabestelle as stelle order by stelle.objektid";
            try {
                listquery = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)listquery.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusBWK() {
        Session session = null;
        try {
            List listquery;
            session = this._sessionFactory.openSession();
            List list = ViewBwk.findByErfassungsjahr(2010);
            String query = "from ViewBwk as bwk where bwk.erfassung = 2010";
            try {
                listquery = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)listquery.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusGenehmigung() {
        Session session = null;
        try {
            List listquery;
            session = this._sessionFactory.openSession();
            List list = IndeinlGenehmigung.getAuswertungsListe(true, true);
            String query = "from IndeinlGenehmigung as gen where gen.gen58 = 't' or gen.gen59 = 't' order by gen.basisObjekt.inaktiv, gen.basisObjekt.basisBetreiber.betrname";
            try {
                listquery = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)listquery.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAusSuev() {
        Session session = null;
        try {
            List listquery;
            session = this._sessionFactory.openSession();
            List list = AnhSuevFachdaten.getAuswertungsListe();
            String query = "from AnhSuevFachdaten as sv order by sv.basisObjekt.inaktiv, sv.objektid";
            try {
                listquery = session.createQuery(query).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException(e);
            }
            AuswertungTest.assertEquals((int)list.size(), (int)listquery.size());
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
    }
}

