/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.ReportManager;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsAnlagenarten;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.editors.VawsEditor;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.VawsModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class VawsPanel
extends JPanel {
    private String name = "VAwS";
    private BasisObjektBearbeiten hauptModul;
    private VawsModel vawsModel;
    private Action vawsEditAction;
    private Action vawsLoeschAction;
    private Action reportAnlageAction;
    private JPopupMenu vawsPopup;
    private JTable vawsTable;
    protected Integer objektid;
    protected String betreiber;
    protected String standort;
    protected String art;
    protected Integer behaelterid;
    private JComboBox anlagenartBox;
    private JButton anlegenButton;
    private JButton reportListeButton;
    private JButton reportAnlageButton;

    public VawsPanel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        this.vawsModel = new VawsModel();
        JScrollPane vawsScroller = new JScrollPane(this.getVawsTable());
        this.anlagenartBox = new JComboBox<String>(VawsAnlagenarten.getAnlagenarten());
        this.anlegenButton = new JButton("Anlegen");
        this.anlegenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VawsPanel.this.neuerDatensatz();
            }
        });
        this.reportListeButton = new JButton("PDF-Liste generieren");
        this.reportListeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VawsPanel.this.showReportListe();
            }
        });
        this.reportAnlageButton = new JButton("PDF-Datenblatt generieren");
        this.reportAnlageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VawsPanel.this.showReportAnlage();
            }
        });
        FormLayout layout = new FormLayout("pref, 3dlu, pref, 3dlu, pref, 10dlu:g, pref, 3dlu, pref", "f:100dlu:g, 3dlu, pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.append((Component)vawsScroller, 9);
        builder.nextLine(2);
        builder.append("Neue(n)", (Component)this.anlagenartBox, (Component)this.anlegenButton);
        builder.append((Component)this.reportListeButton, (Component)this.reportAnlageButton);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void fetchFormData() {
        this.vawsModel.setList(VawsFachdaten.getVawsByObjekt(this.hauptModul.getObjekt()));
    }

    public void updateForm() {
        this.vawsModel.fireTableDataChanged();
    }

    public void neuerDatensatz() {
        VawsFachdaten neu = new VawsFachdaten();
        neu.setBasisObjekt(this.hauptModul.getObjekt());
        neu.setAnlagenart((String)this.anlagenartBox.getSelectedItem());
        this.editDatensatz(neu);
    }

    public void editDatensatz(VawsFachdaten fd) {
        VawsEditor editor = new VawsEditor(fd, this.hauptModul.getFrame());
        editor.setVisible(true);
        if (editor.wasSaved()) {
            this.fetchFormData();
            this.updateForm();
        }
    }

    public void loescheDatensatz(VawsFachdaten fd) {
        String art = fd.getAnlagenart();
        if (fd.isLageranlage()) {
            art = "Lageranlage";
        }
        if (this.hauptModul.getFrame().showQuestion("Soll die ausgew\u00e4hlte " + art + " wirklich gel\u00f6scht werden?", "L\u00f6schen best\u00e4tigen")) {
            if (VawsFachdaten.removeFachdaten(fd)) {
                this.hauptModul.getFrame().changeStatus("Fachdatensatz '" + fd + "' erfolgreich gel\u00f6scht!", HauptFrame.SUCCESS_COLOR);
                this.fetchFormData();
                this.updateForm();
            } else {
                this.hauptModul.getFrame().showErrorMessage("Konnte Fachdatensatz '" + fd + "' nicht l\u00f6schen!");
            }
        }
    }

    public void showReportListe() {
        this.betreiber = this.hauptModul.getObjekt().getBasisBetreiber().toString();
        this.standort = this.hauptModul.getObjekt().getBasisStandort().toString();
        this.art = this.hauptModul.getObjekt().getBasisObjektarten().getObjektart();
        this.objektid = this.hauptModul.getObjekt().getObjektid();
        if (this.betreiber != null || this.standort != null || this.objektid != null || this.art != null) {
            ReportManager.getInstance().startReportWorker("VAwS-Liste", this.objektid, this.betreiber, this.standort, this.art, this.reportListeButton);
        }
    }

    public void showReportAnlage() {
        int row = this.getVawsTable().getSelectedRow();
        if (row != -1) {
            VawsFachdaten anlage = this.vawsModel.getDatenSatz(row);
            this.betreiber = this.hauptModul.getObjekt().getBasisBetreiber().toString();
            this.standort = this.hauptModul.getObjekt().getBasisStandort().toString();
            this.art = this.hauptModul.getObjekt().getBasisObjektarten().getObjektart();
            this.behaelterid = anlage.getBehaelterId();
            if (this.betreiber != null || this.standort != null || this.behaelterid != null) {
                ReportManager.getInstance().startReportWorker("VAwS-Anlage", this.behaelterid, this.betreiber, this.standort, this.reportListeButton, this.art);
            } else {
                this.hauptModul.getFrame().changeStatus("Keine Anlage ausgew\u00e4hlt!", HauptFrame.ERROR_COLOR);
            }
        }
    }

    private Action getVawsEditAction() {
        if (this.vawsEditAction == null) {
            this.vawsEditAction = new AbstractAction("Bearbeiten"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = VawsPanel.this.getVawsTable().getSelectedRow();
                    if (row != -1) {
                        VawsFachdaten fd = VawsPanel.this.vawsModel.getDatenSatz(row);
                        VawsPanel.this.editDatensatz(fd);
                    }
                }
            };
            this.vawsEditAction.putValue("MnemonicKey", new Integer(66));
            this.vawsEditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
        }
        return this.vawsEditAction;
    }

    private Action getVawsLoeschAction() {
        if (this.vawsLoeschAction == null) {
            this.vawsLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = VawsPanel.this.getVawsTable().getSelectedRow();
                    if (row != -1) {
                        VawsFachdaten fd = VawsPanel.this.vawsModel.getDatenSatz(row);
                        VawsPanel.this.loescheDatensatz(fd);
                    }
                }
            };
            this.vawsLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.vawsLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.vawsLoeschAction;
    }

    private Action getReportAnlageAction() {
        if (this.reportAnlageAction == null) {
            this.reportAnlageAction = new AbstractAction("PDF-Datenblatt generieren"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VawsPanel.this.showReportAnlage();
                }
            };
            this.reportAnlageAction.putValue("MnemonicKey", new Integer(68));
        }
        return this.reportAnlageAction;
    }

    private void showVawsPopup(MouseEvent e) {
        if (this.vawsPopup == null) {
            this.vawsPopup = new JPopupMenu("VAWS");
            this.vawsPopup.add(new JMenuItem(this.getVawsEditAction()));
            this.vawsPopup.add(new JMenuItem(this.getVawsLoeschAction()));
            this.vawsPopup.add(new JMenuItem(this.getReportAnlageAction()));
        }
        if (e.isPopupTrigger()) {
            Point origin = e.getPoint();
            int row = this.getVawsTable().rowAtPoint(origin);
            if (row != -1) {
                this.getVawsTable().setRowSelectionInterval(row, row);
                this.vawsPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private JTable getVawsTable() {
        if (this.vawsTable == null) {
            this.vawsTable = new JTable(this.vawsModel);
            this.vawsTable.setSelectionMode(0);
            this.vawsTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = VawsPanel.this.vawsTable.rowAtPoint(origin);
                        VawsFachdaten fd = VawsPanel.this.vawsModel.getDatenSatz(row);
                        VawsPanel.this.editDatensatz(fd);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    VawsPanel.this.showVawsPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    VawsPanel.this.showVawsPopup(e);
                }
            });
            this.vawsTable.getInputMap().put((KeyStroke)this.getVawsEditAction().getValue("AcceleratorKey"), this.getVawsEditAction().getValue("Name"));
            this.vawsTable.getActionMap().put(this.getVawsEditAction().getValue("Name"), this.getVawsEditAction());
            this.vawsTable.getInputMap().put((KeyStroke)this.getVawsLoeschAction().getValue("AcceleratorKey"), this.getVawsLoeschAction().getValue("Name"));
            this.vawsTable.getActionMap().put(this.getVawsLoeschAction().getValue("Name"), this.getVawsLoeschAction());
        }
        return this.vawsTable;
    }
}

