/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlKlaeranlagen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbepkt;
import de.bielefeld.umweltamt.aui.mappings.basis.AbstractBasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.indeinl.IndeinlUebergabestelle;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.RetractablePanel;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class UebergabePanel
extends JPanel {
    private String name = "\u00dcbergabestelle";
    private BasisObjektBearbeiten hauptModul;
    private IndeinlUebergabestelle upunkt;
    private RetractablePanel fotoRtPanel;
    private JTextArea ueberstBemerkungArea = null;
    private TextFieldDateChooser erfassungsDatum = null;
    private TextFieldDateChooser aenderungsDatum = null;
    private JComboBox klaeranlageBox = null;
    private JComboBox kanalartBox = null;
    private JFormattedTextField rechtswertFeld = null;
    private JFormattedTextField hochwertFeld = null;
    private JButton saveUebergabeButton = null;
    private IndeinlUebergabestelle fachdaten = null;
    private AtlKlaeranlagen[] klaeranlagen = null;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;
    private JLabel fotoLabel;

    public UebergabePanel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:80dlu, 5dlu, 80dlu, 5dlu, r:65dlu, 5dlu, 80dlu, 100dlu:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Fachdaten");
        builder.append("Erfasst:", (Component)this.getErfassungsDatum());
        builder.append("Kanalart:", (Component)this.getKanalartBox());
        builder.nextLine();
        builder.append("Ge\u00e4ndert:", (Component)this.getAenderungsDatum());
        builder.append("Kl\u00e4ranlage:", (Component)this.getKlaeranlageBox());
        builder.nextLine();
        builder.append("Rechtswert:", (Component)this.getRechtswertFeld());
        builder.append("Hochwert:", (Component)this.getHochwertFeld());
        builder.nextLine();
        builder.append((Component)this.getFotoRtPanel(), 8);
        builder.nextLine();
        builder.appendSeparator("Bemerkungen");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane bemerkungsScroller = new JScrollPane(this.getUeberstBemerkungArea(), 20, 31);
        builder.appendRow("fill:30dlu");
        builder.append((Component)bemerkungsScroller, 7);
        builder.nextLine();
        builder.appendSeparator("Verkn\u00fcpfte Objekte");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.appendRow("fill:100dlu");
        builder.append((Component)objektverknuepfungScroller, 7);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton(), (JButton)this.getsaveUebergabeButton());
        builder.append((Component)buttonBar, 7);
    }

    public void fetchFormData() throws RuntimeException {
        this.fachdaten = IndeinlUebergabestelle.getUebergabeByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("Uebergabestelle Objekt aus DB geholt: ID" + this.fachdaten, "UebergabePanel.fetchFormData");
    }

    public void updateForm() throws RuntimeException {
        if (this.fachdaten != null) {
            if (this.fachdaten.getRechtswert() != null) {
                this.getRechtswertFeld().setText(this.fachdaten.getRechtswert().toString());
            }
            if (this.fachdaten.getHochwert() != null) {
                this.getHochwertFeld().setText(this.fachdaten.getHochwert().toString());
            }
            if (this.fachdaten.getErfassungsDatum() != null) {
                this.getErfassungsDatum().setDate(this.fachdaten.getErfassungsDatum());
            }
            if (this.fachdaten.getAenderungsDatum() != null) {
                this.getAenderungsDatum().setDate(this.fachdaten.getAenderungsDatum());
            }
            if (this.fachdaten.getErfassungsDatum() == null) {
                this.getErfassungsDatum().setDate(null);
            }
            if (this.fachdaten.getAtlKlaeranlagen() != null) {
                this.getKlaeranlageBox().setSelectedItem(this.fachdaten.getAtlKlaeranlagen());
            }
            if (this.fachdaten.getKanalart() != null) {
                if (this.fachdaten.getKanalart() == 1) {
                    this.getKanalartBox().setSelectedItem("Schmutzwasser");
                } else if (this.fachdaten.getKanalart() == 2) {
                    this.getKanalartBox().setSelectedItem("Mischwasser");
                } else if (this.fachdaten.getKanalart() == 3) {
                    this.getKanalartBox().setSelectedItem("Regenwasser");
                }
            }
            Integer rechts = ((IntegerField)this.rechtswertFeld).getIntValue();
            this.fachdaten.setRechtswert(rechts);
            Integer hoch = ((IntegerField)this.hochwertFeld).getIntValue();
            this.fachdaten.setHochwert(hoch);
            if (this.fachdaten.getBemerkungen() != null) {
                this.getUeberstBemerkungArea().setText(this.fachdaten.getBemerkungen());
            }
            this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
            if (this.getFotoRtPanel().isOpen()) {
                this.getFotoRtPanel().setOpen(true);
            }
        }
    }

    public void clearForm() {
        this.getRechtswertFeld().setText(null);
        this.getHochwertFeld().setText(null);
        this.getErfassungsDatum().setDate(null);
        this.getAenderungsDatum().setDate(null);
        this.getKlaeranlageBox().setSelectedItem(null);
        this.getKanalartBox().setSelectedItem(null);
        this.getUeberstBemerkungArea().setText(null);
    }

    public void enableAll(boolean enabled) {
        this.getRechtswertFeld().setEnabled(enabled);
        this.getHochwertFeld().setEnabled(enabled);
        this.getErfassungsDatum().setEnabled(enabled);
        this.getAenderungsDatum().setEnabled(enabled);
        this.getKanalartBox().setEnabled(enabled);
        this.getKlaeranlageBox().setEnabled(enabled);
        this.getUeberstBemerkungArea().setEnabled(enabled);
    }

    private boolean saveUebergabestelleDaten() {
        boolean success;
        String bemerkungen = this.ueberstBemerkungArea.getText();
        if ("".equals(bemerkungen)) {
            this.fachdaten.setBemerkungen(null);
        } else {
            this.fachdaten.setBemerkungen(bemerkungen);
        }
        Date erf = this.erfassungsDatum.getDate();
        this.fachdaten.setErfassungsDatum(erf);
        Date aend = this.aenderungsDatum.getDate();
        this.fachdaten.setAenderungsDatum(aend);
        Integer rechts = ((IntegerField)this.rechtswertFeld).getIntValue();
        this.fachdaten.setRechtswert(rechts);
        Integer hoch = ((IntegerField)this.hochwertFeld).getIntValue();
        this.fachdaten.setHochwert(hoch);
        if (this.getKlaeranlageBox().getSelectedItem() != null) {
            this.fachdaten.setAtlKlaeranlagen((AtlKlaeranlagen)this.getKlaeranlageBox().getSelectedItem());
        }
        if (this.getKanalartBox().getSelectedItem() != null) {
            if (this.getKanalartBox().getSelectedItem() == "Schmutzwasser") {
                this.fachdaten.setKanalart(1);
            } else if (this.getKanalartBox().getSelectedItem() == "Mischwasser") {
                this.fachdaten.setKanalart(2);
            } else if (this.getKanalartBox().getSelectedItem() == "Regenwasser") {
                this.fachdaten.setKanalart(3);
            }
        }
        if (success = IndeinlUebergabestelle.saveFachdaten(this.fachdaten)) {
            AUIKataster.debugOutput("Uebergabestelle Objekt " + this.fachdaten.getObjektid() + " gespeichert.", "Anh40Panel.saveAnh40Daten");
        } else {
            AUIKataster.debugOutput("Uebergabestelle Objekt " + this.fachdaten + " konnte nicht gespeichert werden!", "Anh40Panel.saveAnh40Daten");
        }
        return success;
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.fachdaten == null) {
            this.fachdaten = new IndeinlUebergabestelle();
            this.fachdaten.setBasisObjekt(this.hauptModul.getObjekt());
            IndeinlUebergabestelle.saveFachdaten(this.fachdaten);
            AUIKataster.debugOutput("Neues Uebergabestelle Objekt " + this.fachdaten + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
        }
    }

    private JButton getsaveUebergabeButton() {
        if (this.saveUebergabeButton == null) {
            this.saveUebergabeButton = new JButton("Speichern");
            this.saveUebergabeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UebergabePanel.this.enableAll(false);
                    if (UebergabePanel.this.saveUebergabestelleDaten()) {
                        UebergabePanel.this.hauptModul.getFrame().changeStatus("Uebergabestelle " + UebergabePanel.this.fachdaten.getObjektid() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        UebergabePanel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern des Uebergabestelle Objekt!", HauptFrame.ERROR_COLOR);
                    }
                    UebergabePanel.this.hauptModul.fillForm();
                }
            });
        }
        return this.saveUebergabeButton;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private TextFieldDateChooser getErfassungsDatum() {
        if (this.erfassungsDatum == null) {
            this.erfassungsDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.erfassungsDatum;
    }

    private TextFieldDateChooser getAenderungsDatum() {
        if (this.aenderungsDatum == null) {
            this.aenderungsDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.aenderungsDatum;
    }

    private JFormattedTextField getRechtswertFeld() {
        if (this.rechtswertFeld == null) {
            this.rechtswertFeld = new IntegerField();
        }
        return this.rechtswertFeld;
    }

    private JFormattedTextField getHochwertFeld() {
        if (this.hochwertFeld == null) {
            this.hochwertFeld = new IntegerField();
        }
        return this.hochwertFeld;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = UebergabePanel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = UebergabePanel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != UebergabePanel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                UebergabePanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                UebergabePanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            UebergabePanel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    UebergabePanel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    UebergabePanel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = UebergabePanel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && UebergabePanel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = UebergabePanel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(UebergabePanel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (UebergabePanel.this.objektVerknuepfungModel.removeRow(row)) {
                                UebergabePanel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                UebergabePanel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(UebergabePanel.this.hauptModul.getFrame(), UebergabePanel.this.fachdaten.getBasisObjekt(), UebergabePanel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }

    private JComboBox getKlaeranlageBox() {
        if (this.klaeranlageBox == null) {
            this.klaeranlageBox = new JComboBox<AtlKlaeranlagen>(AtlKlaeranlagen.getKlaeranlagen());
        }
        return this.klaeranlageBox;
    }

    private JComboBox getKanalartBox() {
        if (this.kanalartBox == null) {
            this.kanalartBox = new JComboBox();
            this.kanalartBox.addItem("Schmutzwasser");
            this.kanalartBox.addItem("Mischwasser");
            this.kanalartBox.addItem("Regenwasser");
        }
        return this.kanalartBox;
    }

    private JTextArea getUeberstBemerkungArea() {
        if (this.ueberstBemerkungArea == null) {
            this.ueberstBemerkungArea = new LimitedTextArea(150);
            this.ueberstBemerkungArea.setLineWrap(true);
            this.ueberstBemerkungArea.setWrapStyleWord(true);
        }
        return this.ueberstBemerkungArea;
    }

    private RetractablePanel getFotoRtPanel() {
        if (this.fotoRtPanel == null) {
            JPanel fotoPanel = new JPanel();
            fotoPanel.add(this.getFotoLabel());
            fotoPanel.setBackground(Color.WHITE);
            fotoPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.fotoRtPanel = new RetractablePanel(DefaultComponentFactory.getInstance().createSeparator("Foto"), fotoPanel, false, null){

                @Override
                public void opening() {
                    String messstelleBez;
                    AbstractBasisObjektverknuepfung obj = null;
                    BasisObjekt bo = UebergabePanel.this.hauptModul.getObjekt();
                    List messstelle = BasisObjektverknuepfung.getVerknuepfungSielhaut(bo);
                    if (messstelle.size() == 1) {
                        for (int j = 0; j < messstelle.size(); ++j) {
                            obj = (BasisObjektverknuepfung)messstelle.get(j);
                        }
                        int id = obj.getBasisObjektByIstVerknuepftMit().getObjektid();
                        messstelleBez = AtlProbepkt.getProbepunkt(id).getAtlSielhaut().getBezeichnung();
                    } else {
                        messstelleBez = messstelle.size() > 1 ? "Nur eine verkn\u00fcpfte Sielhautmessstelle zul\u00e4ssig" : "Keine Sielhautmessstelle verkn\u00fcpft";
                    }
                    if (messstelleBez != null) {
                        String imgPath = "X:/Applikationen/Anlagenkataster/SielhautBearbeiten/fotos/" + messstelleBez + ".jpg";
                        File imgFile = new File(imgPath);
                        if (imgFile.canRead()) {
                            ImageIcon imgIcon = new ImageIcon(imgFile.getAbsolutePath());
                            if (imgIcon.getIconWidth() > 1000) {
                                imgIcon.setImage(imgIcon.getImage().getScaledInstance(1000, -1, 2));
                            }
                            UebergabePanel.this.getFotoLabel().setIcon(null);
                            UebergabePanel.this.getFotoLabel().setIcon(imgIcon);
                            UebergabePanel.this.getFotoLabel().setText(null);
                        } else if (messstelleBez == "Keine Sielhautmessstelle verkn\u00fcpft" || messstelleBez == "Nur eine verkn\u00fcpfte Sielhautmessstelle zul\u00e4ssig") {
                            UebergabePanel.this.getFotoLabel().setIcon(null);
                            UebergabePanel.this.getFotoLabel().setText("<html><b>-  Fehler: " + messstelleBez + " -</b></html>");
                        } else {
                            UebergabePanel.this.getFotoLabel().setIcon(null);
                            UebergabePanel.this.getFotoLabel().setText("<html><b>-  Foto " + messstelleBez + ".jpg nicht gefunden!  -</b></html>");
                        }
                    }
                }
            };
        }
        return this.fotoRtPanel;
    }

    private JLabel getFotoLabel() {
        if (this.fotoLabel == null) {
            this.fotoLabel = new JLabel("<html><b>- Kein Foto verf\u00fcgbar! -</b></html>");
        }
        return this.fotoLabel;
    }
}

