/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AnhSuevFachdaten;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class SuevPanel
extends JPanel {
    private String name = "Suev-Kan Verfahren";
    private BasisObjektBearbeiten hauptModul;
    private JCheckBox groesser3haCheck = null;
    private JFormattedTextField versFlaecheFeld = null;
    private JCheckBox suevkanPflichtCheck = null;
    private JCheckBox indirektswCheck = null;
    private JCheckBox indirektrwCheck = null;
    private JCheckBox direktswCheck = null;
    private JCheckBox direktrwCheck = null;
    private JCheckBox datumAnzeige58Check = null;
    private JCheckBox sanierungErfolgtCheck = null;
    private JCheckBox sanierungskonzeptCheck = null;
    private JCheckBox keineAngabenCheck = null;
    private TextFieldDateChooser datAnzeige58Datum = null;
    private TextFieldDateChooser datAnschreibenDatum = null;
    private JButton saveSuevButton = null;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;
    private AnhSuevFachdaten fachdaten = null;
    private ActionListener editButtonListener;

    public SuevPanel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:70dlu, 5dlu, 90dlu, 5dlu, 10dlu, 5dlu, 90dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Fachdaten");
        builder.append("Datum Anschreiben:", (Component)this.getDatAnschreibenDatum());
        builder.append("", (Component)this.getSanierungskonzeptCheck());
        builder.nextLine();
        builder.append("Datum Anzeige:", (Component)this.getDatAnzeige58Datum());
        builder.append("", (Component)this.getSanierungErfolgtCheck());
        builder.nextLine();
        builder.append("versiegelte Fl\u00e4che:", (Component)this.getVersFlaecheFeld());
        builder.append("", (Component)this.getDirektrwCheck());
        builder.nextLine();
        builder.append("", (Component)this.getGroesser3haCheck());
        builder.append("", (Component)this.getDirektswCheck());
        builder.nextLine();
        builder.append("", (Component)this.getSuevkanPflichtCheck());
        builder.append("", (Component)this.getIndirektrwCheck());
        builder.nextLine();
        builder.append("", (Component)this.getKeineAngabenCheck());
        builder.append("", (Component)this.getIndirektswCheck());
        builder.nextLine();
        builder.appendSeparator("Verkn\u00fcpfte Objekte");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.appendRow("fill:100dlu");
        builder.append((Component)objektverknuepfungScroller, 7);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton(), (JButton)this.getSaveSuevButton());
        builder.append((Component)buttonBar, 7);
    }

    public void fetchFormData() throws RuntimeException {
        this.fachdaten = AnhSuevFachdaten.getSuevByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("SuevKan-Verfahren aus DB geholt: " + this.fachdaten, "SuevPanel.fetchFormData");
    }

    public void updateForm() throws RuntimeException {
        if (this.fachdaten != null) {
            if (this.fachdaten.getVersFlaeche() != null) {
                this.getVersFlaecheFeld().setText(this.fachdaten.getVersFlaeche().toString());
            }
            if (this.fachdaten.getDatAnschreiben() != null) {
                this.getDatAnschreibenDatum().setDate(this.fachdaten.getDatAnschreiben());
            }
            if (this.fachdaten.getDatAnzeige58() != null) {
                this.getDatAnzeige58Datum().setDate(this.fachdaten.getDatAnzeige58());
            }
            if (this.fachdaten.getDatumAnzeige58() != null) {
                if (this.fachdaten.getDatumAnzeige58().booleanValue()) {
                    this.getDatumAnzeige58Check().setSelected(true);
                } else {
                    this.getDatumAnzeige58Check().setSelected(false);
                }
            }
            if (this.fachdaten.getDirektrw() != null) {
                if (this.fachdaten.getDirektrw().booleanValue()) {
                    this.getDirektrwCheck().setSelected(true);
                } else {
                    this.getDirektrwCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getDirektsw() != null) {
                if (this.fachdaten.getDirektsw().booleanValue()) {
                    this.getDirektswCheck().setSelected(true);
                } else {
                    this.getDirektswCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getGroesser3ha() != null) {
                if (this.fachdaten.getGroesser3ha().booleanValue()) {
                    this.getGroesser3haCheck().setSelected(true);
                } else {
                    this.getGroesser3haCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getIndirektrw() != null) {
                if (this.fachdaten.getIndirektrw().booleanValue()) {
                    this.getIndirektrwCheck().setSelected(true);
                } else {
                    this.getIndirektrwCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getIndirektsw() != null) {
                if (this.fachdaten.getIndirektsw().booleanValue()) {
                    this.getIndirektswCheck().setSelected(true);
                } else {
                    this.getIndirektswCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getKeineAngaben() != null) {
                if (this.fachdaten.getKeineAngaben().booleanValue()) {
                    this.getKeineAngabenCheck().setSelected(true);
                } else {
                    this.getKeineAngabenCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getSanierungErfolgt() != null) {
                if (this.fachdaten.getSanierungErfolgt().booleanValue()) {
                    this.getSanierungErfolgtCheck().setSelected(true);
                } else {
                    this.getSanierungErfolgtCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getSanierungskonzept() != null) {
                if (this.fachdaten.getSanierungskonzept().booleanValue()) {
                    this.getSanierungskonzeptCheck().setSelected(true);
                } else {
                    this.getSanierungskonzeptCheck().setSelected(false);
                }
            }
            this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
        }
    }

    public void clearForm() {
        this.getVersFlaecheFeld().setText(null);
        this.getDatAnschreibenDatum().setDate(null);
        this.getDatAnzeige58Datum().setDate(null);
        this.getDatumAnzeige58Check().setSelected(false);
        this.getDirektrwCheck().setSelected(false);
        this.getDirektswCheck().setSelected(false);
        this.getGroesser3haCheck().setSelected(false);
        this.getIndirektrwCheck().setSelected(false);
        this.getIndirektswCheck().setSelected(false);
        this.getKeineAngabenCheck().setSelected(false);
        this.getSanierungErfolgtCheck().setSelected(false);
        this.getSanierungskonzeptCheck().setSelected(false);
        this.getSuevkanPflichtCheck().setSelected(false);
    }

    public void enableAll(boolean enabled) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    private boolean saveSuevDaten() {
        Integer versfl = ((IntegerField)this.versFlaecheFeld).getIntValue();
        this.fachdaten.setVersFlaeche(versfl);
        Date anschreiben = this.datAnschreibenDatum.getDate();
        this.fachdaten.setDatAnschreiben(anschreiben);
        Date anzeigedatum = this.datAnzeige58Datum.getDate();
        this.fachdaten.setDatAnzeige58(anzeigedatum);
        if (this.getDatumAnzeige58Check().isSelected()) {
            this.fachdaten.setDatumAnzeige58(true);
        } else {
            this.fachdaten.setDatumAnzeige58(false);
        }
        if (this.getDirektrwCheck().isSelected()) {
            this.fachdaten.setDirektrw(true);
        } else {
            this.fachdaten.setDirektrw(false);
        }
        if (this.getDirektswCheck().isSelected()) {
            this.fachdaten.setDirektsw(true);
        } else {
            this.fachdaten.setDirektsw(false);
        }
        if (this.getGroesser3haCheck().isSelected()) {
            this.fachdaten.setGroesser3ha(true);
        } else {
            this.fachdaten.setGroesser3ha(false);
        }
        if (this.getIndirektrwCheck().isSelected()) {
            this.fachdaten.setIndirektrw(true);
        } else {
            this.fachdaten.setIndirektrw(false);
        }
        if (this.getIndirektswCheck().isSelected()) {
            this.fachdaten.setIndirektsw(true);
        } else {
            this.fachdaten.setIndirektsw(false);
        }
        if (this.getKeineAngabenCheck().isSelected()) {
            this.fachdaten.setKeineAngaben(true);
        } else {
            this.fachdaten.setKeineAngaben(false);
        }
        if (this.getSanierungErfolgtCheck().isSelected()) {
            this.fachdaten.setSanierungErfolgt(true);
        } else {
            this.fachdaten.setSanierungErfolgt(false);
        }
        if (this.getSanierungskonzeptCheck().isSelected()) {
            this.fachdaten.setSanierungskonzept(true);
        } else {
            this.fachdaten.setSanierungskonzept(false);
        }
        if (this.getSuevkanPflichtCheck().isSelected()) {
            this.fachdaten.setSuevkanPflicht(true);
        } else {
            this.fachdaten.setSuevkanPflicht(false);
        }
        boolean success = AnhSuevFachdaten.saveFachdaten(this.fachdaten);
        if (success) {
            AUIKataster.debugOutput("SuevKan Verfahren " + this.fachdaten.getObjektid() + " gespeichert.", "SuevFachdaten.saveFachdaten");
        } else {
            AUIKataster.debugOutput("SuevKan Verfahren " + this.fachdaten + " konnte nicht gespeichert werden!", "SuevFachdaten.saveFachdaten");
        }
        return success;
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.fachdaten == null) {
            this.fachdaten = new AnhSuevFachdaten();
            this.fachdaten.setBasisObjekt(this.hauptModul.getObjekt());
            AnhSuevFachdaten.saveFachdaten(this.fachdaten);
            AUIKataster.debugOutput("Neues SuevKan Verfahren " + this.fachdaten + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
        }
    }

    private TextFieldDateChooser getDatAnschreibenDatum() {
        if (this.datAnschreibenDatum == null) {
            this.datAnschreibenDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.datAnschreibenDatum;
    }

    private TextFieldDateChooser getDatAnzeige58Datum() {
        if (this.datAnzeige58Datum == null) {
            this.datAnzeige58Datum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.datAnzeige58Datum;
    }

    private JCheckBox getDatumAnzeige58Check() {
        if (this.datumAnzeige58Check == null) {
            this.datumAnzeige58Check = new JCheckBox("Datum Anzeige");
        }
        return this.datumAnzeige58Check;
    }

    private JCheckBox getDirektrwCheck() {
        if (this.direktrwCheck == null) {
            this.direktrwCheck = new JCheckBox("Direkt RW");
        }
        return this.direktrwCheck;
    }

    private JCheckBox getDirektswCheck() {
        if (this.direktswCheck == null) {
            this.direktswCheck = new JCheckBox("Direkt SW");
        }
        return this.direktswCheck;
    }

    private JCheckBox getGroesser3haCheck() {
        if (this.groesser3haCheck == null) {
            this.groesser3haCheck = new JCheckBox("Gr\u00f6\u00dfer 3 ha");
        }
        return this.groesser3haCheck;
    }

    private JCheckBox getIndirektrwCheck() {
        if (this.indirektrwCheck == null) {
            this.indirektrwCheck = new JCheckBox("Indirekt RW");
        }
        return this.indirektrwCheck;
    }

    private JCheckBox getIndirektswCheck() {
        if (this.indirektswCheck == null) {
            this.indirektswCheck = new JCheckBox("Indirekt SW");
        }
        return this.indirektswCheck;
    }

    private JCheckBox getKeineAngabenCheck() {
        if (this.keineAngabenCheck == null) {
            this.keineAngabenCheck = new JCheckBox("Keine Angaben");
        }
        return this.keineAngabenCheck;
    }

    private JCheckBox getSanierungErfolgtCheck() {
        if (this.sanierungErfolgtCheck == null) {
            this.sanierungErfolgtCheck = new JCheckBox("Sanierung erfolgt");
        }
        return this.sanierungErfolgtCheck;
    }

    private JCheckBox getSanierungskonzeptCheck() {
        if (this.sanierungskonzeptCheck == null) {
            this.sanierungskonzeptCheck = new JCheckBox("Sanierungskonzept");
        }
        return this.sanierungskonzeptCheck;
    }

    private JCheckBox getSuevkanPflichtCheck() {
        if (this.suevkanPflichtCheck == null) {
            this.suevkanPflichtCheck = new JCheckBox("SuevKan pflichtig");
        }
        return this.suevkanPflichtCheck;
    }

    private JFormattedTextField getVersFlaecheFeld() {
        if (this.versFlaecheFeld == null) {
            this.versFlaecheFeld = new IntegerField();
        }
        return this.versFlaecheFeld;
    }

    private JButton getSaveSuevButton() {
        if (this.saveSuevButton == null) {
            this.saveSuevButton = new JButton("Speichern");
            this.saveSuevButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SuevPanel.this.enableAll(false);
                    if (SuevPanel.this.saveSuevDaten()) {
                        SuevPanel.this.hauptModul.getFrame().changeStatus("SuevKan Verfahren " + SuevPanel.this.fachdaten.getObjektid() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        SuevPanel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern des SuevKan Verfahrens!", HauptFrame.ERROR_COLOR);
                    }
                    SuevPanel.this.hauptModul.fillForm();
                }
            });
        }
        return this.saveSuevButton;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = SuevPanel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = SuevPanel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != SuevPanel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                SuevPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                SuevPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            SuevPanel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    SuevPanel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    SuevPanel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = SuevPanel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && SuevPanel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = SuevPanel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(SuevPanel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (SuevPanel.this.objektVerknuepfungModel.removeRow(row)) {
                                SuevPanel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                SuevPanel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(SuevPanel.this.hauptModul.getFrame(), SuevPanel.this.fachdaten.getBasisObjekt(), SuevPanel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }
}

