/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlKlaeranlagen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbeart;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbenahmen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbepkt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.editors.ProbenEditor;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ProbenahmenModel;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ProbepunktPanel
extends JPanel {
    private String name = "Probenahmepunkt";
    private BasisObjektBearbeiten hauptModul;
    private JComboBox probePktArtBox = null;
    private JComboBox probeKABox = null;
    private JFormattedTextField probePktNrFeld = null;
    private JTextArea probePktBeschreibungsArea = null;
    private JTable probenahmeTabelle = null;
    private JPanel neueProbePanel = null;
    private JTextField kennummerFeld = null;
    private JDateChooser datumsChooser = null;
    private JButton anlegenButton = null;
    private JButton savePktButton = null;
    private ProbenahmenModel probenahmenModel = null;
    private AtlProbepkt probepkt = null;
    private AtlProbeart[] probearten = null;
    private AtlKlaeranlagen[] klaeranlagen = null;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;

    public ProbepunktPanel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        this.probenahmenModel = new ProbenahmenModel();
        FormLayout layout = new FormLayout("r:50dlu, 5dlu, 150dlu, r:45dlu, 5dlu, 25dlu", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 5dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:40dlu:g, 3dlu, pref, 3dlu, pref, 3dlu, fill:40dlu:g, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Eigenschaften", cc.xyw(1, 1, 6));
        builder.addLabel("Art:", cc.xy(1, 3));
        builder.add((Component)this.getProbePktArtBox(), cc.xy(3, 3));
        builder.addLabel("Nr:", cc.xy(4, 3));
        builder.add((Component)this.getProbePktNrFeld(), cc.xy(6, 3));
        builder.addLabel("Kl\u00e4ranlage:", cc.xy(1, 5));
        builder.add((Component)this.getProbeKABox(), cc.xy(3, 5));
        JPanel buttonBar = ButtonBarFactory.buildOKBar((JButton)this.getSavePktButton());
        builder.add((Component)buttonBar, cc.xyw(1, 7, 6));
        builder.addSeparator("Beschreibung", cc.xyw(1, 9, 6));
        JScrollPane beschScroller = new JScrollPane(this.getProbePktBeschreibungsArea(), 20, 31);
        beschScroller.setBorder(null);
        builder.add((Component)beschScroller, cc.xyw(1, 11, 6));
        builder.addSeparator("Probenahmen", cc.xyw(1, 13, 6));
        JScrollPane tabellenScroller = new JScrollPane(this.getProbenahmeTabelle(), 20, 31);
        builder.add((Component)tabellenScroller, cc.xyw(1, 15, 6));
        builder.add((Component)this.getNeueProbePanel(), cc.xyw(1, 17, 6));
        builder.addSeparator("Verkn\u00fcpfte Objekte", cc.xyw(1, 19, 6));
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.add((Component)objektverknuepfungScroller, cc.xyw(1, 21, 6));
        JPanel buttonBarOv = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton());
        builder.add((Component)buttonBarOv, cc.xyw(1, 23, 6));
    }

    public void fetchFormData() throws RuntimeException {
        this.probepkt = AtlProbepkt.getProbepunktByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("Probepunkt aus DB geholt: " + this.probepkt, "ProbepunktPanel.fetchFormData");
        if (this.probearten == null) {
            this.probearten = AtlProbeart.getProbearten();
        }
        if (this.klaeranlagen == null) {
            this.klaeranlagen = AtlKlaeranlagen.getKlaeranlagen();
        }
    }

    public void updateForm() throws RuntimeException {
        if (this.probearten != null) {
            this.getProbePktArtBox().setModel(new DefaultComboBoxModel<AtlProbeart>(this.probearten));
        }
        if (this.klaeranlagen != null) {
            this.getProbeKABox().setModel(new DefaultComboBoxModel<AtlKlaeranlagen>(this.klaeranlagen));
        }
        if (this.probepkt != null) {
            this.getProbePktArtBox().setSelectedItem(this.probepkt.getAtlProbeart());
            this.getProbeKABox().setSelectedItem(this.probepkt.getAtlKlaeranlagen());
            if (this.probepkt.getNummer() != null) {
                this.getProbePktNrFeld().setValue(this.probepkt.getNummer());
            }
            this.getProbePktBeschreibungsArea().setText(this.hauptModul.getObjekt().getBeschreibung());
            this.probenahmenModel.setProbepunkt(this.probepkt);
            this.probenahmenModel.updateList();
            this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
        }
    }

    public void clearForm() {
        this.getProbePktNrFeld().setText(null);
        this.getProbePktBeschreibungsArea().setText(null);
        this.getKennummerFeld().setText("");
    }

    public void enableAll(boolean enabled) {
        this.getProbePktArtBox().setEnabled(enabled);
        this.getProbeKABox().setEnabled(enabled);
        this.getProbePktNrFeld().setEnabled(enabled);
        this.getProbePktBeschreibungsArea().setEnabled(enabled);
        this.getProbenahmeTabelle().setEnabled(enabled);
        this.getKennummerFeld().setEnabled(enabled);
        this.getDatumsChooser().setEnabled(enabled);
        this.getAnlegenButton().setEnabled(enabled);
        this.getSavePktButton().setEnabled(enabled);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void editProbenahme(AtlProbenahmen probe) {
        ProbenEditor editDialog = new ProbenEditor(probe, this.hauptModul.getFrame(), false);
        editDialog.setLocationRelativeTo(this.hauptModul.getFrame());
        editDialog.setVisible(true);
        this.probenahmenModel.updateList();
    }

    public void neueProbenahme(String kennNummer, Timestamp datum) {
        if (this.probepkt != null) {
            boolean exists = AtlProbenahmen.probenahmeExists(kennNummer);
            if (!exists) {
                AtlProbenahmen probe = new AtlProbenahmen();
                probe.setKennummer(kennNummer);
                probe.setDatumDerEntnahme(datum);
                probe.setAtlAnalysepositionen(new HashSet());
                probe.setAtlProbepkt(this.probepkt);
                ProbenEditor editDialog = new ProbenEditor(probe, this.hauptModul.getFrame(), true);
                editDialog.setVisible(true);
                this.probenahmenModel.updateList();
            } else {
                this.hauptModul.getFrame().changeStatus("Eine Probenahme mit dieser Kennnummer existiert schon!", HauptFrame.ERROR_COLOR);
            }
        } else {
            this.hauptModul.getFrame().changeStatus("Fehler beim Anlegen: Kein Probepunkt!", HauptFrame.ERROR_COLOR);
        }
    }

    private boolean saveProbepunktDaten() {
        boolean success;
        if (this.probepkt != null) {
            if (this.getProbePktArtBox().getSelectedItem() != null) {
                this.probepkt.setAtlProbeart((AtlProbeart)this.getProbePktArtBox().getSelectedItem());
            }
            if (this.getProbeKABox().getSelectedItem() != null) {
                this.probepkt.setAtlKlaeranlagen((AtlKlaeranlagen)this.getProbeKABox().getSelectedItem());
            }
            if (this.getProbePktNrFeld().getValue() != null) {
                this.probepkt.setNummer(((IntegerField)this.getProbePktNrFeld()).getIntValue());
            }
            success = AtlProbepkt.removeProbepunkt(this.probepkt);
        } else {
            success = false;
        }
        return success;
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.probepkt == null) {
            this.probepkt = new AtlProbepkt();
            this.probepkt.setBasisObjekt(this.hauptModul.getObjekt());
            if (AtlProbepkt.saveProbepunkt(this.probepkt)) {
                AUIKataster.debugOutput("Neuer Probepunkt " + this.probepkt + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
            }
        }
    }

    private JComboBox getProbePktArtBox() {
        if (this.probePktArtBox == null) {
            this.probePktArtBox = new JComboBox();
        }
        return this.probePktArtBox;
    }

    private JComboBox getProbeKABox() {
        if (this.probeKABox == null) {
            this.probeKABox = new JComboBox();
        }
        return this.probeKABox;
    }

    private JFormattedTextField getProbePktNrFeld() {
        if (this.probePktNrFeld == null) {
            this.probePktNrFeld = new IntegerField();
        }
        return this.probePktNrFeld;
    }

    private JTextArea getProbePktBeschreibungsArea() {
        if (this.probePktBeschreibungsArea == null) {
            this.probePktBeschreibungsArea = new JTextArea();
            this.probePktBeschreibungsArea.setLineWrap(true);
            this.probePktBeschreibungsArea.setWrapStyleWord(true);
            this.probePktBeschreibungsArea.setEditable(false);
            this.probePktBeschreibungsArea.setToolTipText("Diese Beschreibung kann unter \"Objekt\" ge\u00e4ndert werden.");
            this.probePktBeschreibungsArea.setBackground(this.getBackground());
        }
        return this.probePktBeschreibungsArea;
    }

    private JTable getProbenahmeTabelle() {
        if (this.probenahmeTabelle == null) {
            this.probenahmeTabelle = new JTable(this.probenahmenModel);
            this.probenahmeTabelle.setSelectionMode(0);
            this.probenahmeTabelle.setColumnSelectionAllowed(false);
            this.probenahmeTabelle.setRowSelectionAllowed(true);
            this.probenahmeTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = ProbepunktPanel.this.probenahmeTabelle.rowAtPoint(origin);
                        AtlProbenahmen probe = ProbepunktPanel.this.probenahmenModel.getRow(row);
                        ProbepunktPanel.this.editProbenahme(probe);
                    }
                }
            });
            KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0, false);
            this.probenahmeTabelle.getInputMap().put(enterKeyStroke, "ENTER");
            AbstractAction editAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ProbepunktPanel.this.probenahmeTabelle.getSelectedRow();
                    if (row != -1) {
                        AtlProbenahmen probe = ProbepunktPanel.this.probenahmenModel.getRow(row);
                        ProbepunktPanel.this.editProbenahme(probe);
                    }
                }
            };
            this.probenahmeTabelle.getActionMap().put("ENTER", editAction);
            KeyStroke deleteKeyStroke = KeyStroke.getKeyStroke(127, 0, false);
            this.probenahmeTabelle.getInputMap().put(deleteKeyStroke, "DEL");
            AbstractAction removeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ProbepunktPanel.this.probenahmeTabelle.getSelectedRow();
                    if (row != -1 && ProbepunktPanel.this.probenahmeTabelle.getEditingRow() == -1) {
                        AtlProbenahmen probe = ProbepunktPanel.this.probenahmenModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(ProbepunktPanel.this, "Soll die Probenahme " + probe.getKennummer() + " wirklich inkl. aller Analysen gel\u00f6scht werden?", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            ProbepunktPanel.this.probenahmenModel.removeRow(row);
                            AUIKataster.debugOutput("Probe " + probe.getKennummer() + " wurde gel\u00f6scht!", "SchlammPanel.removeAction");
                        }
                    }
                }
            };
            this.probenahmeTabelle.getActionMap().put("DEL", removeAction);
        }
        return this.probenahmeTabelle;
    }

    private JPanel getNeueProbePanel() {
        if (this.neueProbePanel == null) {
            FormLayout anlegenLayout = new FormLayout("pref, 4dlu, max(60dlu;pref), 7dlu, pref, 4dlu, max(60dlu;pref), 7dlu, max(60dlu;pref)");
            DefaultFormBuilder builder = new DefaultFormBuilder(anlegenLayout);
            builder.append("Kennummer:", (Component)this.getKennummerFeld());
            builder.append("Datum:", (Component)this.getDatumsChooser());
            builder.append((Component)this.getAnlegenButton());
            this.neueProbePanel = builder.getPanel();
        }
        return this.neueProbePanel;
    }

    private JTextField getKennummerFeld() {
        if (this.kennummerFeld == null) {
            this.kennummerFeld = new LimitedTextField(50, "");
        }
        return this.kennummerFeld;
    }

    private JDateChooser getDatumsChooser() {
        if (this.datumsChooser == null) {
            this.datumsChooser = new JDateChooser("dd.MM.yy", false);
        }
        return this.datumsChooser;
    }

    private JButton getAnlegenButton() {
        if (this.anlegenButton == null) {
            this.anlegenButton = new JButton("Anlegen");
            this.anlegenButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProbepunktPanel.this.getKennummerFeld().getText().trim().equals("")) {
                        ProbepunktPanel.this.getKennummerFeld().requestFocus();
                        ProbepunktPanel.this.hauptModul.getFrame().changeStatus("Leere Kennummer!", HauptFrame.ERROR_COLOR);
                    } else {
                        String kennNummer = ProbepunktPanel.this.getKennummerFeld().getText().trim().replaceAll(" ", "");
                        Timestamp datum = new Timestamp(ProbepunktPanel.this.getDatumsChooser().getDate().getTime());
                        ProbepunktPanel.this.neueProbenahme(kennNummer, datum);
                    }
                }
            });
        }
        return this.anlegenButton;
    }

    private JButton getSavePktButton() {
        if (this.savePktButton == null) {
            this.savePktButton = new JButton("Probepunkt speichern");
            this.savePktButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProbepunktPanel.this.enableAll(false);
                    if (ProbepunktPanel.this.saveProbepunktDaten()) {
                        ProbepunktPanel.this.hauptModul.getFrame().changeStatus("Probepunkt " + ProbepunktPanel.this.probepkt.getObjektid() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        ProbepunktPanel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern von Probepunkt!", HauptFrame.ERROR_COLOR);
                    }
                    ProbepunktPanel.this.hauptModul.fillForm();
                }
            });
        }
        return this.savePktButton;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = ProbepunktPanel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = ProbepunktPanel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != ProbepunktPanel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                ProbepunktPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                ProbepunktPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            ProbepunktPanel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    ProbepunktPanel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    ProbepunktPanel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ProbepunktPanel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && ProbepunktPanel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = ProbepunktPanel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(ProbepunktPanel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (ProbepunktPanel.this.objektVerknuepfungModel.removeRow(row)) {
                                ProbepunktPanel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                ProbepunktPanel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(ProbepunktPanel.this.hauptModul.getFrame(), ProbepunktPanel.this.probepkt.getBasisObjekt(), ProbepunktPanel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }
}

