/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlEinheiten;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlParameter;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbepkt;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.SearchBox;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.charts.APosDataItem;
import de.bielefeld.umweltamt.aui.utils.charts.ChartDataSets;
import de.bielefeld.umweltamt.aui.utils.charts.Charts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class ProbepktAuswPanel
extends JPanel {
    private JDateChooser vonDateChooser;
    private JDateChooser bisDateChooser;
    private JComboBox analyseVonBox;
    private String name = "Auswertung";
    private BasisObjektBearbeiten hauptModul;
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private JList leftList;
    private JList rightList;
    private JButton submitButton;
    private JButton leftDeleteButton;
    private JButton rightDeleteButton;
    private TimeSeriesCollection dataSet1;
    private TimeSeriesCollection dataSet2;
    private ActionListener rlButtonListener;
    private AtlProbepkt pkt;
    private JComboBox parameterBox;
    private HauptFrame frame;

    public ProbepktAuswPanel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("20dlu, 5dlu, 70dlu, 5dlu, 20dlu, 5dlu, 140dlu, 5dlu, r:16px, 5dlu, c:70dlu:g(0.1), 5dlu, l:16px, 10dlu, 300dlu", "pref, 3dlu, pref, 3dlu , pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        CellConstraints cc2 = (CellConstraints)cc.clone();
        builder.addSeparator("Zeitraum", cc.xyw(1, 1, 11));
        builder.addSeparator("Analyse von...", cc.xyw(13, 1, 3));
        builder.add(new JLabel("Von:"), cc.xy(1, 3, "r,d"), (Component)this.getVonDateChooser(), cc2.xy(3, 3, "l,d"));
        builder.add(new JLabel("Bis:"), cc.xy(5, 3, "r,d"), (Component)this.getBisDateChooser(), cc2.xy(7, 3, "l,d"));
        builder.add((Component)this.getAnalyseVonBox(), cc2.xyw(13, 3, 3, "l,d"));
        builder.addSeparator("Parameter", cc.xyw(1, 5, 15));
        builder.add((Component)new JLabel("Erste Y-Achse"), cc.xyw(1, 7, 7));
        builder.add((Component)new JLabel("Zweite Y-Achse"), cc.xy(15, 7));
        JList lList = this.getLeftList();
        JList rList = this.getRightList();
        builder.add((Component)new JScrollPane(lList), cc.xywh(1, 9, 7, 15, "fill, fill"));
        builder.add((Component)new JScrollPane(rList), cc.xywh(15, 9, 1, 15, "fill, fill"));
        builder.add((Component)this.createRLButton(true, "L11650"), cc.xy(9, 9));
        builder.add((Component)new JLabel("Cadmium (Cd)", 0), cc.xy(11, 9, "f,d"));
        builder.add((Component)this.createRLButton(false, "L11650"), cc.xy(13, 9));
        builder.add((Component)this.createRLButton(true, "L11510"), cc.xy(9, 11));
        builder.add((Component)new JLabel("Chrom (Cr)", 0), cc.xy(11, 11, "f,d"));
        builder.add((Component)this.createRLButton(false, "L11510"), cc.xy(13, 11));
        builder.add((Component)this.createRLButton(true, "L11610"), cc.xy(9, 13));
        builder.add((Component)new JLabel("Kupfer (Cu)", 0), cc.xy(11, 13, "f,d"));
        builder.add((Component)this.createRLButton(false, "L11610"), cc.xy(13, 13));
        builder.add((Component)this.createRLButton(true, "L11660"), cc.xy(9, 15));
        builder.add((Component)new JLabel("Quecksilber (Hg)", 0), cc.xy(11, 15, "f,d"));
        builder.add((Component)this.createRLButton(false, "L11660"), cc.xy(13, 15));
        builder.add((Component)this.createRLButton(true, "L11880"), cc.xy(9, 17));
        builder.add((Component)new JLabel("Nickel (Ni)", 0), cc.xy(11, 17, "f,d"));
        builder.add((Component)this.createRLButton(false, "L11880"), cc.xy(13, 17));
        builder.add((Component)this.createRLButton(true, "L11380"), cc.xy(9, 19));
        builder.add((Component)new JLabel("Blei (Pb)", 0), cc.xy(11, 19, "f,d"));
        builder.add((Component)this.createRLButton(false, "L11380"), cc.xy(13, 19));
        builder.add((Component)this.createRLButton(true, "L11640"), cc.xy(9, 21));
        builder.add((Component)new JLabel("Zink (Zn)", 0), cc.xy(11, 21, "f,d"));
        builder.add((Component)this.createRLButton(false, "L11640"), cc.xy(13, 21));
        builder.add((Component)this.createRLButton(true, "box"), cc.xy(9, 23));
        builder.add((Component)this.getParameterBox(), cc.xy(11, 23, "f,d"));
        builder.add((Component)this.createRLButton(false, "box"), cc.xy(13, 23));
        builder.add((Component)this.getLeftDeleteButton(), cc.xyw(1, 25, 7, "c,d"));
        builder.add((Component)this.getRightDeleteButton(), cc.xy(15, 25, "c,d"));
        builder.add((Component)this.getSubmitButton(), cc.xy(11, 25));
    }

    private JComboBox getParameterBox() {
        if (this.parameterBox == null) {
            this.parameterBox = new SearchBox(AtlParameter.getRelevanteParameter());
        }
        return this.parameterBox;
    }

    private JButton getSubmitButton() {
        if (this.submitButton == null) {
            this.submitButton = new JButton("Abschicken");
            this.submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProbepktAuswPanel.this.getRightList().getModel().getSize() == 0) {
                        ProbepktAuswPanel.this.showResultOneAxis(ProbepktAuswPanel.LEFT);
                    } else if (ProbepktAuswPanel.this.getLeftList().getModel().getSize() == 0) {
                        ProbepktAuswPanel.this.showResultOneAxis(ProbepktAuswPanel.RIGHT);
                    } else {
                        ProbepktAuswPanel.this.showResultDualAxis();
                    }
                }
            });
        }
        return this.submitButton;
    }

    public void showResultOneAxis(final String axis) {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getSubmitButton()){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                ProbepktAuswPanel.this.dataSet1 = ProbepktAuswPanel.this.createDataset(axis);
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                if (ProbepktAuswPanel.this.dataSet1.getSeriesCount() > 0) {
                    AuswertungsDialog dialog = new AuswertungsDialog("Probenahmen", ProbepktAuswPanel.this.dataSet1, null, ProbepktAuswPanel.this.frame);
                    dialog.setVisible(true);
                } else {
                    AUIKataster.debugOutput("Keine Parameter ausgew\u00e4hlt!", "showResultOneAxis");
                }
            }
        };
        AUIKataster.debugOutput("Bereite Auswertung vor...", "showResultOneAxis");
        worker.start();
    }

    public void showResultDualAxis() {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getSubmitButton()){
            private int seriesCount;
            {
                this.seriesCount = 0;
            }

            @Override
            protected void doNonUILogic() throws RuntimeException {
                ProbepktAuswPanel.this.dataSet1 = ProbepktAuswPanel.this.createDataset(ProbepktAuswPanel.LEFT);
                ProbepktAuswPanel.this.dataSet2 = ProbepktAuswPanel.this.createDataset(ProbepktAuswPanel.RIGHT);
                this.seriesCount = ProbepktAuswPanel.this.dataSet1.getSeriesCount() + ProbepktAuswPanel.this.dataSet2.getSeriesCount();
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                if (this.seriesCount > 0) {
                    AuswertungsDialog dialog = new AuswertungsDialog("Probenahmen", ProbepktAuswPanel.this.dataSet1, ProbepktAuswPanel.this.dataSet2, ProbepktAuswPanel.this.frame);
                    dialog.setVisible(true);
                } else {
                    AUIKataster.debugOutput("Keine Parameter ausgew\u00e4hlt!", "showResultDualAxis");
                }
            }
        };
        AUIKataster.debugOutput("Bereite Auswertung vor...", "showResultDualAxis");
        worker.start();
    }

    private TimeSeriesCollection createDataset(String axis) {
        JList paramList;
        TimeSeriesCollection col = new TimeSeriesCollection();
        if (axis.equals(LEFT)) {
            int parameterAnzahl = this.getLeftList().getModel().getSize();
            paramList = this.getLeftList();
        } else {
            int parameterAnzahl = this.getRightList().getModel().getSize();
            paramList = this.getRightList();
        }
        AtlEinheiten einheit = AtlEinheiten.getEinheit(42);
        Timestamp vonDate = new Timestamp(this.getVonDateChooser().getDate().getTime());
        Timestamp bisDate = new Timestamp(this.getBisDateChooser().getDate().getTime());
        String analyeVon = this.analyseVonBox.getSelectedItem().toString();
        this.pkt = AtlProbepkt.getProbepunktByObjekt(this.hauptModul.getObjekt());
        this.createSeries(paramList, this.pkt, einheit, vonDate, bisDate, analyeVon, col);
        return col;
    }

    private void createSeries(JList paramList, AtlProbepkt pkt, AtlEinheiten einheit, Date vonDate, Date bisDate, String analyseVon, TimeSeriesCollection col) {
        if (pkt != null) {
            for (int i = 0; i < paramList.getModel().getSize(); ++i) {
                AtlParameter p = (AtlParameter)paramList.getModel().getElementAt(i);
                List list = AtlAnalyseposition.getAnalysepositionen(p, einheit, pkt, vonDate, bisDate, analyseVon);
                TimeSeries series = ChartDataSets.createAnalysePositionenSeries(list, p + " ", einheit.toString());
                col.addSeries(series);
            }
        }
    }

    private JDateChooser getVonDateChooser() {
        if (this.vonDateChooser == null) {
            this.vonDateChooser = new JDateChooser("dd.MM.yy", false);
        }
        return this.vonDateChooser;
    }

    private JDateChooser getBisDateChooser() {
        if (this.bisDateChooser == null) {
            this.bisDateChooser = new JDateChooser("dd.MM.yy", false);
        }
        return this.bisDateChooser;
    }

    private JComboBox getAnalyseVonBox() {
        if (this.analyseVonBox == null) {
            String[] inst = AtlAnalyseposition.getAnalysierer();
            this.analyseVonBox = new JComboBox<String>(inst);
            this.analyseVonBox.setEditable(true);
            this.analyseVonBox.setModel(new DefaultComboBoxModel<String>(inst));
            this.analyseVonBox.setPrototypeDisplayValue("Faulschlamm   abc");
        }
        return this.analyseVonBox;
    }

    private JList getLeftList() {
        if (this.leftList == null) {
            DefaultListModel listModel = new DefaultListModel();
            this.leftList = new JList(listModel);
            this.leftList.setPrototypeCellValue("Abcdefghij (Ab)");
            this.leftList.setSelectionMode(0);
        }
        return this.leftList;
    }

    private JList getRightList() {
        if (this.rightList == null) {
            DefaultListModel listModel = new DefaultListModel();
            this.rightList = new JList(listModel);
            this.rightList.setPrototypeCellValue("Abcdefghij (Ab)");
            this.rightList.setSelectionMode(0);
        }
        return this.rightList;
    }

    private JButton createRLButton(boolean left, String paramId) {
        String direction;
        Icon rIcon;
        Icon icon;
        if (left) {
            icon = AuikUtils.getIcon(16, "left.png");
            rIcon = AuikUtils.getIcon(16, "left_a.png");
            direction = LEFT;
        } else {
            icon = AuikUtils.getIcon(16, "right.png");
            rIcon = AuikUtils.getIcon(16, "right_a.png");
            direction = RIGHT;
        }
        JButton button = new JButton(icon);
        button.setRolloverIcon(rIcon);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setActionCommand(direction + "_" + paramId);
        button.addActionListener(this.getRLButtonListener());
        return button;
    }

    private JButton getLeftDeleteButton() {
        if (this.leftDeleteButton == null) {
            this.leftDeleteButton = new JButton("L\u00f6schen");
            this.leftDeleteButton.setEnabled(false);
            this.leftDeleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = ProbepktAuswPanel.this.getLeftList().getSelectedIndex();
                    DefaultListModel leftModel = (DefaultListModel)ProbepktAuswPanel.this.getLeftList().getModel();
                    if (index != -1) {
                        leftModel.remove(index);
                        int size = leftModel.getSize();
                        if (size == 0) {
                            ProbepktAuswPanel.this.leftDeleteButton.setEnabled(false);
                        } else {
                            if (index == size) {
                                --index;
                            }
                            ProbepktAuswPanel.this.getLeftList().setSelectedIndex(index);
                            ProbepktAuswPanel.this.getLeftList().ensureIndexIsVisible(index);
                        }
                    }
                }
            });
        }
        return this.leftDeleteButton;
    }

    private JButton getRightDeleteButton() {
        if (this.rightDeleteButton == null) {
            this.rightDeleteButton = new JButton("L\u00f6schen");
            this.rightDeleteButton.setEnabled(false);
            this.rightDeleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = ProbepktAuswPanel.this.getRightList().getSelectedIndex();
                    DefaultListModel rightModel = (DefaultListModel)ProbepktAuswPanel.this.getRightList().getModel();
                    if (index != -1) {
                        rightModel.remove(index);
                        int size = rightModel.getSize();
                        if (size == 0) {
                            ProbepktAuswPanel.this.rightDeleteButton.setEnabled(false);
                        } else {
                            if (index == size) {
                                --index;
                            }
                            ProbepktAuswPanel.this.getRightList().setSelectedIndex(index);
                            ProbepktAuswPanel.this.getRightList().ensureIndexIsVisible(index);
                        }
                    }
                }
            });
        }
        return this.rightDeleteButton;
    }

    private ActionListener getRLButtonListener() {
        if (this.rlButtonListener == null) {
            this.rlButtonListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String direction = e.getActionCommand().replaceFirst("_.*", "");
                    String paramId = e.getActionCommand().replaceFirst(".*_", "");
                    AtlParameter param = null;
                    if (!paramId.equals("")) {
                        param = paramId.equals("box") ? (AtlParameter)ProbepktAuswPanel.this.getParameterBox().getSelectedItem() : AtlParameter.getParameter(paramId);
                    }
                    if (param != null) {
                        DefaultListModel leftModel = (DefaultListModel)ProbepktAuswPanel.this.getLeftList().getModel();
                        DefaultListModel rightModel = (DefaultListModel)ProbepktAuswPanel.this.getRightList().getModel();
                        if (direction.equals(ProbepktAuswPanel.LEFT)) {
                            if (!leftModel.contains(param)) {
                                if (rightModel.contains(param)) {
                                    rightModel.removeElement(param);
                                    if (rightModel.getSize() == 0) {
                                        ProbepktAuswPanel.this.getRightDeleteButton().setEnabled(false);
                                    }
                                }
                                leftModel.addElement(param);
                                ProbepktAuswPanel.this.getLeftDeleteButton().setEnabled(true);
                            }
                        } else if (direction.equals(ProbepktAuswPanel.RIGHT) && !rightModel.contains(param)) {
                            if (leftModel.contains(param)) {
                                leftModel.removeElement(param);
                                if (leftModel.getSize() == 0) {
                                    ProbepktAuswPanel.this.getLeftDeleteButton().setEnabled(false);
                                }
                            }
                            rightModel.addElement(param);
                            ProbepktAuswPanel.this.getRightDeleteButton().setEnabled(true);
                        }
                    }
                }
            };
        }
        return this.rlButtonListener;
    }

    public void fetchFormData() throws RuntimeException {
    }

    public void updateForm() throws RuntimeException {
    }

    public void clearForm() {
    }

    public void enableAll(boolean enabled) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    private class AuswertungsDialog
    extends JDialog {
        private JButton speichernButton;
        private JButton abbrechenButton;
        private JTable exportTable;
        private JPopupMenu tabellenMenu;
        private JTabbedPane tabbedPane;
        private ChartPanel chartPanel;
        private DialogListener listener;
        private String title;
        private TimeSeriesCollection leftDataset;
        private TimeSeriesCollection rightDataset;
        private HauptFrame owner;

        public AuswertungsDialog(String title, TimeSeriesCollection leftDataset, TimeSeriesCollection rightDataset, HauptFrame owner) {
            super(owner, title + "-Auswertung", true);
            this.owner = owner;
            this.title = title;
            this.leftDataset = leftDataset;
            this.rightDataset = rightDataset;
            this.listener = new DialogListener();
            this.setDefaultCloseOperation(0);
            this.addWindowListener(this.listener);
            this.speichernButton = new JButton("Speichern");
            this.speichernButton.addActionListener(this.listener);
            this.abbrechenButton = new JButton("Schlie\u00dfen");
            this.abbrechenButton.addActionListener(this.listener);
            JPanel tmp = new JPanel(new BorderLayout(0, 7));
            tmp.add((Component)this.initializeContent(), "Center");
            JPanel buttonBar = ButtonBarFactory.buildOKCancelBar((JButton)this.speichernButton, (JButton)this.abbrechenButton);
            tmp.add((Component)buttonBar, "South");
            tmp.setBorder(Borders.TABBED_DIALOG_BORDER);
            this.setContentPane(tmp);
            this.pack();
            this.setLocationRelativeTo(owner);
        }

        private JComponent initializeContent() {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Diagramm", this.createDiagrammPanel());
            this.tabbedPane.addTab("Tabelle", this.createTabellenPanel());
            return this.tabbedPane;
        }

        private JPanel createDiagrammPanel() {
            JFreeChart chart = this.rightDataset == null ? Charts.createDefaultTimeSeriesChart(this.title, this.leftDataset) : Charts.createDefaultTimeSeriesChart(this.title, this.leftDataset, this.rightDataset);
            this.chartPanel = new ChartPanel(chart, false);
            this.chartPanel.setBorder(Borders.DIALOG_BORDER);
            return this.chartPanel;
        }

        private JComponent createTabellenPanel() {
            this.exportTable = new JTable(new ExportTableModel(this.leftDataset, this.rightDataset));
            this.exportTable.setBorder(BorderFactory.createBevelBorder(0));
            this.exportTable.setColumnSelectionAllowed(true);
            this.exportTable.setRowSelectionAllowed(true);
            this.exportTable.setAutoResizeMode(0);
            this.exportTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    AuswertungsDialog.this.showTabellenPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    AuswertungsDialog.this.showTabellenPopup(e);
                }
            });
            DefaultTableCellRenderer zentrierterRenderer = new DefaultTableCellRenderer();
            zentrierterRenderer.setHorizontalAlignment(0);
            DefaultTableCellRenderer rechtsBuendigRenderer = new DefaultTableCellRenderer();
            rechtsBuendigRenderer.setHorizontalAlignment(4);
            TableColumn column = null;
            for (int i = 0; i < this.exportTable.getColumnCount(); ++i) {
                column = this.exportTable.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setCellRenderer(zentrierterRenderer);
                    column.setPreferredWidth(75);
                    continue;
                }
                column.setCellRenderer(rechtsBuendigRenderer);
                column.setPreferredWidth(90);
            }
            JScrollPane tabellenScroller = new JScrollPane(this.exportTable, 20, 32);
            tabellenScroller.setBorder(Borders.DIALOG_BORDER);
            return tabellenScroller;
        }

        public void saveTabelle() {
            String[] csv = new String[]{"csv"};
            this.owner = ProbepktAuswPanel.this.hauptModul.getFrame();
            File exportDatei = this.owner.saveFile(csv);
            if (exportDatei != null) {
                String ext = AuikUtils.getExtension(exportDatei);
                if (ext == null) {
                    String newExt = exportDatei.getName().endsWith(".") ? "csv" : ".csv";
                    exportDatei = new File(exportDatei.getParent(), exportDatei.getName() + newExt);
                }
                boolean doIt = false;
                if (exportDatei.exists()) {
                    boolean answer = this.owner.showQuestion("Soll die vorhandene Datei " + exportDatei.getName() + " wirklich \u00fcberschrieben werden?", "Datei bereits vorhanden!");
                    if (answer && exportDatei.canWrite()) {
                        doIt = true;
                    }
                } else if (exportDatei.getParentFile().canWrite()) {
                    doIt = true;
                }
                if (doIt) {
                    AUIKataster.debugOutput("Speichere nach '" + exportDatei.getName() + "' (Ext: '" + ext + "') in '" + exportDatei.getParent() + "' !");
                    if (AuikUtils.exportTableDataToCVS(this.exportTable, exportDatei)) {
                        this.owner.showInfoMessage("Speichern der CSV-Datei erfolgreich!", "Speichern erfolgreich");
                    } else {
                        AUIKataster.debugOutput("Beim Speichern der Datei '" + exportDatei + "' trat ein Fehler auf!");
                        this.owner.showErrorMessage("Beim Speichern der Datei '" + exportDatei + "' trat ein Fehler auf!");
                    }
                }
            }
        }

        private void showTabellenPopup(MouseEvent e) {
            if (this.tabellenMenu == null) {
                this.tabellenMenu = new JPopupMenu("Tabelle");
                JMenuItem speichernItem = new JMenuItem(new AbstractAction("Speichern"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AuswertungsDialog.this.saveTabelle();
                    }
                });
                this.tabellenMenu.add(speichernItem);
            }
            if (e.isPopupTrigger()) {
                Point origin = e.getPoint();
                int row = this.exportTable.rowAtPoint(origin);
                int col = this.exportTable.columnAtPoint(origin);
                if (row != -1) {
                    this.exportTable.setRowSelectionInterval(row, row);
                    this.exportTable.setColumnSelectionInterval(col, col);
                    this.tabellenMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        public void doAbbrechen() {
            this.dispose();
        }

        public void doSpeichern() {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                try {
                    this.chartPanel.doSaveAs();
                }
                catch (IOException e) {
                    AUIKataster.debugOutput("Konnte Datei nicht speichern!");
                }
            } else if (this.tabbedPane.getSelectedIndex() == 1) {
                this.saveTabelle();
            }
        }

        private class ExportTableModel
        extends AbstractTableModel {
            private TimeSeriesCollection col1;
            private TimeSeriesCollection col2;
            private List dateList;

            public ExportTableModel(TimeSeriesCollection col1, TimeSeriesCollection col2) {
                this.col1 = col1;
                this.col2 = col2;
                this.dateList = new ArrayList();
                this.initializeData();
            }

            private void initializeData() {
                APosDataItem item;
                int j;
                TimeSeries series;
                int i;
                for (i = 0; i < this.col1.getSeriesCount(); ++i) {
                    series = this.col1.getSeries(i);
                    for (j = 0; j < series.getItemCount(); ++j) {
                        item = (APosDataItem)series.getDataItem(j);
                        if (this.dateList.contains(item.getMinute())) continue;
                        this.dateList.add(item.getMinute());
                    }
                }
                if (this.col2 != null) {
                    for (i = 0; i < this.col2.getSeriesCount(); ++i) {
                        series = this.col2.getSeries(i);
                        for (j = 0; j < series.getItemCount(); ++j) {
                            item = (APosDataItem)series.getDataItem(j);
                            if (this.dateList.contains(item.getMinute())) continue;
                            this.dateList.add(item.getMinute());
                        }
                    }
                }
                Collections.sort(this.dateList);
            }

            @Override
            public int getColumnCount() {
                return this.col1.getSeriesCount() + (this.col2 != null ? this.col2.getSeriesCount() : 0) + 1;
            }

            @Override
            public int getRowCount() {
                return this.dateList.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String tmp = "!OOB!";
                NumberFormat kommaFormat = NumberFormat.getNumberInstance();
                kommaFormat.setGroupingUsed(false);
                kommaFormat.setMinimumFractionDigits(1);
                int seriesIndex = columnIndex - 1;
                int series2Index = seriesIndex - this.col1.getSeriesCount();
                int itemIndex = rowIndex;
                Minute min = (Minute)this.dateList.get(itemIndex);
                if (columnIndex == 0) {
                    Date date = new Date(min.getFirstMillisecond());
                    tmp = AuikUtils.getStringFromDate(date);
                } else {
                    APosDataItem item = null;
                    if (seriesIndex < this.col1.getSeriesCount()) {
                        item = (APosDataItem)this.col1.getSeries(seriesIndex).getDataItem((RegularTimePeriod)min);
                    } else if (this.col2 != null) {
                        item = (APosDataItem)this.col2.getSeries(series2Index).getDataItem((RegularTimePeriod)min);
                    }
                    tmp = item != null ? kommaFormat.format(item.getValue()) : "";
                }
                return tmp;
            }

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public String getColumnName(int column) {
                String tmp = "!OOB!";
                int seriesIndex = column - 1;
                int series2Index = seriesIndex - this.col1.getSeriesCount();
                if (column == 0) {
                    tmp = "Datum";
                } else if (seriesIndex < this.col1.getSeriesCount()) {
                    tmp = this.col1.getSeriesName(seriesIndex) + ", " + this.col1.getSeries(seriesIndex).getRangeDescription();
                } else if (this.col2 != null) {
                    tmp = this.col2.getSeriesName(series2Index) + ", " + this.col2.getSeries(series2Index).getRangeDescription();
                }
                return tmp;
            }
        }

        private class DialogListener
        extends WindowAdapter
        implements ActionListener {
            private DialogListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == AuswertungsDialog.this.abbrechenButton) {
                    AuswertungsDialog.this.doAbbrechen();
                } else if (e.getSource() == AuswertungsDialog.this.speichernButton) {
                    AuswertungsDialog.this.doSpeichern();
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                AuswertungsDialog.this.doAbbrechen();
            }
        }
    }
}

