/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.indeinl.IndeinlGenehmigung;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class GenehmigungPanel
extends JPanel {
    private String name = "Genehmigung";
    private BasisObjektBearbeiten hauptModul;
    private JTextArea genBemerkungArea = null;
    private TextFieldDateChooser antragsDatum = null;
    private TextFieldDateChooser genehmigungsDatum = null;
    private TextFieldDateChooser aenderungsDatum = null;
    private TextFieldDateChooser befristetbisDatum = null;
    private JFormattedTextField anhangFeld = null;
    private JFormattedTextField genMengeFeld = null;
    private JCheckBox befristetCheck = null;
    private JCheckBox gen58Check = null;
    private JCheckBox gen59Check = null;
    private JCheckBox selbstueberwCheck = null;
    private JCheckBox eSatzungCheck = null;
    private JButton saveGenehmigungButton = null;
    private IndeinlGenehmigung fachdaten = null;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;

    public GenehmigungPanel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:80dlu, 5dlu, 80dlu, 5dlu, r:35dlu, 5dlu, 80dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Fachdaten");
        builder.append("Antragsdatum:", (Component)this.getAntragsDatum());
        builder.append("", (Component)this.getgen58CheckBox());
        builder.nextLine();
        builder.append("Genehmigungsdatum:", (Component)this.getGenehmigungsDatum());
        builder.append("", (Component)this.getgen59CheckBox());
        builder.nextLine();
        builder.append("\u00c4nderungsdatum:", (Component)this.getAenderungsDatum());
        builder.append("", (Component)this.getselbCheckBox());
        builder.nextLine();
        builder.append("Anhang:", (Component)this.getAnhangFeld());
        builder.append("", (Component)this.getesaCheckBox());
        builder.nextLine();
        builder.append("Genehmigte Menge [m\u00b3]:", (Component)this.getGenMengeFeld());
        builder.append("", (Component)this.getbefCheckBox());
        builder.nextLine();
        builder.append("");
        builder.append("");
        builder.append("bis:", (Component)this.getBefristetDatum());
        builder.nextLine();
        builder.appendSeparator("Bemerkungen");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane bemerkungsScroller = new JScrollPane(this.getGenBemerkungArea(), 20, 31);
        builder.appendRow("fill:30dlu");
        builder.append((Component)bemerkungsScroller, 7);
        builder.nextLine();
        builder.appendSeparator("Verkn\u00fcpfte Objekte");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.appendRow("fill:100dlu");
        builder.append((Component)objektverknuepfungScroller, 7);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton(), (JButton)this.getsaveGenehmigungButton());
        builder.append((Component)buttonBar, 7);
    }

    public void fetchFormData() throws RuntimeException {
        this.fachdaten = IndeinlGenehmigung.getGenByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("Genehmigung Objekt aus DB geholt: ID" + this.fachdaten, "GenehmigungPanel.fetchFormData");
    }

    public void updateForm() throws RuntimeException {
        if (this.fachdaten != null) {
            if (this.fachdaten.getBemerkungen() != null) {
                this.getGenBemerkungArea().setText(this.fachdaten.getBemerkungen());
            }
            if (this.fachdaten.getAnhang() != null) {
                this.getAnhangFeld().setText(this.fachdaten.getAnhang().toString());
            }
            if (this.fachdaten.getGenMenge() != null) {
                this.getGenMengeFeld().setText(this.fachdaten.getGenMenge().toString());
            }
            if (this.fachdaten.getAntragDatum() != null) {
                this.getAntragsDatum().setDate(this.fachdaten.getAntragDatum());
            }
            if (this.fachdaten.getErstellungsDatum() != null) {
                this.getGenehmigungsDatum().setDate(this.fachdaten.getErstellungsDatum());
            }
            if (this.fachdaten.getAenderungsDatum() != null) {
                this.getAenderungsDatum().setDate(this.fachdaten.getAenderungsDatum());
            }
            if (this.fachdaten.getBefristetBis() != null) {
                this.getBefristetDatum().setDate(this.fachdaten.getBefristetBis());
            }
            if (this.fachdaten.getBefristet() != null) {
                if (this.fachdaten.getBefristet().booleanValue()) {
                    this.getbefCheckBox().setSelected(true);
                } else {
                    this.getbefCheckBox().setSelected(false);
                }
            }
            if (this.fachdaten.getGen58() != null) {
                if (this.fachdaten.getGen58().booleanValue()) {
                    this.getgen58CheckBox().setSelected(true);
                } else {
                    this.getgen58CheckBox().setSelected(false);
                }
            }
            if (this.fachdaten.getGen59() != null) {
                if (this.fachdaten.getGen59().booleanValue()) {
                    this.getgen59CheckBox().setSelected(true);
                } else {
                    this.getgen59CheckBox().setSelected(false);
                }
            }
            if (this.fachdaten.getSelbstueberw() != null) {
                if (this.fachdaten.getSelbstueberw().booleanValue()) {
                    this.getselbCheckBox().setSelected(true);
                } else {
                    this.getselbCheckBox().setSelected(false);
                }
            }
            if (this.fachdaten.getEsatzung() != null) {
                if (this.fachdaten.getEsatzung().booleanValue()) {
                    this.getesaCheckBox().setSelected(true);
                } else {
                    this.getesaCheckBox().setSelected(false);
                }
            }
            this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
        }
    }

    public void clearForm() {
        this.getGenBemerkungArea().setText(null);
        this.getAnhangFeld().setText(null);
        this.getGenMengeFeld().setText(null);
        this.getAntragsDatum().setDate(null);
        this.getAenderungsDatum().setDate(null);
        this.getGenehmigungsDatum().setDate(null);
        this.getBefristetDatum().setDate(null);
        this.getbefCheckBox().setSelected(false);
        this.getgen58CheckBox().setSelected(false);
        this.getgen59CheckBox().setSelected(false);
        this.getselbCheckBox().setSelected(false);
        this.getesaCheckBox().setSelected(false);
    }

    public void enableAll(boolean enabled) {
        this.getGenBemerkungArea().setEnabled(enabled);
        this.getAnhangFeld().setEnabled(enabled);
        this.getGenMengeFeld().setEnabled(enabled);
        this.getAntragsDatum().setEnabled(enabled);
        this.getAenderungsDatum().setEnabled(enabled);
        this.getGenehmigungsDatum().setEnabled(enabled);
        this.getBefristetDatum().setEnabled(enabled);
        this.getbefCheckBox().setEnabled(enabled);
        this.getgen58CheckBox().setEnabled(enabled);
        this.getgen59CheckBox().setEnabled(enabled);
        this.getselbCheckBox().setEnabled(enabled);
        this.getesaCheckBox().setEnabled(enabled);
    }

    private boolean saveGenehmigungDaten() {
        String bemerkungen = this.genBemerkungArea.getText();
        if ("".equals(bemerkungen)) {
            this.fachdaten.setBemerkungen(null);
        } else {
            this.fachdaten.setBemerkungen(bemerkungen);
        }
        Date antrag = this.antragsDatum.getDate();
        this.fachdaten.setAntragDatum(antrag);
        Date aend = this.aenderungsDatum.getDate();
        this.fachdaten.setAenderungsDatum(aend);
        Date erst = this.genehmigungsDatum.getDate();
        this.fachdaten.setErstellungsDatum(erst);
        Date befr = this.befristetbisDatum.getDate();
        this.fachdaten.setBefristetBis(befr);
        Integer anhang = ((IntegerField)this.anhangFeld).getIntValue();
        this.fachdaten.setAnhang(anhang);
        Integer menge = ((IntegerField)this.genMengeFeld).getIntValue();
        this.fachdaten.setGenMenge(menge);
        if (this.getbefCheckBox().isSelected()) {
            this.fachdaten.setBefristet(true);
        } else {
            this.fachdaten.setBefristet(false);
        }
        if (this.getgen58CheckBox().isSelected()) {
            this.fachdaten.setGen58(true);
        } else {
            this.fachdaten.setGen58(false);
        }
        if (this.getgen59CheckBox().isSelected()) {
            this.fachdaten.setGen59(true);
        } else {
            this.fachdaten.setGen59(false);
        }
        if (this.getselbCheckBox().isSelected()) {
            this.fachdaten.setSelbstueberw(true);
        } else {
            this.fachdaten.setSelbstueberw(false);
        }
        if (this.getesaCheckBox().isSelected()) {
            this.fachdaten.setEsatzung(true);
        } else {
            this.fachdaten.setEsatzung(false);
        }
        boolean success = IndeinlGenehmigung.saveFachdaten(this.fachdaten);
        if (success) {
            AUIKataster.debugOutput("Uebergabestelle Objekt " + this.fachdaten.getObjektid() + " gespeichert.", "ObjektGenehmigung.saveGenehmigungDaten");
        } else {
            AUIKataster.debugOutput("Uebergabestelle Objekt " + this.fachdaten + " konnte nicht gespeichert werden!", "GenehmigungPanel.saveGenehmigungDaten");
        }
        return success;
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.fachdaten == null) {
            this.fachdaten = new IndeinlGenehmigung();
            this.fachdaten.setBasisObjekt(this.hauptModul.getObjekt());
            IndeinlGenehmigung.saveFachdaten(this.fachdaten);
            AUIKataster.debugOutput("Neues Genehmigung Objekt " + this.fachdaten + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
        }
    }

    private JButton getsaveGenehmigungButton() {
        if (this.saveGenehmigungButton == null) {
            this.saveGenehmigungButton = new JButton("Speichern");
            this.saveGenehmigungButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenehmigungPanel.this.enableAll(false);
                    if (GenehmigungPanel.this.saveGenehmigungDaten()) {
                        GenehmigungPanel.this.hauptModul.getFrame().changeStatus("Genehmigung " + GenehmigungPanel.this.fachdaten.getObjektid() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        GenehmigungPanel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern des Uebergabestelle Objekt!", HauptFrame.ERROR_COLOR);
                    }
                    GenehmigungPanel.this.hauptModul.fillForm();
                }
            });
        }
        return this.saveGenehmigungButton;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private TextFieldDateChooser getAntragsDatum() {
        if (this.antragsDatum == null) {
            this.antragsDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.antragsDatum;
    }

    private TextFieldDateChooser getAenderungsDatum() {
        if (this.aenderungsDatum == null) {
            this.aenderungsDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.aenderungsDatum;
    }

    private TextFieldDateChooser getGenehmigungsDatum() {
        if (this.genehmigungsDatum == null) {
            this.genehmigungsDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.genehmigungsDatum;
    }

    private TextFieldDateChooser getBefristetDatum() {
        if (this.befristetbisDatum == null) {
            this.befristetbisDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.befristetbisDatum;
    }

    private JFormattedTextField getAnhangFeld() {
        if (this.anhangFeld == null) {
            this.anhangFeld = new IntegerField();
        }
        return this.anhangFeld;
    }

    private JFormattedTextField getGenMengeFeld() {
        if (this.genMengeFeld == null) {
            this.genMengeFeld = new IntegerField();
        }
        return this.genMengeFeld;
    }

    private JCheckBox getbefCheckBox() {
        if (this.befristetCheck == null) {
            this.befristetCheck = new JCheckBox("Genehmigung befristet");
        }
        return this.befristetCheck;
    }

    private JCheckBox getgen58CheckBox() {
        if (this.gen58Check == null) {
            this.gen58Check = new JCheckBox("58er Genehmigung");
        }
        return this.gen58Check;
    }

    private JCheckBox getgen59CheckBox() {
        if (this.gen59Check == null) {
            this.gen59Check = new JCheckBox("59er Genehmigung");
        }
        return this.gen59Check;
    }

    private JCheckBox getselbCheckBox() {
        if (this.selbstueberwCheck == null) {
            this.selbstueberwCheck = new JCheckBox("Selbst\u00fcberwachung");
        }
        return this.selbstueberwCheck;
    }

    private JCheckBox getesaCheckBox() {
        if (this.eSatzungCheck == null) {
            this.eSatzungCheck = new JCheckBox("E-Satzungs\u00fcberwachung");
        }
        return this.eSatzungCheck;
    }

    private JTextArea getGenBemerkungArea() {
        if (this.genBemerkungArea == null) {
            this.genBemerkungArea = new LimitedTextArea(150);
            this.genBemerkungArea.setLineWrap(true);
            this.genBemerkungArea.setWrapStyleWord(true);
        }
        return this.genBemerkungArea;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = GenehmigungPanel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = GenehmigungPanel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != GenehmigungPanel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                GenehmigungPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                GenehmigungPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            GenehmigungPanel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    GenehmigungPanel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    GenehmigungPanel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = GenehmigungPanel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && GenehmigungPanel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = GenehmigungPanel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(GenehmigungPanel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (GenehmigungPanel.this.objektVerknuepfungModel.removeRow(row)) {
                                GenehmigungPanel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                GenehmigungPanel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(GenehmigungPanel.this.hauptModul.getFrame(), GenehmigungPanel.this.fachdaten.getBasisObjekt(), GenehmigungPanel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }
}

