/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.ReportManager;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektchrono;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.EditableListTableModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class ChronoPanel
extends JPanel {
    private String name = "Chronologie";
    private BasisObjektBearbeiten hauptModul;
    private ChronoModel chronoModel;
    private Action chronoItemLoeschAction;
    private Action chronoSaveAction;
    private JPopupMenu chronoPopup;
    private Integer objektid;
    private String betreiber;
    private String art;
    private String standort;
    private JTable chronoTable;
    private JButton saveButton;
    private JButton reportListeButton;

    public ChronoPanel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        AUIKataster.debugOutput(hauptModul.getObjekt().toString());
        this.chronoModel = new ChronoModel();
        this.reportListeButton = new JButton("PDF-Liste generieren");
        this.reportListeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChronoPanel.this.showReportListe();
            }
        });
        JScrollPane chronoScroller = new JScrollPane(this.getChronoTable());
        FormLayout layout = new FormLayout("pref 3dlu, pref, 3dlu, pref:g", "f:100dlu:g, 3dlu, pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.append((Component)chronoScroller, 5);
        builder.nextLine(2);
        builder.append((Component)this.reportListeButton, (Component)this.getSaveButton());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void fetchFormData() {
        this.chronoModel.setList(BasisObjektchrono.getChronoByObjekt(this.hauptModul.getObjekt()));
    }

    public void updateForm() {
        this.chronoModel.fireTableDataChanged();
    }

    public void speichernChronologie() {
        if (this.chronoTable.getCellEditor() != null) {
            this.chronoTable.getCellEditor().stopCellEditing();
        }
        List chronoListe = this.chronoModel.getList();
        boolean sachbear = true;
        boolean gespeichert = true;
        for (int i = 0; i < chronoListe.size(); ++i) {
            BasisObjektchrono chrono = (BasisObjektchrono)chronoListe.get(i);
            if (chrono.getId() == null) {
                String sachbearbeiter = chrono.getSachbearbeiter();
                if (sachbearbeiter == null || sachbearbeiter.length() == 0) {
                    sachbear = false;
                    continue;
                }
                BasisObjektchrono.saveObjektChrono(chrono);
                this.chronoModel.fireTableDataChanged();
                if (BasisObjektchrono.saveObjektChrono(chrono)) continue;
                gespeichert = false;
                continue;
            }
            BasisObjektchrono.saveObjektChrono(chrono);
            this.chronoModel.fireTableDataChanged();
            if (BasisObjektchrono.saveObjektChrono(chrono)) continue;
            gespeichert = false;
        }
        if (!sachbear & gespeichert) {
            this.hauptModul.getFrame().showErrorMessage("Es muss ein Sachbearbeiter angegeben werden!", "Sachbearbeiter fehlt");
        } else if (sachbear & gespeichert) {
            this.hauptModul.getFrame().changeStatus("Speichern erfolgreich", HauptFrame.SUCCESS_COLOR);
        } else if (!gespeichert) {
            this.hauptModul.getFrame().changeStatus("Chronoligie konnte nicht gespeichert werden", HauptFrame.ERROR_COLOR);
        }
    }

    public void showReportListe() {
        this.objektid = this.hauptModul.getObjekt().getObjektid();
        this.betreiber = this.hauptModul.getObjekt().getBasisBetreiber().toString();
        this.standort = this.hauptModul.getObjekt().getBasisStandort().toString();
        this.art = this.hauptModul.getObjekt().getBasisObjektarten().getObjektart();
        if (this.objektid != null && this.betreiber != null && this.standort != null && this.art != null) {
            AUIKataster.debugOutput("Starte Objekt-Chronologie Report f\u00fcr ObjektId = " + this.objektid);
            ReportManager.getInstance().startReportWorker("Objekt-Chronologie", this.objektid, this.betreiber, this.standort, this.art, this.reportListeButton);
        } else {
            AUIKataster.debugOutput("ObjektID, Betreiber, Standort oder Art == NULL");
        }
    }

    private Action getChronoItemLoeschAction() {
        if (this.chronoItemLoeschAction == null) {
            this.chronoItemLoeschAction = new AbstractAction("Eintrag l\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ChronoPanel.this.getChronoTable().getSelectedRow();
                    if (row != -1) {
                        ChronoPanel.this.chronoModel.removeRow(row);
                    }
                }
            };
            this.chronoItemLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.chronoItemLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.chronoItemLoeschAction;
    }

    private Action getChronoSaveAction() {
        if (this.chronoSaveAction == null) {
            this.chronoSaveAction = new AbstractAction("Chronologie speichern"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChronoPanel.this.speichernChronologie();
                }
            };
            this.chronoSaveAction.putValue("MnemonicKey", new Integer(83));
            this.chronoSaveAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 512, false));
        }
        return this.chronoSaveAction;
    }

    private void showChronoPopup(MouseEvent e) {
        if (this.chronoPopup == null) {
            this.chronoPopup = new JPopupMenu("Chronologie");
            JMenuItem loeschItem = new JMenuItem(this.getChronoItemLoeschAction());
            JMenuItem saveItem = new JMenuItem(this.getChronoSaveAction());
            this.chronoPopup.add(loeschItem);
            this.chronoPopup.add(saveItem);
        }
        if (e.isPopupTrigger()) {
            Point origin = e.getPoint();
            int row = this.getChronoTable().rowAtPoint(origin);
            if (row != -1) {
                this.getChronoTable().setRowSelectionInterval(row, row);
                this.chronoPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private JTable getChronoTable() {
        if (this.chronoTable == null) {
            this.chronoTable = new JTable(this.chronoModel);
            this.chronoTable.getColumnModel().getColumn(0).setMaxWidth(80);
            this.chronoTable.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.chronoTable.getColumnModel().getColumn(1).setMaxWidth(100);
            this.chronoTable.getColumnModel().getColumn(2).setPreferredWidth(300);
            this.chronoTable.setSelectionMode(0);
            this.chronoTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ChronoPanel.this.showChronoPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    ChronoPanel.this.showChronoPopup(e);
                }
            });
            this.chronoTable.getInputMap().put((KeyStroke)this.getChronoItemLoeschAction().getValue("AcceleratorKey"), this.getChronoItemLoeschAction().getValue("Name"));
            this.chronoTable.getActionMap().put(this.getChronoItemLoeschAction().getValue("Name"), this.getChronoItemLoeschAction());
        }
        return this.chronoTable;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton("Objekt-Chronologie speichern");
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChronoPanel.this.speichernChronologie();
                }
            });
        }
        return this.saveButton;
    }

    public class ChronoModel
    extends EditableListTableModel {
        private BasisObjekt obj;

        public ChronoModel() {
            super(new String[]{"Datum", "Sachbearbeiter", "Sachverhalt"}, false, true);
        }

        public void setBasisObjekt(BasisObjekt obj) {
            this.obj = obj;
            if (obj != null) {
                this.setList(BasisObjektchrono.getChronoByObjekt(obj));
                this.fireTableDataChanged();
            }
        }

        @Override
        public void editObject(Object objectAtRow, int columnIndex, Object newValue) {
            BasisObjektchrono chrono = (BasisObjektchrono)objectAtRow;
            String tmp = "";
            if (newValue instanceof String) {
                tmp = (String)newValue;
            }
            DateFormat format = DateFormat.getDateInstance(3);
            switch (columnIndex) {
                case 0: {
                    try {
                        Date tmpDate = format.parse(tmp);
                        chrono.setDatum(tmpDate);
                    }
                    catch (ParseException e) {}
                    break;
                }
                case 1: {
                    if (tmp.length() > 10) {
                        tmp = tmp.substring(0, 10);
                    }
                    chrono.setSachbearbeiter(tmp);
                    break;
                }
                case 2: {
                    if (tmp.length() > 255) {
                        tmp = tmp.substring(0, 255);
                    }
                    chrono.setSachverhalt(tmp);
                    break;
                }
            }
        }

        @Override
        public Object newObject() {
            BasisObjektchrono chr = new BasisObjektchrono();
            chr.setBasisObjekt(ChronoPanel.this.hauptModul.getObjekt());
            chr.setDatum(new Date());
            return chr;
        }

        @Override
        public boolean objectRemoved(Object objectAtRow) {
            BasisObjektchrono removedchr = (BasisObjektchrono)objectAtRow;
            boolean removed = removedchr.getId() != null ? BasisObjektchrono.removeObjektChrono(removedchr) : true;
            return removed;
        }

        @Override
        public Object getColumnValue(Object objectAtRow, int columnIndex) {
            String tmp;
            BasisObjektchrono oc = (BasisObjektchrono)objectAtRow;
            switch (columnIndex) {
                case 0: {
                    tmp = AuikUtils.getStringFromDate(oc.getDatum());
                    break;
                }
                case 1: {
                    tmp = oc.getSachbearbeiter();
                    break;
                }
                case 2: {
                    tmp = oc.getSachverhalt();
                    break;
                }
                default: {
                    tmp = "ERROR";
                }
            }
            return tmp;
        }

        public BasisObjektchrono getDatenSatz(int row) {
            return (BasisObjektchrono)this.getObjectAtRow(row);
        }

        @Override
        public void updateList() {
        }
    }
}

