/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektarten;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStandort;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.editors.BetreiberEditor;
import de.bielefeld.umweltamt.aui.module.common.editors.StandortEditor;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.BasisBetreiberModel;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.BasisStandortModel;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.MyKeySelectionManager;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.TabAction;
import de.bielefeld.umweltamt.aui.utils.TableFocusListener;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class BasisPanel
extends JPanel {
    private JTextField betreiberFeld;
    private JToolBar betreiberToolBar;
    private JButton betreiberChooseButton;
    private JButton betreiberEditButton;
    private JButton betreiberNewButton;
    private JButton betreiberGotoButton;
    private JTextField standortFeld;
    private JToolBar standortToolBar;
    private JButton standortChooseButton;
    private JButton standortEditButton;
    private JButton standortNewButton;
    private JButton standortGotoButton;
    private JComboBox artBox;
    private JCheckBox inaktivBox;
    private JTextArea beschreibungsArea;
    private JButton saveButton;
    private ActionListener editButtonListener;
    private ActionListener gotoButtonListener;
    private String name = "Objekt";
    private BasisObjektBearbeiten hauptModul;
    private BasisObjektarten[] objektarten;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;

    public BasisPanel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:50dlu, 5dlu, 180dlu, 3dlu, l:min(55dlu;p)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Eigenschaften");
        builder.append("Betreiber:", (Component)this.getBetreiberFeld());
        builder.append((Component)this.getBetreiberToolBar());
        builder.nextLine();
        builder.append("Standort:", (Component)this.getStandortFeld());
        builder.append((Component)this.getStandortToolBar());
        builder.nextLine();
        builder.append("Art:", (Component)this.getArtBox());
        builder.nextLine();
        builder.append("Inaktiv:", (Component)this.getInaktivBox());
        builder.nextLine();
        builder.appendSeparator("Beschreibung");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane beschreibungsScroller = new JScrollPane(this.getBeschreibungsArea(), 20, 31);
        builder.appendRow("fill:25dlu");
        builder.append((Component)beschreibungsScroller, 5);
        builder.appendRelatedComponentsGapRow();
        builder.nextLine(2);
        builder.appendSeparator("Verkn\u00fcpfte Objekte");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.appendRow("fill:100dlu");
        builder.append((Component)objektverknuepfungScroller, 5);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton(), (JButton)this.getSaveButton());
        builder.append((Component)buttonBar, 5);
    }

    public void fetchFormData() {
        if (this.objektarten == null) {
            this.objektarten = BasisObjektarten.getObjektarten();
        }
    }

    public void updateForm() {
        boolean neu;
        try {
            int id = this.hauptModul.getObjekt().getObjektid();
            neu = false;
        }
        catch (NullPointerException e) {
            neu = true;
        }
        if (neu) {
            if (this.objektarten != null && this.objektarten.length != this.getArtBox().getItemCount()) {
                this.getArtBox().setModel(new DefaultComboBoxModel<BasisObjektarten>(this.objektarten));
            }
        } else {
            this.getArtBox().removeAllItems();
            if (this.hauptModul.getObjekt().getBasisObjektarten().isAnh53Kl() | this.hauptModul.getObjekt().getBasisObjektarten().isAnh53Gr()) {
                this.getArtBox().addItem(BasisObjektarten.getObjektart(17));
                this.getArtBox().addItem(BasisObjektarten.getObjektart(18));
            } else {
                this.getArtBox().addItem(this.hauptModul.getObjekt().getBasisObjektarten());
            }
        }
        if (this.hauptModul.getObjekt() != null) {
            String toolTip;
            if (this.hauptModul.getObjekt().getBasisBetreiber() != null) {
                BasisBetreiber betr = this.hauptModul.getObjekt().getBasisBetreiber();
                this.getBetreiberFeld().setText(betr.toString());
                toolTip = "<html><b>Anrede:</b> " + (betr.getBetranrede() != null ? betr.getBetranrede() : "") + "<br>" + "<b>Name:</b> " + betr.getBetrname() + "<br>";
                if (betr.getBetrnamezus() != null) {
                    toolTip = toolTip + "<b>Zusatz:</b> " + betr.getBetrnamezus() + "<br><br>";
                }
                if (betr.getStrasse() != null) {
                    toolTip = toolTip + "<b>Adresse:</b><br>" + betr.getStrasse() + " " + betr.getHausnr();
                    if (betr.getHausnrzus() != null) {
                        toolTip = toolTip + betr.getHausnrzus();
                    }
                    toolTip = toolTip + "<br>";
                }
                toolTip = toolTip + (betr.getPlzzs() != null ? betr.getPlzzs().trim() + " - " : "") + (betr.getPlz() != null ? betr.getPlz() + " " : "") + (betr.getOrt() != null ? betr.getOrt() : "");
                if (betr.getTelefon() != null) {
                    toolTip = toolTip + "<br><br><b>Telefon:</b> " + betr.getTelefon();
                }
                toolTip = toolTip + "</html>";
                this.getBetreiberFeld().setToolTipText(toolTip);
            }
            if (this.hauptModul.getObjekt().getBasisStandort() != null) {
                BasisStandort sta = this.hauptModul.getObjekt().getBasisStandort();
                toolTip = "<html>" + sta + "<br>";
                if (sta.getPlz() != null) {
                    toolTip = toolTip + "<b>PLZ:</b> " + sta.getPlz() + "<br>";
                }
                toolTip = toolTip + "<b>Gemarkung:</b> " + sta.getBasisGemarkung() + (sta.getEntgebid() != null ? "<br><b>Entw.gebiet:</b> " + sta.getEntgebid() : "") + "</html>";
                this.getStandortFeld().setToolTipText(toolTip);
                this.getStandortFeld().setText(sta.toString());
            }
            if (this.hauptModul.getObjekt().getBasisObjektarten() != null) {
                this.getArtBox().setSelectedItem(this.hauptModul.getObjekt().getBasisObjektarten());
            }
            if (this.hauptModul.getObjekt().getInaktiv() != null) {
                if (this.hauptModul.getObjekt().getInaktiv().booleanValue()) {
                    this.getInaktivBox().setSelected(true);
                } else {
                    this.getInaktivBox().setSelected(false);
                }
            }
            if (this.hauptModul.getObjekt().getBeschreibung() != null) {
                this.getBeschreibungsArea().setText(this.hauptModul.getObjekt().getBeschreibung());
            }
            if (this.hauptModul.getObjekt().getObjektid() != null) {
                this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
            } else {
                this.objektVerknuepfungModel.clearList();
            }
        }
    }

    public void clearForm() {
        this.getBetreiberFeld().setText("");
        this.getBetreiberFeld().setToolTipText(null);
        this.getStandortFeld().setText("");
        this.getStandortFeld().setToolTipText(null);
        if (this.getArtBox().getItemCount() > 0) {
            this.getArtBox().setSelectedIndex(0);
        }
        this.getInaktivBox().setSelected(false);
        this.getBeschreibungsArea().setText(null);
    }

    public void enableAll(boolean enabled) {
        this.getSaveButton().setEnabled(enabled);
        this.getBetreiberToolBar().setEnabled(enabled);
        this.getStandortToolBar().setEnabled(enabled);
        this.getArtBox().setEnabled(enabled);
        this.getInaktivBox().setEnabled(enabled);
        this.getBeschreibungsArea().setEnabled(enabled);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private boolean saveObjektDaten() {
        boolean success;
        this.hauptModul.getObjekt().setBasisObjektarten((BasisObjektarten)this.getArtBox().getSelectedItem());
        this.hauptModul.getObjekt().setBeschreibung(this.getBeschreibungsArea().getText());
        this.hauptModul.getObjekt().setInaktiv(this.getInaktivBox().isSelected());
        BasisObjekt tmp = BasisObjekt.saveBasisObjekt(this.hauptModul.getObjekt());
        if (tmp != null) {
            this.hauptModul.setObjekt(tmp);
            this.hauptModul.completeObjekt();
            success = true;
            AUIKataster.debugOutput("Objekt " + this.hauptModul.getObjekt() + " gespeichert.", "BasisObjektBearbeiten.saveObjektDaten");
        } else {
            success = false;
            AUIKataster.debugOutput("Objekt " + this.hauptModul.getObjekt() + " konnte nicht gespeichert werden!", "BasisObjektBearbeiten.saveObjektDaten");
        }
        return success;
    }

    private ActionListener getEditButtonListener() {
        if (this.editButtonListener == null) {
            this.editButtonListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String action = e.getActionCommand();
                    BasisBetreiber betreiber = BasisPanel.this.hauptModul.getObjekt().getBasisBetreiber();
                    BasisStandort standort = BasisPanel.this.hauptModul.getObjekt().getBasisStandort();
                    if ("betreiber_edit".equals(action) && betreiber != null) {
                        BetreiberEditor editDialog = new BetreiberEditor(betreiber, BasisPanel.this.hauptModul.getFrame());
                        editDialog.setLocationRelativeTo(BasisPanel.this.hauptModul.getFrame());
                        editDialog.setVisible(true);
                        BasisPanel.this.hauptModul.getObjekt().setBasisBetreiber(editDialog.getBetreiber());
                    } else if ("standort_edit".equals(action) && standort != null) {
                        StandortEditor editDialog = new StandortEditor(standort, BasisPanel.this.hauptModul.getFrame());
                        editDialog.setLocationRelativeTo(BasisPanel.this.hauptModul.getFrame());
                        editDialog.setVisible(true);
                        BasisPanel.this.hauptModul.getObjekt().setBasisStandort(editDialog.getStandort());
                    }
                    BasisPanel.this.updateForm();
                }
            };
        }
        return this.editButtonListener;
    }

    private ActionListener getGotoButtonListener() {
        if (this.gotoButtonListener == null) {
            this.gotoButtonListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String action = e.getActionCommand();
                    BasisBetreiber betreiber = BasisPanel.this.hauptModul.getObjekt().getBasisBetreiber();
                    BasisStandort standort = BasisPanel.this.hauptModul.getObjekt().getBasisStandort();
                    if ("betreiber_goto".equals(action) && betreiber != null) {
                        BasisPanel.this.hauptModul.getManager().switchModul("m_betreiber_suchen");
                    } else if ("standort_goto".equals(action) && standort != null) {
                        BasisPanel.this.hauptModul.getManager().switchModul("m_standort_suchen");
                    }
                    BasisPanel.this.updateForm();
                }
            };
        }
        return this.gotoButtonListener;
    }

    public JTextField getBetreiberFeld() {
        if (this.betreiberFeld == null) {
            this.betreiberFeld = new JTextField("");
            this.betreiberFeld.setEditable(false);
        }
        return this.betreiberFeld;
    }

    private JToolBar getBetreiberToolBar() {
        if (this.betreiberToolBar == null) {
            this.betreiberToolBar = new JToolBar();
            this.betreiberToolBar.setFloatable(false);
            this.betreiberToolBar.setRollover(true);
            this.betreiberToolBar.add(this.getBetreiberChooseButton());
            this.betreiberToolBar.add(this.getBetreiberNewButton());
            this.betreiberToolBar.add(this.getBetreiberEditButton());
            this.betreiberToolBar.add(this.getBetreiberGotoButton());
        }
        return this.betreiberToolBar;
    }

    private JButton getBetreiberChooseButton() {
        if (this.betreiberChooseButton == null) {
            this.betreiberChooseButton = new JButton(AuikUtils.getIcon(16, "reload.png", ""));
            this.betreiberChooseButton.setHorizontalAlignment(0);
            this.betreiberChooseButton.setToolTipText("Betreiber ausw\u00e4hlen");
            this.betreiberChooseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasisBetreiber betreiber = BasisPanel.this.hauptModul.getObjekt().getBasisBetreiber();
                    if (betreiber == null) {
                        betreiber = new BasisBetreiber();
                    }
                    ChooseDialog chooser = new ChooseDialog(betreiber, BasisPanel.this.hauptModul.getFrame());
                    chooser.setVisible(true);
                    BasisPanel.this.hauptModul.getObjekt().setBasisBetreiber(chooser.getChosenBetreiber());
                    BasisPanel.this.updateForm();
                }
            });
        }
        return this.betreiberChooseButton;
    }

    private JButton getBetreiberEditButton() {
        if (this.betreiberEditButton == null) {
            this.betreiberEditButton = new JButton(AuikUtils.getIcon(16, "edit.png", ""));
            this.betreiberEditButton.setHorizontalAlignment(0);
            this.betreiberEditButton.setToolTipText("Betreiber bearbeiten");
            this.betreiberEditButton.setActionCommand("betreiber_edit");
            this.betreiberEditButton.addActionListener(this.getEditButtonListener());
        }
        return this.betreiberEditButton;
    }

    private JButton getBetreiberGotoButton() {
        if (this.betreiberGotoButton == null) {
            this.betreiberGotoButton = new JButton(AuikUtils.getIcon(16, "edit.png", ""));
            this.betreiberGotoButton.setHorizontalAlignment(0);
            this.betreiberGotoButton.setToolTipText("Betreibersuche aufrufen");
            this.betreiberGotoButton.setActionCommand("betreiber_goto");
            this.betreiberGotoButton.addActionListener(this.getGotoButtonListener());
        }
        return this.betreiberGotoButton;
    }

    private JButton getBetreiberNewButton() {
        if (this.betreiberNewButton == null) {
            this.betreiberNewButton = new JButton(AuikUtils.getIcon(16, "filenew.png", ""));
            this.betreiberNewButton.setHorizontalAlignment(0);
            this.betreiberNewButton.setToolTipText("Neuen Betreiber anlegen");
            this.betreiberNewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasisPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.return_to_objekt", true, false);
                    if (BasisPanel.this.hauptModul.getObjekt().getBasisBetreiber() != null) {
                        BasisPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.use_betreiber", BasisPanel.this.hauptModul.getObjekt().getBasisBetreiber().getBetreiberid(), false);
                    }
                    if (BasisPanel.this.hauptModul.getObjekt().getBasisStandort() != null) {
                        BasisPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.use_standort", BasisPanel.this.hauptModul.getObjekt().getBasisStandort().getStandortid(), false);
                    }
                    BasisPanel.this.hauptModul.getManager().switchModul("m_betreiber_neu");
                }
            });
        }
        return this.betreiberNewButton;
    }

    public JTextField getStandortFeld() {
        if (this.standortFeld == null) {
            this.standortFeld = new JTextField("");
            this.standortFeld.setEditable(false);
        }
        return this.standortFeld;
    }

    private JToolBar getStandortToolBar() {
        if (this.standortToolBar == null) {
            this.standortToolBar = new JToolBar();
            this.standortToolBar.setFloatable(false);
            this.standortToolBar.setRollover(true);
            this.standortToolBar.add(this.getStandortChooseButton());
            this.standortToolBar.add(this.getStandortNewButton());
            this.standortToolBar.add(this.getStandortEditButton());
            this.standortToolBar.add(this.getStandortGotoButton());
        }
        return this.standortToolBar;
    }

    private JButton getStandortChooseButton() {
        if (this.standortChooseButton == null) {
            this.standortChooseButton = new JButton(AuikUtils.getIcon(16, "reload.png", ""));
            this.standortChooseButton.setHorizontalAlignment(0);
            this.standortChooseButton.setToolTipText("Standort ausw\u00e4hlen");
            this.standortChooseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasisStandort standort = BasisPanel.this.hauptModul.getObjekt().getBasisStandort();
                    if (standort == null) {
                        standort = new BasisStandort();
                    }
                    ChooseDialog chooser = new ChooseDialog(standort, BasisPanel.this.hauptModul.getFrame());
                    chooser.setVisible(true);
                    BasisPanel.this.hauptModul.getObjekt().setBasisStandort(chooser.getChosenStandort());
                    BasisPanel.this.updateForm();
                }
            });
        }
        return this.standortChooseButton;
    }

    private JButton getStandortEditButton() {
        if (this.standortEditButton == null) {
            this.standortEditButton = new JButton(AuikUtils.getIcon(16, "edit.png", ""));
            this.standortEditButton.setHorizontalAlignment(0);
            this.standortEditButton.setToolTipText("Standort bearbeiten");
            this.standortEditButton.setActionCommand("standort_edit");
            this.standortEditButton.addActionListener(this.getEditButtonListener());
        }
        return this.standortEditButton;
    }

    private JButton getStandortGotoButton() {
        if (this.standortGotoButton == null) {
            this.standortGotoButton = new JButton(AuikUtils.getIcon(16, "edit.png", ""));
            this.standortGotoButton.setHorizontalAlignment(0);
            this.standortGotoButton.setToolTipText("Standortsuche aufrufen");
            this.standortGotoButton.setActionCommand("standort_goto");
            this.standortGotoButton.addActionListener(this.getGotoButtonListener());
        }
        return this.standortGotoButton;
    }

    private JButton getStandortNewButton() {
        if (this.standortNewButton == null) {
            this.standortNewButton = new JButton(AuikUtils.getIcon(16, "filenew.png", ""));
            this.standortNewButton.setHorizontalAlignment(0);
            this.standortNewButton.setToolTipText("Neuen Standort anlegen");
            this.standortNewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasisPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.return_to_objekt", true, false);
                    if (BasisPanel.this.hauptModul.getObjekt().getBasisBetreiber() != null) {
                        BasisPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.use_betreiber", BasisPanel.this.hauptModul.getObjekt().getBasisBetreiber().getBetreiberid(), false);
                    }
                    if (BasisPanel.this.hauptModul.getObjekt().getBasisStandort() != null) {
                        BasisPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.use_standort", BasisPanel.this.hauptModul.getObjekt().getBasisStandort().getStandortid(), false);
                    }
                    BasisPanel.this.hauptModul.getManager().switchModul("m_standort_neu");
                }
            });
        }
        return this.standortNewButton;
    }

    private JComboBox getArtBox() {
        if (this.artBox == null) {
            this.artBox = new JComboBox();
            this.artBox.setKeySelectionManager(new MyKeySelectionManager());
        }
        return this.artBox;
    }

    private JCheckBox getInaktivBox() {
        if (this.inaktivBox == null) {
            this.inaktivBox = new JCheckBox();
        }
        return this.inaktivBox;
    }

    public JTextArea getBeschreibungsArea() {
        if (this.beschreibungsArea == null) {
            this.beschreibungsArea = new LimitedTextArea(150);
            this.beschreibungsArea.setLineWrap(true);
            this.beschreibungsArea.setWrapStyleWord(true);
        }
        return this.beschreibungsArea;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton("Objekt speichern");
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BasisPanel.this.hauptModul.getObjekt().getBasisBetreiber() != null && BasisPanel.this.hauptModul.getObjekt().getBasisStandort() != null) {
                        BasisPanel.this.enableAll(false);
                        if (BasisPanel.this.saveObjektDaten()) {
                            BasisPanel.this.hauptModul.getFrame().changeStatus("Objekt " + BasisPanel.this.hauptModul.getObjekt().getObjektid() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                            BasisPanel.this.hauptModul.setNew(false);
                        } else {
                            BasisPanel.this.hauptModul.getFrame().changeStatus("Konnte Objekt nicht speichern!", HauptFrame.ERROR_COLOR);
                        }
                        BasisPanel.this.hauptModul.fillForm();
                    } else {
                        BasisPanel.this.hauptModul.getFrame().changeStatus("Kein Betreiber/Standort ausgew\u00e4hlt!", HauptFrame.ERROR_COLOR);
                    }
                }
            });
        }
        return this.saveButton;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = BasisPanel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = BasisPanel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != BasisPanel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                BasisPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                BasisPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            BasisPanel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    BasisPanel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    BasisPanel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = BasisPanel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && BasisPanel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = BasisPanel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(BasisPanel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (BasisPanel.this.objektVerknuepfungModel.removeRow(row)) {
                                BasisPanel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                BasisPanel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(BasisPanel.this.hauptModul.getFrame(), BasisPanel.this.hauptModul.getObjekt(), BasisPanel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }

    private class ChooseDialog
    extends JDialog {
        private HauptFrame frame;
        private BasisBetreiber betreiber;
        private BasisStandort standort;
        private BasisBetreiberModel betreiberModel;
        private BasisStandortModel standortModel;
        private JTextField suchFeld;
        private JButton submitButton;
        private JTable ergebnisTabelle;
        private JButton okButton;
        private JButton abbrechenButton;

        public ChooseDialog(Object initial, HauptFrame frame) {
            super((Frame)frame, true);
            this.frame = frame;
            ArrayList<Object> initialList = new ArrayList<Object>();
            initialList.add(initial);
            if (initial instanceof BasisBetreiber) {
                this.setTitle("Betreiber ausw\u00e4hlen");
                this.betreiber = (BasisBetreiber)initial;
                this.betreiberModel = new BasisBetreiberModel(false);
                if (this.betreiber.getBetreiberid() != null) {
                    this.betreiberModel.setList(initialList);
                }
            } else if (initial instanceof BasisStandort) {
                this.setTitle("Standort ausw\u00e4hlen");
                this.standort = (BasisStandort)initial;
                this.standortModel = new BasisStandortModel();
                if (this.standort.getStandortid() != null) {
                    this.standortModel.setList(initialList);
                }
            } else {
                throw new IllegalArgumentException("intial muss ein BasisBetreiber oder BasisStandort sein!");
            }
            this.setContentPane(this.initializeContentPane());
            this.pack();
            this.setResizable(false);
            this.setLocationRelativeTo(frame);
            this.setDefaultCloseOperation(2);
        }

        public BasisBetreiber getChosenBetreiber() {
            if (this.betreiber.getBetreiberid() != null) {
                return this.betreiber;
            }
            return null;
        }

        public BasisStandort getChosenStandort() {
            if (this.standort.getStandortid() != null) {
                return this.standort;
            }
            return null;
        }

        private JPanel initializeContentPane() {
            JScrollPane tabellenScroller = new JScrollPane(this.getErgebnisTabelle(), 20, 31);
            TabAction ta = new TabAction();
            ta.addComp(this.getErgebnisTabelle());
            ta.addComp(this.getOkButton());
            ta.addComp(this.getAbbrechenButton());
            JPanel buttonBar = ButtonBarFactory.buildOKCancelBar((JButton)this.getOkButton(), (JButton)this.getAbbrechenButton());
            JToolBar submitToolBar = new JToolBar();
            submitToolBar.setFloatable(false);
            submitToolBar.setRollover(true);
            submitToolBar.add(this.getSubmitButton());
            FormLayout layout = new FormLayout("180dlu, 3dlu, min(16dlu;p)", "pref, 3dlu, 100dlu, 3dlu, pref");
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)this.getSuchFeld(), cc.xy(1, 1));
            builder.add((Component)submitToolBar, cc.xy(3, 1));
            builder.add((Component)tabellenScroller, cc.xyw(1, 3, 3));
            builder.add((Component)buttonBar, cc.xyw(1, 5, 3));
            return builder.getPanel();
        }

        private void choose(int row) {
            if (row != -1) {
                if (this.betreiber != null) {
                    this.betreiber = this.betreiberModel.getRow(row);
                } else if (this.standort != null) {
                    this.standort = this.standortModel.getRow(row);
                }
                this.dispose();
            }
        }

        private void doSearch() {
            final String suche = this.getSuchFeld().getText();
            if (this.betreiber != null) {
                SwingWorkerVariant worker = new SwingWorkerVariant(this.getErgebnisTabelle()){

                    @Override
                    protected void doNonUILogic() throws RuntimeException {
                        ChooseDialog.this.betreiberModel.filterList(suche, null);
                    }

                    @Override
                    protected void doUIUpdateLogic() throws RuntimeException {
                        ChooseDialog.this.betreiberModel.fireTableDataChanged();
                    }
                };
                worker.start();
            } else if (this.standort != null) {
                SwingWorkerVariant worker = new SwingWorkerVariant(this.getErgebnisTabelle()){

                    @Override
                    protected void doNonUILogic() throws RuntimeException {
                        String first;
                        int nr;
                        String[] test = suche.split(" ");
                        String last = test[test.length - 1];
                        try {
                            nr = Integer.parseInt(last);
                            first = suche.replaceAll(last, "");
                        }
                        catch (NumberFormatException e) {
                            first = suche;
                            nr = -1;
                        }
                        ChooseDialog.this.standortModel.filterList(first, nr);
                    }

                    @Override
                    protected void doUIUpdateLogic() throws RuntimeException {
                        ChooseDialog.this.standortModel.fireTableDataChanged();
                    }
                };
                worker.start();
            }
        }

        private JTextField getSuchFeld() {
            if (this.suchFeld == null) {
                this.suchFeld = new JTextField();
                this.suchFeld.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChooseDialog.this.doSearch();
                    }
                });
            }
            return this.suchFeld;
        }

        private JButton getSubmitButton() {
            if (this.submitButton == null) {
                this.submitButton = new JButton(AuikUtils.getIcon(16, "key_enter.png"));
                this.submitButton.setToolTipText("Suche starten");
                this.submitButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChooseDialog.this.doSearch();
                    }
                });
            }
            return this.submitButton;
        }

        private JTable getErgebnisTabelle() {
            if (this.ergebnisTabelle == null) {
                if (this.betreiber != null) {
                    this.ergebnisTabelle = new JTable(this.betreiberModel);
                } else if (this.standort != null) {
                    this.ergebnisTabelle = new JTable(this.standortModel);
                }
                this.ergebnisTabelle.addFocusListener(TableFocusListener.getInstance());
                this.ergebnisTabelle.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2 && e.getButton() == 1) {
                            Point origin = e.getPoint();
                            int row = ChooseDialog.this.ergebnisTabelle.rowAtPoint(origin);
                            ChooseDialog.this.choose(row);
                        }
                    }
                });
                this.ergebnisTabelle.getColumnModel().getColumn(0).setPreferredWidth(130);
            }
            return this.ergebnisTabelle;
        }

        private JButton getOkButton() {
            if (this.okButton == null) {
                this.okButton = new JButton("Ok");
                this.okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int row = ChooseDialog.this.getErgebnisTabelle().getSelectedRow();
                        ChooseDialog.this.choose(row);
                    }
                });
            }
            return this.okButton;
        }

        private JButton getAbbrechenButton() {
            if (this.abbrechenButton == null) {
                this.abbrechenButton = new JButton("Abbrechen");
                this.abbrechenButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChooseDialog.this.dispose();
                    }
                });
            }
            return this.abbrechenButton;
        }
    }
}

