/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AnhBwkFachdaten;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class BWKPanel
extends JPanel {
    private String name = "Brennwertkessel";
    private BasisObjektBearbeiten hauptModul;
    private JTextField herstellerFeld = null;
    private JTextField typFeld = null;
    private JTextField brennmittelFeld = null;
    private JFormattedTextField leistungFeld = null;
    private JTextField brennerFeld = null;
    private JTextField waermetauscherFeld = null;
    private JTextField abgasleitungFeld = null;
    private JTextField kondensatltgFeld = null;
    private JFormattedTextField jahrgangFeld = null;
    private JTextField abnahmeFeld = null;
    private TextFieldDateChooser anschreibenFeld = null;
    private TextFieldDateChooser genehmigungDatum = null;
    private JCheckBox abaCheck = null;
    private JCheckBox genehmpflichtCheck = null;
    private JTextArea bwkBeschreibungsArea = null;
    private JButton saveBwkButton = null;
    private AnhBwkFachdaten bwk = null;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;

    public BWKPanel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:50dlu, 5dlu, 90dlu, 10dlu, r:50dlu, 5dlu, 70dlu, , 70dlu, 70dlu", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:100dlu, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Kessel", cc.xyw(1, 1, 3));
        builder.addLabel("Hersteller:", cc.xy(1, 3));
        builder.add((Component)this.getHerstellerFeld(), cc.xy(3, 3));
        builder.addLabel("Typ:", cc.xy(1, 5));
        builder.add((Component)this.getTypFeld(), cc.xy(3, 5));
        builder.addLabel("Brennmittel:", cc.xy(1, 7));
        builder.add((Component)this.getBrennmittelFeld(), cc.xy(3, 7));
        builder.addLabel("Leistung:", cc.xy(1, 9));
        builder.add((Component)this.getLeistungFeld(), cc.xy(3, 9));
        builder.addSeparator("Werkstoffe", cc.xyw(1, 11, 3));
        builder.addLabel("Brenner:", cc.xy(1, 13));
        builder.add((Component)this.getBrennerFeld(), cc.xy(3, 13));
        builder.addLabel("Tauscher:", cc.xy(1, 15));
        builder.add((Component)this.getWaermetauscherFeld(), cc.xy(3, 15));
        builder.addLabel("Abgasleitung:", cc.xy(1, 17));
        builder.add((Component)this.getAbgasleitungFeld(), cc.xy(3, 17));
        builder.addLabel("Kondensatabl.:", cc.xy(1, 19));
        builder.add((Component)this.getKondensatltgFeld(), cc.xy(3, 19));
        builder.addSeparator("Erfassung", cc.xyw(5, 1, 3));
        builder.addLabel("Jahrgang:", cc.xy(5, 3));
        builder.add((Component)this.getJahrgangFeld(), cc.xy(7, 3));
        builder.addLabel("Abnahme:", cc.xy(5, 5));
        builder.add((Component)this.getAbnahmeFeld(), cc.xy(7, 5));
        builder.addLabel("Anschreiben:", cc.xy(5, 7));
        builder.add((Component)this.getAnschreibenFeld(), cc.xy(7, 7));
        builder.addLabel("Genehmigung:", cc.xy(5, 9));
        builder.add((Component)this.getGenehmigungDatum(), cc.xy(7, 9));
        builder.add((Component)this.getgenehmpflichtCheck(), cc.xyw(5, 11, 3));
        builder.add((Component)this.getAbaCheck(), cc.xy(8, 11));
        builder.addSeparator("Bemerkungen", cc.xyw(5, 13, 3));
        builder.add((Component)new JScrollPane(this.getBwkBeschreibungsArea(), 20, 31), cc.xywh(5, 15, 3, 5));
        builder.addSeparator("Verkn\u00fcpfte Objekte", cc.xyw(1, 21, 7));
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.appendRow("fill:100dlu");
        builder.add((Component)objektverknuepfungScroller, cc.xyw(1, 23, 7));
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton(), (JButton)this.getSaveBwkButton());
        builder.add((Component)buttonBar, cc.xyw(1, 25, 7));
    }

    public void fetchFormData() throws RuntimeException {
        this.bwk = AnhBwkFachdaten.getAnhBwkByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("Brennwertkessel aus DB geholt: " + this.bwk, "BWKPanel.fetchFormData");
    }

    public void updateForm() throws RuntimeException {
        if (this.bwk != null) {
            if (this.bwk.getKHersteller() != null) {
                this.getHerstellerFeld().setText(this.bwk.getKHersteller());
            }
            if (this.bwk.getKTyp() != null) {
                this.getTypFeld().setText(this.bwk.getKTyp());
            }
            if (this.bwk.getKBrennmittel() != null) {
                this.getBrennmittelFeld().setText(this.bwk.getKBrennmittel());
            }
            if (this.bwk.getKLeistung() != null) {
                this.getLeistungFeld().setText(this.bwk.getKLeistung().toString());
            }
            if (this.bwk.getWBrenner() != null) {
                this.getBrennerFeld().setText(this.bwk.getWBrenner());
            }
            if (this.bwk.getWWaermetauscher() != null) {
                this.getWaermetauscherFeld().setText(this.bwk.getWWaermetauscher());
            }
            if (this.bwk.getWAbgasleitung() != null) {
                this.getAbgasleitungFeld().setText(this.bwk.getWAbgasleitung());
            }
            if (this.bwk.getWKondensableitung() != null) {
                this.getKondensatltgFeld().setText(this.bwk.getWKondensableitung());
            }
            if (this.bwk.getErfassung() != null) {
                this.getJahrgangFeld().setText(this.bwk.getErfassung().toString());
            }
            if (this.bwk.getBemerkungen() != null) {
                this.getBwkBeschreibungsArea().setText(this.bwk.getBemerkungen());
            }
            if (this.bwk.getAbnahme() != null) {
                this.getAbnahmeFeld().setText(this.bwk.getAbnahme());
            }
            if (this.bwk.getAnschreiben() != null) {
                this.getAnschreibenFeld().setDate(this.bwk.getAnschreiben());
            }
            if (this.bwk.getDatumG() != null) {
                this.getGenehmigungDatum().setDate(this.bwk.getDatumG());
            }
            if (this.bwk.getAba() != null) {
                if (this.bwk.getAba().booleanValue()) {
                    this.getAbaCheck().setSelected(true);
                } else {
                    this.getAbaCheck().setSelected(false);
                }
            }
            if (this.bwk.getGenehmigungspflicht() != null) {
                if (this.bwk.getGenehmigungspflicht().booleanValue()) {
                    this.getgenehmpflichtCheck().setSelected(true);
                } else {
                    this.getgenehmpflichtCheck().setSelected(false);
                }
            }
            this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
        }
    }

    public void clearForm() {
        this.getHerstellerFeld().setText(null);
        this.getTypFeld().setText(null);
        this.getBrennmittelFeld().setText(null);
        this.getLeistungFeld().setText(null);
        this.getBrennerFeld().setText(null);
        this.getWaermetauscherFeld().setText(null);
        this.getAbgasleitungFeld().setText(null);
        this.getKondensatltgFeld().setText(null);
        this.getJahrgangFeld().setText(null);
        this.getBwkBeschreibungsArea().setText(null);
        this.getAbnahmeFeld().setText(null);
        this.getAnschreibenFeld().setDate(null);
        this.getGenehmigungDatum().setDate(null);
        this.getAbaCheck().setSelected(false);
        this.getgenehmpflichtCheck().setSelected(false);
    }

    public void enableAll(boolean enabled) {
        this.getAbaCheck().setEnabled(enabled);
        this.getgenehmpflichtCheck().setEnabled(enabled);
        this.getAbgasleitungFeld().setEnabled(enabled);
        this.getAbnahmeFeld().setEnabled(enabled);
        this.getAnschreibenFeld().setEnabled(enabled);
        this.getBrennerFeld().setEnabled(enabled);
        this.getBrennmittelFeld().setEnabled(enabled);
        this.getBwkBeschreibungsArea().setEnabled(enabled);
        this.getGenehmigungDatum().setEnabled(enabled);
        this.getHerstellerFeld().setEnabled(enabled);
        this.getJahrgangFeld().setEnabled(enabled);
        this.getKondensatltgFeld().setEnabled(enabled);
        this.getLeistungFeld().setEnabled(enabled);
        this.getTypFeld().setEnabled(enabled);
        this.getWaermetauscherFeld().setEnabled(enabled);
        this.getSaveBwkButton().setEnabled(enabled);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private boolean saveBwkDaten() {
        String hersteller = this.herstellerFeld.getText();
        if ("".equals(hersteller)) {
            this.bwk.setKHersteller(null);
        } else {
            this.bwk.setKHersteller(hersteller);
        }
        String typ = this.typFeld.getText();
        if ("".equals(typ)) {
            this.bwk.setKTyp(null);
        } else {
            this.bwk.setKTyp(typ);
        }
        String brennmittel = this.brennmittelFeld.getText();
        if ("".equals(brennmittel)) {
            this.bwk.setKBrennmittel(null);
        } else {
            this.bwk.setKBrennmittel(brennmittel);
        }
        Integer leistung = ((IntegerField)this.leistungFeld).getIntValue();
        this.bwk.setKLeistung(leistung);
        String brenner = this.brennerFeld.getText();
        if ("".equals(brenner)) {
            this.bwk.setWBrenner(null);
        } else {
            this.bwk.setWBrenner(brenner);
        }
        String tauscher = this.waermetauscherFeld.getText();
        if ("".equals(tauscher)) {
            this.bwk.setWWaermetauscher(null);
        } else {
            this.bwk.setWWaermetauscher(tauscher);
        }
        String abgasleitung = this.abgasleitungFeld.getText();
        if ("".equals(abgasleitung)) {
            this.bwk.setWAbgasleitung(null);
        } else {
            this.bwk.setWAbgasleitung(abgasleitung);
        }
        String kondensatabl = this.kondensatltgFeld.getText();
        if ("".equals(kondensatabl)) {
            this.bwk.setWKondensableitung(null);
        } else {
            this.bwk.setWKondensableitung(kondensatabl);
        }
        Integer jahrgang = ((IntegerField)this.jahrgangFeld).getIntValue();
        this.bwk.setErfassung(jahrgang);
        String abnahme = this.abnahmeFeld.getText();
        if ("".equals(abnahme)) {
            this.bwk.setAbnahme(null);
        } else {
            this.bwk.setAbnahme(abnahme);
        }
        Date anschreiben = this.anschreibenFeld.getDate();
        if ("".equals(anschreiben)) {
            this.bwk.setAnschreiben(null);
        } else {
            this.bwk.setAnschreiben(anschreiben);
        }
        Date genehmigung = this.genehmigungDatum.getDate();
        this.bwk.setDatumG(genehmigung);
        Boolean aba = this.getAbaCheck().isSelected() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.bwk.setAba(new Boolean(aba));
        Boolean genehmpflicht = this.getgenehmpflichtCheck().isSelected() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.bwk.setGenehmigungspflicht(new Boolean(genehmpflicht));
        String beschreibung = this.bwkBeschreibungsArea.getText();
        if ("".equals(beschreibung)) {
            this.bwk.setBemerkungen(null);
        } else {
            this.bwk.setBemerkungen(beschreibung);
        }
        boolean success = AnhBwkFachdaten.saveBwk(this.bwk);
        if (success) {
            AUIKataster.debugOutput("Brennwertkessel " + this.bwk + " gespeichert.", "BWKPanel.saveBwkDaten");
        } else {
            AUIKataster.debugOutput("Brennwertkessel " + this.bwk + " konnte nicht gespeichert werden!", "BWKPanel.saveBwkDaten");
        }
        return success;
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.bwk == null) {
            this.bwk = new AnhBwkFachdaten();
            this.bwk.setBasisObjekt(this.hauptModul.getObjekt());
            if (AnhBwkFachdaten.saveBwk(this.bwk)) {
                AUIKataster.debugOutput("Neuer Brennwertkessel " + this.bwk + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
            }
        }
    }

    private JCheckBox getAbaCheck() {
        if (this.abaCheck == null) {
            this.abaCheck = new JCheckBox("ABA");
        }
        return this.abaCheck;
    }

    private JCheckBox getgenehmpflichtCheck() {
        if (this.genehmpflichtCheck == null) {
            this.genehmpflichtCheck = new JCheckBox("Genehmigungspflicht");
        }
        return this.genehmpflichtCheck;
    }

    private JTextField getAbgasleitungFeld() {
        if (this.abgasleitungFeld == null) {
            this.abgasleitungFeld = new LimitedTextField(50);
        }
        return this.abgasleitungFeld;
    }

    private JTextField getAbnahmeFeld() {
        if (this.abnahmeFeld == null) {
            this.abnahmeFeld = new LimitedTextField(50);
        }
        return this.abnahmeFeld;
    }

    private TextFieldDateChooser getAnschreibenFeld() {
        if (this.anschreibenFeld == null) {
            this.anschreibenFeld = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.anschreibenFeld;
    }

    private JTextField getBrennerFeld() {
        if (this.brennerFeld == null) {
            this.brennerFeld = new LimitedTextField(50);
        }
        return this.brennerFeld;
    }

    private JTextField getBrennmittelFeld() {
        if (this.brennmittelFeld == null) {
            this.brennmittelFeld = new LimitedTextField(50);
        }
        return this.brennmittelFeld;
    }

    private JTextArea getBwkBeschreibungsArea() {
        if (this.bwkBeschreibungsArea == null) {
            this.bwkBeschreibungsArea = new LimitedTextArea(150);
            this.bwkBeschreibungsArea.setLineWrap(true);
            this.bwkBeschreibungsArea.setWrapStyleWord(true);
        }
        return this.bwkBeschreibungsArea;
    }

    private TextFieldDateChooser getGenehmigungDatum() {
        if (this.genehmigungDatum == null) {
            this.genehmigungDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.genehmigungDatum;
    }

    private JTextField getHerstellerFeld() {
        if (this.herstellerFeld == null) {
            this.herstellerFeld = new LimitedTextField(50);
        }
        return this.herstellerFeld;
    }

    private JTextField getJahrgangFeld() {
        if (this.jahrgangFeld == null) {
            this.jahrgangFeld = new IntegerField();
        }
        return this.jahrgangFeld;
    }

    private JTextField getKondensatltgFeld() {
        if (this.kondensatltgFeld == null) {
            this.kondensatltgFeld = new LimitedTextField(50);
        }
        return this.kondensatltgFeld;
    }

    private JTextField getLeistungFeld() {
        if (this.leistungFeld == null) {
            this.leistungFeld = new IntegerField();
        }
        return this.leistungFeld;
    }

    private JTextField getTypFeld() {
        if (this.typFeld == null) {
            this.typFeld = new LimitedTextField(50);
        }
        return this.typFeld;
    }

    private JTextField getWaermetauscherFeld() {
        if (this.waermetauscherFeld == null) {
            this.waermetauscherFeld = new LimitedTextField(50);
        }
        return this.waermetauscherFeld;
    }

    private JButton getSaveBwkButton() {
        if (this.saveBwkButton == null) {
            this.saveBwkButton = new JButton("Speichern");
            this.saveBwkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BWKPanel.this.enableAll(false);
                    if (BWKPanel.this.saveBwkDaten()) {
                        BWKPanel.this.hauptModul.getFrame().changeStatus("Brennwertkessel " + BWKPanel.this.bwk.getBwkId() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        BWKPanel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern des Brennwertkessels!", HauptFrame.ERROR_COLOR);
                    }
                    BWKPanel.this.hauptModul.fillForm();
                }
            });
        }
        return this.saveBwkButton;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = BWKPanel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = BWKPanel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != BWKPanel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                BWKPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                BWKPanel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            BWKPanel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    BWKPanel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    BWKPanel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = BWKPanel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && BWKPanel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = BWKPanel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(BWKPanel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (BWKPanel.this.objektVerknuepfungModel.removeRow(row)) {
                                BWKPanel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                BWKPanel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(BWKPanel.this.hauptModul.getFrame(), BWKPanel.this.bwk.getBasisObjekt(), BWKPanel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }
}

