/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh56Fachdaten;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Anh56Panel
extends JPanel {
    private String name = "Druckerei";
    private BasisObjektBearbeiten hauptModul;
    private JTextField druckverfahrenFeld = null;
    private JTextField verbrauchFeld = null;
    private JTextField entsorgungFeld = null;
    private TextFieldDateChooser gen59Datum = null;
    private TextFieldDateChooser gen58Datum = null;
    private JCheckBox abaCheck = null;
    private JCheckBox genpflichtCheck = null;
    private JCheckBox abwasseranfallCheck = null;
    private JTextArea BemerkungenArea = null;
    private JButton saveAnh56Button = null;
    private Anh56Fachdaten fachdaten = null;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;
    private ActionListener editButtonListener;

    public Anh56Panel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:90dlu, 5dlu, 95dlu, 5dlu, r:0dlu, 0dlu, 90dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Fachdaten");
        builder.append("Druckverfahren:", (Component)this.getDruckverfahrenFeld());
        builder.append("", (Component)this.getAbwasseranfallCheck());
        builder.nextLine();
        builder.append("Wasserverbrauch:", (Component)this.getVerbrauchFeld());
        builder.append("", (Component)this.getAbaCheck());
        builder.nextLine();
        builder.append("Entsorgung:", (Component)this.getEntsorgungFeld());
        builder.append("", (Component)this.getGenpflichtCheck());
        builder.nextLine();
        builder.append("Datum 58er Genehmigung:", (Component)this.getGen58Datum());
        builder.nextLine();
        builder.append("Datum 59er Genehmigung:", (Component)this.getGen59Datum());
        builder.nextLine();
        builder.appendSeparator("Bemerkungen");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane bemerkungsScroller = new JScrollPane(this.getBemerkungenArea(), 20, 31);
        builder.appendRow("fill:30dlu");
        builder.append((Component)bemerkungsScroller, 7);
        builder.appendSeparator("Verkn\u00fcpfte Objekte");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.appendRow("fill:100dlu");
        builder.append((Component)objektverknuepfungScroller, 7);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton(), (JButton)this.getSaveAnh56Button());
        builder.append((Component)buttonBar, 7);
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.fachdaten == null) {
            this.fachdaten = new Anh56Fachdaten();
            this.fachdaten.setBasisObjekt(this.hauptModul.getObjekt());
            Anh56Fachdaten.saveFachdaten(this.fachdaten);
            AUIKataster.debugOutput("Neues Anh 56 Objekt " + this.fachdaten + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
        }
    }

    private boolean saveAnh56Daten() {
        String bemerkungen = this.BemerkungenArea.getText();
        if ("".equals(bemerkungen)) {
            this.fachdaten.setBemerkungen(null);
        } else {
            this.fachdaten.setBemerkungen(bemerkungen);
        }
        String druckverf = this.druckverfahrenFeld.getText();
        if ("".equals(druckverf)) {
            this.fachdaten.setDruckverfahren(null);
        } else {
            this.fachdaten.setDruckverfahren(druckverf);
        }
        String verbrauch = this.verbrauchFeld.getText();
        if ("".equals(verbrauch)) {
            this.fachdaten.setVerbrauch(null);
        } else {
            this.fachdaten.setVerbrauch(verbrauch);
        }
        String entsorgung = this.entsorgungFeld.getText();
        if ("".equals(entsorgung)) {
            this.fachdaten.setEntsorgung(null);
        } else {
            this.fachdaten.setEntsorgung(entsorgung);
        }
        Date gen58 = this.gen58Datum.getDate();
        this.fachdaten.setGen58(gen58);
        Date gen59 = this.gen59Datum.getDate();
        this.fachdaten.setGen59(gen59);
        if (this.getAbaCheck().isSelected()) {
            this.fachdaten.setAba(true);
        } else {
            this.fachdaten.setAba(false);
        }
        if (this.getGenpflichtCheck().isSelected()) {
            this.fachdaten.setGenpflicht(true);
        } else {
            this.fachdaten.setGenpflicht(false);
        }
        if (this.getAbwasseranfallCheck().isSelected()) {
            this.fachdaten.setAbwasseranfall(true);
        } else {
            this.fachdaten.setAbwasseranfall(false);
        }
        boolean success = Anh56Fachdaten.saveFachdaten(this.fachdaten);
        if (success) {
            AUIKataster.debugOutput("Anh 56 Objekt " + this.fachdaten.getObjektid() + " gespeichert.", "Anh56Panel.saveFachdaten");
        } else {
            AUIKataster.debugOutput("Anh 56 Objekt " + this.fachdaten + " konnte nicht gespeichert werden!", "Anh56Panel.saveFachdaten");
        }
        return success;
    }

    public void enableAll(boolean enabled) {
        this.getBemerkungenArea().setEnabled(enabled);
        this.getDruckverfahrenFeld().setEnabled(enabled);
        this.getVerbrauchFeld().setEnabled(enabled);
        this.getEntsorgungFeld().setEnabled(enabled);
        this.getGen58Datum().setEnabled(enabled);
        this.getGen59Datum().setEnabled(enabled);
        this.getAbaCheck().setEnabled(enabled);
        this.getGenpflichtCheck().setEnabled(enabled);
        this.getAbwasseranfallCheck().setEnabled(enabled);
    }

    public void clearForm() {
        this.getBemerkungenArea().setText(null);
        this.getDruckverfahrenFeld().setText(null);
        this.getVerbrauchFeld().setText(null);
        this.getEntsorgungFeld().setText(null);
        this.getGen58Datum().setDate(null);
        this.getGen59Datum().setDate(null);
        this.getAbaCheck().setSelected(false);
        this.getGenpflichtCheck().setSelected(false);
        this.getAbwasseranfallCheck().setSelected(false);
    }

    public void updateForm() throws RuntimeException {
        if (this.fachdaten != null) {
            if (this.fachdaten.getBemerkungen() != null) {
                this.getBemerkungenArea().setText(this.fachdaten.getBemerkungen());
            }
            if (this.fachdaten.getDruckverfahren() != null) {
                this.getDruckverfahrenFeld().setText(this.fachdaten.getDruckverfahren());
            }
            if (this.fachdaten.getVerbrauch() != null) {
                this.getVerbrauchFeld().setText(this.fachdaten.getVerbrauch());
            }
            if (this.fachdaten.getEntsorgung() != null) {
                this.getEntsorgungFeld().setText(this.fachdaten.getEntsorgung());
            }
            if (this.fachdaten.getGen58() != null) {
                this.getGen58Datum().setDate(this.fachdaten.getGen58());
            }
            if (this.fachdaten.getGen59() != null) {
                this.getGen59Datum().setDate(this.fachdaten.getGen59());
            }
            if (this.fachdaten.getAba() != null) {
                if (this.fachdaten.getAba().booleanValue()) {
                    this.getAbaCheck().setSelected(true);
                } else {
                    this.getAbaCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getGenpflicht() != null) {
                if (this.fachdaten.getGenpflicht().booleanValue()) {
                    this.getGenpflichtCheck().setSelected(true);
                } else {
                    this.getGenpflichtCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getAbwasseranfall() != null) {
                if (this.fachdaten.getAbwasseranfall().booleanValue()) {
                    this.getAbwasseranfallCheck().setSelected(true);
                } else {
                    this.getAbwasseranfallCheck().setSelected(false);
                }
                this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
            }
        }
    }

    public void fetchFormData() throws RuntimeException {
        this.fachdaten = Anh56Fachdaten.getAnh56ByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("Anhang 56 Objekt aus DB geholt: ID" + this.fachdaten, "Anh56Panel.fetchFormData");
    }

    private JButton getSaveAnh56Button() {
        if (this.saveAnh56Button == null) {
            this.saveAnh56Button = new JButton("Speichern");
            this.saveAnh56Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Anh56Panel.this.enableAll(false);
                    if (Anh56Panel.this.saveAnh56Daten()) {
                        Anh56Panel.this.hauptModul.getFrame().changeStatus("Anh 56 Objekt " + Anh56Panel.this.fachdaten.getObjektid() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        Anh56Panel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern des Anh 56 Objekt!", HauptFrame.ERROR_COLOR);
                    }
                    Anh56Panel.this.hauptModul.fillForm();
                }
            });
        }
        return this.saveAnh56Button;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private JCheckBox getAbaCheck() {
        if (this.abaCheck == null) {
            this.abaCheck = new JCheckBox("Abwasserbehandlung");
        }
        return this.abaCheck;
    }

    private JCheckBox getAbwasseranfallCheck() {
        if (this.abwasseranfallCheck == null) {
            this.abwasseranfallCheck = new JCheckBox("Abwasseranfall");
        }
        return this.abwasseranfallCheck;
    }

    private JTextField getDruckverfahrenFeld() {
        if (this.druckverfahrenFeld == null) {
            this.druckverfahrenFeld = new LimitedTextField(150);
        }
        return this.druckverfahrenFeld;
    }

    private JTextField getEntsorgungFeld() {
        if (this.entsorgungFeld == null) {
            this.entsorgungFeld = new LimitedTextField(150);
        }
        return this.entsorgungFeld;
    }

    private TextFieldDateChooser getGen58Datum() {
        if (this.gen58Datum == null) {
            this.gen58Datum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.gen58Datum;
    }

    private TextFieldDateChooser getGen59Datum() {
        if (this.gen59Datum == null) {
            this.gen59Datum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.gen59Datum;
    }

    private JCheckBox getGenpflichtCheck() {
        if (this.genpflichtCheck == null) {
            this.genpflichtCheck = new JCheckBox("Genehmigungspflicht");
        }
        return this.genpflichtCheck;
    }

    private JTextField getVerbrauchFeld() {
        if (this.verbrauchFeld == null) {
            this.verbrauchFeld = new LimitedTextField(150);
        }
        return this.verbrauchFeld;
    }

    private JTextArea getBemerkungenArea() {
        if (this.BemerkungenArea == null) {
            this.BemerkungenArea = new LimitedTextArea(255);
            this.BemerkungenArea.setLineWrap(true);
            this.BemerkungenArea.setWrapStyleWord(true);
        }
        return this.BemerkungenArea;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = Anh56Panel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = Anh56Panel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != Anh56Panel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                Anh56Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                Anh56Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            Anh56Panel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Anh56Panel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Anh56Panel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = Anh56Panel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && Anh56Panel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = Anh56Panel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(Anh56Panel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (Anh56Panel.this.objektVerknuepfungModel.removeRow(row)) {
                                Anh56Panel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                Anh56Panel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(Anh56Panel.this.hauptModul.getFrame(), Anh56Panel.this.fachdaten.getBasisObjekt(), Anh56Panel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }
}

