/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh55Fachdaten;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.DoubleField;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Anh55Panel
extends JPanel {
    private String name = "W\u00e4scherei";
    private BasisObjektBearbeiten hauptModul;
    private JTextField sachbearbeiterFeld = null;
    private JTextField entgebIdFeld = null;
    private JTextField mengewaescheFeld = null;
    private JTextField sonsttexFeld = null;
    private DoubleField monatwasserverbFeld = null;
    private JTextArea waschsituationArea = null;
    private JTextField ansprechpartnerFeld = null;
    private JTextField brancheFeld = null;
    private JTextArea BemerkungenArea = null;
    private JCheckBox abgemeldetCheck = null;
    private JCheckBox putztuecherCheck = null;
    private JCheckBox teppichCheck = null;
    private JCheckBox mattenCheck = null;
    private JCheckBox haushaltstexCheck = null;
    private JCheckBox berufsklCheck = null;
    private JCheckBox gasthotelCheck = null;
    private JCheckBox krankenhausCheck = null;
    private JCheckBox heimwaescheCheck = null;
    private JFormattedTextField anteilwaschgutFeld = null;
    private JFormattedTextField anteilgesamtwaschgutFeld = null;
    private JCheckBox betrwasseraufberCheck = null;
    private JCheckBox chlorCheck = null;
    private JCheckBox aktivchlorCheck = null;
    private JCheckBox vliesCheck = null;
    private JCheckBox fischCheck = null;
    private JCheckBox loesungsmittelCheck = null;
    private JButton saveAnh55Button = null;
    private Anh55Fachdaten fachdaten = null;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;
    private ActionListener editButtonListener;

    public Anh55Panel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:90dlu, 5dlu, 95dlu, 5dlu, r:0dlu, 0dlu, 90dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Fachdaten");
        builder.append("Entw\u00e4sserungsgebiet:", (Component)this.getEntgebIdFeld());
        builder.append("", (Component)this.getAbgemeldetCheck());
        builder.nextLine();
        builder.append("Branche:", (Component)this.getBrancheFeld());
        builder.append("", (Component)this.getPutztuecherCheck());
        builder.nextLine();
        builder.append("Ansprechpartner:", (Component)this.getAnsprechpartnerFeld());
        builder.append("", (Component)this.getMattenCheck());
        builder.nextLine();
        builder.append("Menge:", (Component)this.getMengeFeld());
        builder.append("", (Component)this.getTeppichCheck());
        builder.nextLine();
        builder.append("Sonstige Textilien:", (Component)this.getSonsttexFeld());
        builder.append("", (Component)this.getBerufsklCheck());
        builder.nextLine();
        builder.append("Monatl. Wasserverbrauch:", (Component)this.getMonatwasserverbFeld());
        builder.append("", (Component)this.getHaushaltstexCheck());
        builder.nextLine();
        builder.append("Anteil am Waschgut:", (Component)this.getAnteilwaschgutFeld());
        builder.append("", (Component)this.getGasthotelCheck());
        builder.nextLine();
        builder.append("Anteil am Gesamtwaschgut:", (Component)this.getGesamtwaschgutFeld());
        builder.append("", (Component)this.getKrankenhausCheck());
        builder.nextLine();
        builder.append("Sachbearbeiter/in:", (Component)this.getSachbearbeiterFeld());
        builder.append("", (Component)this.getHeimwaescheCheck());
        builder.nextLine();
        builder.append("", (Component)this.getVliesCheck());
        builder.append("", (Component)this.getFischCheck());
        builder.nextLine();
        builder.append("", (Component)this.getLoesungsmittelCheck());
        builder.append("", (Component)this.getBetrwasseraufberCheck());
        builder.nextLine();
        builder.append("", (Component)this.getChlorCheck());
        builder.append("", (Component)this.getAktivchlorCheck());
        builder.nextLine();
        builder.appendSeparator("Wasch-Situation");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane waschsituationScroller = new JScrollPane(this.getWaschsituationArea(), 20, 31);
        builder.appendRow("fill:30dlu");
        builder.append((Component)waschsituationScroller, 7);
        builder.appendSeparator("Bemerkungen");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane bemerkungsScroller = new JScrollPane(this.getBemerkungenArea(), 20, 31);
        builder.appendRow("fill:30dlu");
        builder.append((Component)bemerkungsScroller, 7);
        builder.appendSeparator("Verkn\u00fcpfte Objekte");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.appendRow("fill:100dlu");
        builder.append((Component)objektverknuepfungScroller, 7);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton(), (JButton)this.getSaveAnh55Button());
        builder.append((Component)buttonBar, 7);
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.fachdaten == null) {
            this.fachdaten = new Anh55Fachdaten();
            this.fachdaten.setBasisObjekt(this.hauptModul.getObjekt());
            Anh55Fachdaten.saveFachdaten(this.fachdaten);
            AUIKataster.debugOutput("Neues Anh 55 Objekt " + this.fachdaten + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
        }
    }

    private boolean saveAnh55Daten() {
        String bemerkungen = this.BemerkungenArea.getText();
        if ("".equals(bemerkungen)) {
            this.fachdaten.setBemerkungen(null);
        } else {
            this.fachdaten.setBemerkungen(bemerkungen);
        }
        String mengewaescheString = this.mengewaescheFeld.getText();
        if ("".equals(mengewaescheString)) {
            this.fachdaten.setMengewaesche(null);
        } else {
            this.fachdaten.setMengewaesche(mengewaescheString);
        }
        String sachbearbeiterString = this.sachbearbeiterFeld.getText();
        if ("".equals(sachbearbeiterString)) {
            this.fachdaten.setSachbearbeiter(null);
        } else {
            this.fachdaten.setSachbearbeiter(sachbearbeiterString);
        }
        String entgebIdString = this.entgebIdFeld.getText();
        if ("".equals(entgebIdString)) {
            this.fachdaten.setEntgebId(null);
        } else {
            this.fachdaten.setEntgebId(entgebIdString);
        }
        String monatwasserverbString = this.monatwasserverbFeld.getText();
        if ("".equals(monatwasserverbString)) {
            this.fachdaten.setMonatwasserverb(null);
        } else {
            this.fachdaten.setMonatwasserverb(monatwasserverbString);
        }
        String sonsttextString = this.sonsttexFeld.getText();
        if ("".equals(sonsttextString)) {
            this.fachdaten.setSonsttex(null);
        } else {
            this.fachdaten.setSonsttex(sonsttextString);
        }
        String waschsituationString = this.waschsituationArea.getText();
        if ("".equals(waschsituationString)) {
            this.fachdaten.setWaschsituation(null);
        } else {
            this.fachdaten.setWaschsituation(waschsituationString);
        }
        String ansprechpartnerString = this.ansprechpartnerFeld.getText();
        if ("".equals(ansprechpartnerString)) {
            this.fachdaten.setAnsprechpartner(null);
        } else {
            this.fachdaten.setAnsprechpartner(ansprechpartnerString);
        }
        String brancheString = this.brancheFeld.getText();
        if ("".equals(brancheString)) {
            this.fachdaten.setBranche(null);
        } else {
            this.fachdaten.setBranche(brancheString);
        }
        Integer anteilwaschgut = ((IntegerField)this.anteilwaschgutFeld).getIntValue();
        this.fachdaten.setAnteilwaschgut(anteilwaschgut);
        Integer anteilgesamtwg = ((IntegerField)this.anteilgesamtwaschgutFeld).getIntValue();
        this.fachdaten.setAnteilgesamtgut(anteilgesamtwg);
        if (this.getAbgemeldetCheck().isSelected()) {
            this.fachdaten.setAbgemeldet(true);
        } else {
            this.fachdaten.setAbgemeldet(false);
        }
        if (this.getPutztuecherCheck().isSelected()) {
            this.fachdaten.setPutztuecher(true);
        } else {
            this.fachdaten.setPutztuecher(false);
        }
        if (this.getTeppichCheck().isSelected()) {
            this.fachdaten.setTeppich(true);
        } else {
            this.fachdaten.setTeppich(false);
        }
        if (this.getMattenCheck().isSelected()) {
            this.fachdaten.setMatten(true);
        } else {
            this.fachdaten.setMatten(false);
        }
        if (this.getHaushaltstexCheck().isSelected()) {
            this.fachdaten.setHaushaltstex(true);
        } else {
            this.fachdaten.setHaushaltstex(false);
        }
        if (this.getBerufsklCheck().isSelected()) {
            this.fachdaten.setBerufskl(true);
        } else {
            this.fachdaten.setBerufskl(false);
        }
        if (this.getGasthotelCheck().isSelected()) {
            this.fachdaten.setGasthotel(true);
        } else {
            this.fachdaten.setGasthotel(false);
        }
        if (this.getKrankenhausCheck().isSelected()) {
            this.fachdaten.setKrankenhaus(true);
        } else {
            this.fachdaten.setKrankenhaus(false);
        }
        if (this.getHeimwaescheCheck().isSelected()) {
            this.fachdaten.setHeimwaesche(true);
        } else {
            this.fachdaten.setHeimwaesche(false);
        }
        if (this.getBetrwasseraufberCheck().isSelected()) {
            this.fachdaten.setBetrwasseraufber(true);
        } else {
            this.fachdaten.setBetrwasseraufber(false);
        }
        if (this.getChlorCheck().isSelected()) {
            this.fachdaten.setChlor(true);
        } else {
            this.fachdaten.setChlor(false);
        }
        if (this.getAktivchlorCheck().isSelected()) {
            this.fachdaten.setAktivchlor(true);
        } else {
            this.fachdaten.setAktivchlor(false);
        }
        if (this.getVliesCheck().isSelected()) {
            this.fachdaten.setVlies(true);
        } else {
            this.fachdaten.setVlies(true);
        }
        if (this.getFischCheck().isSelected()) {
            this.fachdaten.setFischfleisch(true);
        } else {
            this.fachdaten.setFischfleisch(false);
        }
        if (this.getLoesungsmittelCheck().isSelected()) {
            this.fachdaten.setLoesungsmittel(true);
        } else {
            this.fachdaten.setLoesungsmittel(false);
        }
        boolean success = Anh55Fachdaten.saveFachdaten(this.fachdaten);
        if (success) {
            AUIKataster.debugOutput("Anh 55 Objekt " + this.fachdaten.getId() + " gespeichert.", "Anh55Panel.saveFachdaten");
        } else {
            AUIKataster.debugOutput("Anh 55 Objekt " + this.fachdaten + " konnte nicht gespeichert werden!", "Anh55Panel.saveFachdaten");
        }
        return success;
    }

    public void enableAll(boolean enabled) {
        this.getBemerkungenArea().setEnabled(enabled);
        this.getAbgemeldetCheck().setEnabled(enabled);
        this.getSachbearbeiterFeld().setEnabled(enabled);
        this.getEntgebIdFeld().setEnabled(enabled);
        this.getMengeFeld().setEnabled(enabled);
        this.getSonsttexFeld().setEnabled(enabled);
        this.getMonatwasserverbFeld().setEnabled(enabled);
        this.getWaschsituationArea().setEnabled(enabled);
        this.getAnsprechpartnerFeld().setEnabled(enabled);
        this.getBrancheFeld().setEnabled(enabled);
        this.getPutztuecherCheck().setEnabled(enabled);
        this.getTeppichCheck().setEnabled(enabled);
        this.getMattenCheck().setEnabled(enabled);
        this.getHaushaltstexCheck().setEnabled(enabled);
        this.getBerufsklCheck().setEnabled(enabled);
        this.getGasthotelCheck().setEnabled(enabled);
        this.getKrankenhausCheck().setEnabled(enabled);
        this.getHeimwaescheCheck().setEnabled(enabled);
        this.getAnteilwaschgutFeld().setEnabled(enabled);
        this.getGesamtwaschgutFeld().setEnabled(enabled);
        this.getBetrwasseraufberCheck().setEnabled(enabled);
        this.getChlorCheck().setEnabled(enabled);
        this.getAktivchlorCheck().setEnabled(enabled);
        this.getVliesCheck().setEnabled(enabled);
        this.getFischCheck().setEnabled(enabled);
        this.getLoesungsmittelCheck().setEnabled(enabled);
    }

    public void clearForm() {
        this.getAbgemeldetCheck().setSelected(false);
        this.getSachbearbeiterFeld().setText(null);
        this.getEntgebIdFeld().setText(null);
        this.getMengeFeld().setText(null);
        this.getSonsttexFeld().setText(null);
        this.getMonatwasserverbFeld().setText(null);
        this.getWaschsituationArea().setText(null);
        this.getAnsprechpartnerFeld().setText(null);
        this.getBrancheFeld().setText(null);
        this.getPutztuecherCheck().setSelected(false);
        this.getTeppichCheck().setSelected(false);
        this.getMattenCheck().setSelected(false);
        this.getHaushaltstexCheck().setSelected(false);
        this.getBerufsklCheck().setSelected(false);
        this.getGasthotelCheck().setSelected(false);
        this.getKrankenhausCheck().setSelected(false);
        this.getHeimwaescheCheck().setSelected(false);
        this.getAnteilwaschgutFeld().setText(null);
        this.getGesamtwaschgutFeld().setText(null);
        this.getBetrwasseraufberCheck().setSelected(false);
        this.getChlorCheck().setSelected(false);
        this.getAktivchlorCheck().setSelected(false);
        this.getVliesCheck().setSelected(false);
        this.getFischCheck().setSelected(false);
        this.getLoesungsmittelCheck().setSelected(false);
        this.getBemerkungenArea().setText(null);
        this.getAbgemeldetCheck().setSelected(false);
    }

    public void updateForm() throws RuntimeException {
        if (this.fachdaten != null) {
            if (this.fachdaten.getBemerkungen() != null) {
                this.getBemerkungenArea().setText(this.fachdaten.getBemerkungen());
            }
            if (this.fachdaten.getSachbearbeiter() != null) {
                this.getSachbearbeiterFeld().setText(this.fachdaten.getSachbearbeiter());
            }
            if (this.fachdaten.getEntgebId() != null) {
                this.getEntgebIdFeld().setText(this.fachdaten.getEntgebId());
            }
            if (this.fachdaten.getMengewaesche() != null) {
                this.getMengeFeld().setText(this.fachdaten.getMengewaesche());
            }
            if (this.fachdaten.getSonsttex() != null) {
                this.getSonsttexFeld().setText(this.fachdaten.getSonsttex());
            }
            if (this.fachdaten.getMonatwasserverb() != null) {
                this.getMonatwasserverbFeld().setText(this.fachdaten.getMonatwasserverb());
            }
            if (this.fachdaten.getWaschsituation() != null) {
                this.getWaschsituationArea().setText(this.fachdaten.getWaschsituation());
            }
            if (this.fachdaten.getAnsprechpartner() != null) {
                this.getAnsprechpartnerFeld().setText(this.fachdaten.getAnsprechpartner());
            }
            if (this.fachdaten.getBranche() != null) {
                this.getBrancheFeld().setText(this.fachdaten.getBranche());
            }
            if (this.fachdaten.getAnteilwaschgut() != null) {
                this.getAnteilwaschgutFeld().setText(this.fachdaten.getAnteilwaschgut().toString());
            }
            if (this.fachdaten.getAnteilgesamtgut() != null) {
                this.getGesamtwaschgutFeld().setText(this.fachdaten.getAnteilgesamtgut().toString());
            }
            if (this.fachdaten.getAbgemeldet() != null) {
                if (this.fachdaten.getAbgemeldet().booleanValue()) {
                    this.getAbgemeldetCheck().setSelected(true);
                } else {
                    this.getAbgemeldetCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getPutztuecher() != null) {
                if (this.fachdaten.getPutztuecher().booleanValue()) {
                    this.getPutztuecherCheck().setSelected(true);
                } else {
                    this.getPutztuecherCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getTeppich() != null) {
                if (this.fachdaten.getTeppich().booleanValue()) {
                    this.getTeppichCheck().setSelected(true);
                } else {
                    this.getTeppichCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getMatten() != null) {
                if (this.fachdaten.getMatten().booleanValue()) {
                    this.getMattenCheck().setSelected(true);
                } else {
                    this.getMattenCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getHaushaltstex() != null) {
                if (this.fachdaten.getHaushaltstex().booleanValue()) {
                    this.getHaushaltstexCheck().setSelected(true);
                } else {
                    this.getHaushaltstexCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getBerufskl() != null) {
                if (this.fachdaten.getBerufskl().booleanValue()) {
                    this.getBerufsklCheck().setSelected(true);
                } else {
                    this.getBerufsklCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getGasthotel() != null) {
                if (this.fachdaten.getGasthotel().booleanValue()) {
                    this.getGasthotelCheck().setSelected(true);
                } else {
                    this.getGasthotelCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getKrankenhaus() != null) {
                if (this.fachdaten.getKrankenhaus().booleanValue()) {
                    this.getKrankenhausCheck().setSelected(true);
                } else {
                    this.getKrankenhausCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getHeimwaesche() != null) {
                if (this.fachdaten.getHeimwaesche().booleanValue()) {
                    this.getHeimwaescheCheck().setSelected(true);
                } else {
                    this.getHeimwaescheCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getBetrwasseraufber() != null) {
                if (this.fachdaten.getBetrwasseraufber().booleanValue()) {
                    this.getBetrwasseraufberCheck().setSelected(true);
                } else {
                    this.getBetrwasseraufberCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getChlor() != null) {
                if (this.fachdaten.getChlor().booleanValue()) {
                    this.getChlorCheck().setSelected(true);
                } else {
                    this.getChlorCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getAktivchlor() != null) {
                if (this.fachdaten.getAktivchlor().booleanValue()) {
                    this.getAktivchlorCheck().setSelected(true);
                } else {
                    this.getAktivchlorCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getVlies() != null) {
                if (this.fachdaten.getVlies().booleanValue()) {
                    this.getVliesCheck().setSelected(true);
                } else {
                    this.getVliesCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getFischfleisch() != null) {
                if (this.fachdaten.getFischfleisch().booleanValue()) {
                    this.getFischCheck().setSelected(true);
                } else {
                    this.getFischCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getLoesungsmittel() != null) {
                if (this.fachdaten.getLoesungsmittel().booleanValue()) {
                    this.getLoesungsmittelCheck().setSelected(true);
                } else {
                    this.getLoesungsmittelCheck().setSelected(false);
                }
            }
            this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
        }
    }

    public void fetchFormData() throws RuntimeException {
        this.fachdaten = Anh55Fachdaten.getAnh55ByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("Anhang 55 Objekt aus DB geholt: ID" + this.fachdaten, "Anh55Panel.fetchFormData");
    }

    private JButton getSaveAnh55Button() {
        if (this.saveAnh55Button == null) {
            this.saveAnh55Button = new JButton("Speichern");
            this.saveAnh55Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Anh55Panel.this.enableAll(false);
                    if (Anh55Panel.this.saveAnh55Daten()) {
                        Anh55Panel.this.hauptModul.getFrame().changeStatus("Anh 55 Objekt " + Anh55Panel.this.fachdaten.getId() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        Anh55Panel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern des Anh 55 Objekt!", HauptFrame.ERROR_COLOR);
                    }
                    Anh55Panel.this.hauptModul.fillForm();
                }
            });
        }
        return this.saveAnh55Button;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private JCheckBox getAbgemeldetCheck() {
        if (this.abgemeldetCheck == null) {
            this.abgemeldetCheck = new JCheckBox("Abgemeldet?");
        }
        return this.abgemeldetCheck;
    }

    private JTextField getEntgebIdFeld() {
        if (this.entgebIdFeld == null) {
            this.entgebIdFeld = new LimitedTextField(50);
        }
        return this.entgebIdFeld;
    }

    private JTextField getBrancheFeld() {
        if (this.brancheFeld == null) {
            this.brancheFeld = new LimitedTextField(50);
        }
        return this.brancheFeld;
    }

    private JCheckBox getPutztuecherCheck() {
        if (this.putztuecherCheck == null) {
            this.putztuecherCheck = new JCheckBox("Putzt\u00fccher?");
        }
        return this.putztuecherCheck;
    }

    private JTextField getAnsprechpartnerFeld() {
        if (this.ansprechpartnerFeld == null) {
            this.ansprechpartnerFeld = new LimitedTextField(50);
        }
        return this.ansprechpartnerFeld;
    }

    private JCheckBox getMattenCheck() {
        if (this.mattenCheck == null) {
            this.mattenCheck = new JCheckBox("Matten?");
        }
        return this.mattenCheck;
    }

    private JTextField getMengeFeld() {
        if (this.mengewaescheFeld == null) {
            this.mengewaescheFeld = new LimitedTextField(50);
        }
        return this.mengewaescheFeld;
    }

    private JCheckBox getTeppichCheck() {
        if (this.teppichCheck == null) {
            this.teppichCheck = new JCheckBox("Teppiche?");
        }
        return this.teppichCheck;
    }

    private JTextField getSonsttexFeld() {
        if (this.sonsttexFeld == null) {
            this.sonsttexFeld = new LimitedTextField(50);
        }
        return this.sonsttexFeld;
    }

    private JCheckBox getBerufsklCheck() {
        if (this.berufsklCheck == null) {
            this.berufsklCheck = new JCheckBox("Berufskleidung?");
        }
        return this.berufsklCheck;
    }

    private DoubleField getMonatwasserverbFeld() {
        if (this.monatwasserverbFeld == null) {
            this.monatwasserverbFeld = new DoubleField(50);
        }
        return this.monatwasserverbFeld;
    }

    private JCheckBox getHaushaltstexCheck() {
        if (this.haushaltstexCheck == null) {
            this.haushaltstexCheck = new JCheckBox("Haushaltstextilien?");
        }
        return this.haushaltstexCheck;
    }

    private JCheckBox getGasthotelCheck() {
        if (this.gasthotelCheck == null) {
            this.gasthotelCheck = new JCheckBox("Gastst\u00e4tten-/Hoteltextilien?");
        }
        return this.gasthotelCheck;
    }

    private JCheckBox getKrankenhausCheck() {
        if (this.krankenhausCheck == null) {
            this.krankenhausCheck = new JCheckBox("Krankenhaus?");
        }
        return this.krankenhausCheck;
    }

    private JCheckBox getHeimwaescheCheck() {
        if (this.heimwaescheCheck == null) {
            this.heimwaescheCheck = new JCheckBox("Heimw\u00e4sche?");
        }
        return this.heimwaescheCheck;
    }

    private JCheckBox getVliesCheck() {
        if (this.vliesCheck == null) {
            this.vliesCheck = new JCheckBox("Vlies?");
        }
        return this.vliesCheck;
    }

    private JCheckBox getFischCheck() {
        if (this.fischCheck == null) {
            this.fischCheck = new JCheckBox("Fisch/Fleisch?");
        }
        return this.fischCheck;
    }

    private JCheckBox getLoesungsmittelCheck() {
        if (this.loesungsmittelCheck == null) {
            this.loesungsmittelCheck = new JCheckBox("L\u00f6sungsmittel?");
        }
        return this.loesungsmittelCheck;
    }

    private JFormattedTextField getAnteilwaschgutFeld() {
        if (this.anteilwaschgutFeld == null) {
            this.anteilwaschgutFeld = new IntegerField();
        }
        return this.anteilwaschgutFeld;
    }

    private JFormattedTextField getGesamtwaschgutFeld() {
        if (this.anteilgesamtwaschgutFeld == null) {
            this.anteilgesamtwaschgutFeld = new IntegerField();
        }
        return this.anteilgesamtwaschgutFeld;
    }

    private JTextField getSachbearbeiterFeld() {
        if (this.sachbearbeiterFeld == null) {
            this.sachbearbeiterFeld = new LimitedTextField(50);
        }
        return this.sachbearbeiterFeld;
    }

    private JCheckBox getBetrwasseraufberCheck() {
        if (this.betrwasseraufberCheck == null) {
            this.betrwasseraufberCheck = new JCheckBox("Betriebswasseraufbereitung?");
        }
        return this.betrwasseraufberCheck;
    }

    private JCheckBox getChlorCheck() {
        if (this.chlorCheck == null) {
            this.chlorCheck = new JCheckBox("Chlor?");
        }
        return this.chlorCheck;
    }

    private JCheckBox getAktivchlorCheck() {
        if (this.aktivchlorCheck == null) {
            this.aktivchlorCheck = new JCheckBox("Aktiv-Chlor?");
        }
        return this.aktivchlorCheck;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = Anh55Panel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = Anh55Panel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != Anh55Panel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                Anh55Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                Anh55Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            Anh55Panel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Anh55Panel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Anh55Panel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = Anh55Panel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && Anh55Panel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = Anh55Panel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(Anh55Panel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (Anh55Panel.this.objektVerknuepfungModel.removeRow(row)) {
                                Anh55Panel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                Anh55Panel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(Anh55Panel.this.hauptModul.getFrame(), Anh55Panel.this.fachdaten.getBasisObjekt(), Anh55Panel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }

    private JTextArea getBemerkungenArea() {
        if (this.BemerkungenArea == null) {
            this.BemerkungenArea = new LimitedTextArea(255);
            this.BemerkungenArea.setLineWrap(true);
            this.BemerkungenArea.setWrapStyleWord(true);
        }
        return this.BemerkungenArea;
    }

    private JTextArea getWaschsituationArea() {
        if (this.waschsituationArea == null) {
            this.waschsituationArea = new LimitedTextArea(255);
            this.waschsituationArea.setLineWrap(true);
            this.waschsituationArea.setWrapStyleWord(true);
        }
        return this.waschsituationArea;
    }
}

