/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh53Fachdaten;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Anh53Panel
extends JPanel {
    private String name = "Fotografische Prozesse";
    private BasisObjektBearbeiten hauptModul;
    private JTextField brancheFeld = null;
    private IntegerField durchsatzFeld = null;
    private IntegerField gesamtmengeFeld = null;
    private IntegerField spuelwasserFeld = null;
    private JCheckBox onlinesilberCheck = null;
    private JCheckBox abwasserCheck = null;
    private JCheckBox abgemeldetCheck = null;
    private JCheckBox tagebuchCheck = null;
    private JCheckBox wasseruhrCheck = null;
    private JCheckBox wartungsvertragCheck = null;
    private JCheckBox grgenCheck = null;
    private JCheckBox bagatellCheck = null;
    private TextFieldDateChooser bagatellDatum = null;
    private JTextArea anh53BemerkungArea = null;
    private JButton saveAnh53Button = null;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;
    private Anh53Fachdaten fachdaten = null;

    public Anh53Panel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:100dlu, 5dlu, 80dlu, 5dlu, r:65dlu, 5dlu, 100dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Fachdaten");
        builder.append("Branche:", (Component)this.getBrancheFeld());
        builder.append("Durchsatz:", (Component)this.getDurchsatzFeld());
        builder.nextLine();
        builder.append("Gesamtmenge:", (Component)this.getGesamtmengeFeld());
        builder.append("Sp\u00fclwasser:", (Component)this.getSpuelwasserFeld());
        builder.nextLine();
        builder.append("Bagatelle seit:", (Component)this.getBagatellDatum());
        builder.append("", (Component)this.getBagatellCheck());
        builder.nextLine();
        builder.append("", (Component)this.getAbwasserCheck());
        builder.append("", (Component)this.getOnlinesilberCheck());
        builder.nextLine();
        builder.append("", (Component)this.getAbgemeldetCheck());
        builder.append("", (Component)this.getTagebuchCheck());
        builder.nextLine();
        builder.append("", (Component)this.getWasseruhrCheck());
        builder.append("", (Component)this.getWartungCheck());
        builder.nextLine();
        builder.append("", (Component)this.getGrgenCheck());
        builder.nextLine();
        builder.appendSeparator("Bemerkungen");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane bemerkungsScroller = new JScrollPane(this.getAnh53BemerkungArea(), 20, 31);
        builder.appendRow("fill:30dlu");
        builder.append((Component)bemerkungsScroller, 7);
        builder.appendSeparator("Verkn\u00fcpfte Objekte");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.appendRow("fill:100dlu");
        builder.append((Component)objektverknuepfungScroller, 7);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton(), (JButton)this.getSaveAnh53Button());
        builder.append((Component)buttonBar, 7);
    }

    public void fetchFormData() throws RuntimeException {
        this.fachdaten = Anh53Fachdaten.getAnh53ByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("Objekt aus DB geholt: " + this.fachdaten, "Anh53Panel.fetchFormData");
    }

    public void updateForm() throws RuntimeException {
        if (this.fachdaten != null) {
            if (this.fachdaten.getBemerkungen() != null) {
                this.getAnh53BemerkungArea().setText(this.fachdaten.getBemerkungen());
            }
            if (this.fachdaten.getBranche() != null) {
                this.getBrancheFeld().setText(this.fachdaten.getBranche());
            }
            if (this.fachdaten.getDurchsatz() != null) {
                this.getDurchsatzFeld().setValue(this.fachdaten.getDurchsatz());
            }
            if (this.fachdaten.getGesamtmengeEb() != null) {
                this.getGesamtmengeFeld().setValue(this.fachdaten.getGesamtmengeEb());
            }
            if (this.fachdaten.getSpuelwassermenge() != null) {
                this.getSpuelwasserFeld().setValue(this.fachdaten.getSpuelwassermenge());
            }
            if (this.fachdaten.getBagatell() != null) {
                if (this.fachdaten.getBagatell().booleanValue()) {
                    this.getBagatellCheck().setSelected(true);
                } else {
                    this.getBagatellCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getAbwasser() != null) {
                if (this.fachdaten.getAbwasser().booleanValue()) {
                    this.getAbwasserCheck().setSelected(true);
                } else {
                    this.getAbwasserCheck().setSelected(false);
                }
            }
            this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
        }
    }

    public void clearForm() {
        this.getBrancheFeld().setText(null);
        this.getDurchsatzFeld().setText(null);
        this.getGesamtmengeFeld().setText(null);
        this.getSpuelwasserFeld().setText(null);
        this.getAnh53BemerkungArea().setText(null);
        this.getBagatellDatum().setDate(null);
        this.getBagatellCheck().setSelected(false);
        this.getAbwasserCheck().setSelected(false);
        this.getOnlinesilberCheck().setSelected(false);
        this.getAbgemeldetCheck().setSelected(false);
        this.getTagebuchCheck().setSelected(false);
        this.getWasseruhrCheck().setSelected(false);
        this.getWartungCheck().setSelected(false);
        this.getGrgenCheck().setSelected(false);
    }

    public void enableAll(boolean enabled) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    private boolean saveAnh53Daten() {
        String bemerkungen = this.anh53BemerkungArea.getText();
        if ("".equals(bemerkungen)) {
            this.fachdaten.setBemerkungen(null);
        } else {
            this.fachdaten.setBemerkungen(bemerkungen);
        }
        boolean success = Anh53Fachdaten.saveFachdaten(this.fachdaten);
        if (success) {
            AUIKataster.debugOutput("Objekt " + this.fachdaten.getBasisObjekt().getBasisBetreiber().getBetrname() + " gespeichert.", "Anh53Panel.saveAnh53Daten");
        } else {
            AUIKataster.debugOutput("Objekt " + this.fachdaten + " konnte nicht gespeichert werden!", "Anh53Panel.saveAnh53Daten");
        }
        return success;
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.fachdaten == null) {
            this.fachdaten = new Anh53Fachdaten();
            this.fachdaten.setBasisObjekt(this.hauptModul.getObjekt());
            Anh53Fachdaten.saveFachdaten(this.fachdaten);
            AUIKataster.debugOutput("Neues Objekt " + this.fachdaten + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
        }
    }

    private JTextArea getAnh53BemerkungArea() {
        if (this.anh53BemerkungArea == null) {
            this.anh53BemerkungArea = new LimitedTextArea(255);
            this.anh53BemerkungArea.setLineWrap(true);
            this.anh53BemerkungArea.setWrapStyleWord(true);
        }
        return this.anh53BemerkungArea;
    }

    private JCheckBox getBagatellCheck() {
        if (this.bagatellCheck == null) {
            this.bagatellCheck = new JCheckBox("Bagatelle");
        }
        return this.bagatellCheck;
    }

    private JCheckBox getOnlinesilberCheck() {
        if (this.onlinesilberCheck == null) {
            this.onlinesilberCheck = new JCheckBox("Online Silber");
        }
        return this.onlinesilberCheck;
    }

    private JCheckBox getAbwasserCheck() {
        if (this.abwasserCheck == null) {
            this.abwasserCheck = new JCheckBox("Abwasser");
        }
        return this.abwasserCheck;
    }

    private JCheckBox getAbgemeldetCheck() {
        if (this.abgemeldetCheck == null) {
            this.abgemeldetCheck = new JCheckBox("Abgemeldet");
        }
        return this.abgemeldetCheck;
    }

    private JCheckBox getTagebuchCheck() {
        if (this.tagebuchCheck == null) {
            this.tagebuchCheck = new JCheckBox("Tagebuch");
        }
        return this.tagebuchCheck;
    }

    private JCheckBox getWasseruhrCheck() {
        if (this.wasseruhrCheck == null) {
            this.wasseruhrCheck = new JCheckBox("Wasseruhr");
        }
        return this.wasseruhrCheck;
    }

    private JCheckBox getWartungCheck() {
        if (this.wartungsvertragCheck == null) {
            this.wartungsvertragCheck = new JCheckBox("Wartungsvertrag");
        }
        return this.wartungsvertragCheck;
    }

    private JCheckBox getGrgenCheck() {
        if (this.grgenCheck == null) {
            this.grgenCheck = new JCheckBox("gro\u00dfe Genehmigung");
        }
        return this.grgenCheck;
    }

    private TextFieldDateChooser getBagatellDatum() {
        if (this.bagatellDatum == null) {
            this.bagatellDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.bagatellDatum;
    }

    private JTextField getBrancheFeld() {
        if (this.brancheFeld == null) {
            this.brancheFeld = new LimitedTextField(50);
        }
        return this.brancheFeld;
    }

    private IntegerField getDurchsatzFeld() {
        if (this.durchsatzFeld == null) {
            this.durchsatzFeld = new IntegerField();
        }
        return this.durchsatzFeld;
    }

    private IntegerField getGesamtmengeFeld() {
        if (this.gesamtmengeFeld == null) {
            this.gesamtmengeFeld = new IntegerField();
        }
        return this.gesamtmengeFeld;
    }

    private IntegerField getSpuelwasserFeld() {
        if (this.spuelwasserFeld == null) {
            this.spuelwasserFeld = new IntegerField();
        }
        return this.spuelwasserFeld;
    }

    private JButton getSaveAnh53Button() {
        if (this.saveAnh53Button == null) {
            this.saveAnh53Button = new JButton("Speichern");
            this.saveAnh53Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Anh53Panel.this.enableAll(false);
                    if (Anh53Panel.this.saveAnh53Daten()) {
                        Anh53Panel.this.hauptModul.getFrame().changeStatus("Objekt " + Anh53Panel.this.fachdaten.getObjektid() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        Anh53Panel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern des Objektes!", HauptFrame.ERROR_COLOR);
                    }
                    Anh53Panel.this.hauptModul.fillForm();
                }
            });
        }
        return this.saveAnh53Button;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = Anh53Panel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = Anh53Panel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != Anh53Panel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                Anh53Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                Anh53Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            Anh53Panel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Anh53Panel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Anh53Panel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = Anh53Panel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && Anh53Panel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = Anh53Panel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(Anh53Panel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (Anh53Panel.this.objektVerknuepfungModel.removeRow(row)) {
                                Anh53Panel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                Anh53Panel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(Anh53Panel.this.hauptModul.getFrame(), Anh53Panel.this.fachdaten.getBasisObjekt(), Anh53Panel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }
}

