/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh52Fachdaten;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Anh52Panel
extends JPanel {
    private String name = "Chemische W\u00e4scherei";
    private BasisObjektBearbeiten hauptModul;
    private JFormattedTextField nrbetriebsstaetteFeld = null;
    private JTextField firmennameFeld = null;
    private JTextField telefonFeld = null;
    private JTextField telefaxFeld = null;
    private JTextField ansprechpartnerFeld = null;
    private TextFieldDateChooser datumGenChooser = null;
    private JTextArea BemerkungenArea = null;
    private JButton saveAnh52Button = null;
    private Anh52Fachdaten fachdaten = null;
    private ActionListener editButtonListener;

    public Anh52Panel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:90dlu, 5dlu, 95dlu, 5dlu, r:0dlu, 0dlu, 90dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Fachdaten");
        builder.append("Nr. der Betriebsst\u00e4tte:", (Component)this.getNrBetriebsstaette());
        builder.append("");
        builder.nextLine();
        builder.append("Firmenname:", (Component)this.getFirmennameFeld());
        builder.append("");
        builder.nextLine();
        builder.append("Ansprechpartner:", (Component)this.getAnsprechpartnerFeld());
        builder.append("");
        builder.nextLine();
        builder.append("Telefon:", (Component)this.getTelefonFeld());
        builder.append("");
        builder.nextLine();
        builder.append("Telefax:", (Component)this.getTelefaxFeld());
        builder.append("");
        builder.nextLine();
        builder.append("Genehmigung:", (Component)this.getGenehmigungDatum());
        builder.append("");
        builder.nextLine();
        builder.appendSeparator("Bemerkungen");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane bemerkungsScroller = new JScrollPane(this.getBemerkungenArea(), 20, 31);
        builder.appendRow("fill:30dlu");
        builder.append((Component)bemerkungsScroller, 7);
        JPanel buttonBar = ButtonBarFactory.buildOKBar((JButton)this.getSaveAnh52Button());
        builder.append((Component)buttonBar, 7);
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.fachdaten == null) {
            this.fachdaten = new Anh52Fachdaten();
            this.fachdaten.setId(this.hauptModul.getObjekt().getObjektid());
            Anh52Fachdaten.saveFachdaten(this.fachdaten);
            AUIKataster.debugOutput("Neues Anh 52 Objekt " + this.fachdaten + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
        }
    }

    private boolean saveAnh52Daten() {
        String bemerkungen = this.BemerkungenArea.getText();
        if ("".equals(bemerkungen)) {
            this.fachdaten.setBemerkungen(null);
        } else {
            this.fachdaten.setBemerkungen(bemerkungen);
        }
        Integer nrbetriebst = ((IntegerField)this.nrbetriebsstaetteFeld).getIntValue();
        this.fachdaten.setNrbetriebsstaette(nrbetriebst);
        Date genehmigung = this.datumGenChooser.getDate();
        this.fachdaten.setDatumGen(genehmigung);
        String ansprechpartnerString = this.ansprechpartnerFeld.getText();
        if ("".equals(ansprechpartnerString)) {
            this.fachdaten.setAnsprechpartner(null);
        } else {
            this.fachdaten.setAnsprechpartner(ansprechpartnerString);
        }
        String telefonString = this.telefonFeld.getText();
        if ("".equals(telefonString)) {
            this.fachdaten.setTelefon(null);
        } else {
            this.fachdaten.setTelefon(telefonString);
        }
        String telefaxString = this.telefaxFeld.getText();
        if ("".equals(telefaxString)) {
            this.fachdaten.setTelefax(null);
        } else {
            this.fachdaten.setTelefax(telefaxString);
        }
        String firmennameString = this.firmennameFeld.getText();
        if ("".equals(firmennameString)) {
            this.fachdaten.setFirmenname(null);
        } else {
            this.fachdaten.setFirmenname(firmennameString);
        }
        boolean success = Anh52Fachdaten.saveFachdaten(this.fachdaten);
        if (success) {
            AUIKataster.debugOutput("Anh 52 Objekt " + this.fachdaten.getId() + " gespeichert.", "Anh52Panel.saveFachdaten");
        } else {
            AUIKataster.debugOutput("Anh 52 Objekt " + this.fachdaten + " konnte nicht gespeichert werden!", "Anh52Panel.saveFachdaten");
        }
        return success;
    }

    public void enableAll(boolean enabled) {
        this.getBemerkungenArea().setEnabled(enabled);
        this.getNrBetriebsstaette().setEnabled(enabled);
        this.getFirmennameFeld().setEnabled(enabled);
        this.getTelefonFeld().setEnabled(enabled);
        this.getTelefaxFeld().setEnabled(enabled);
        this.getAnsprechpartnerFeld().setEnabled(enabled);
        this.getGenehmigungDatum().setEnabled(enabled);
    }

    public void clearForm() {
        this.getNrBetriebsstaette().setText(null);
        this.getFirmennameFeld().setText(null);
        this.getTelefonFeld().setText(null);
        this.getTelefaxFeld().setText(null);
        this.getAnsprechpartnerFeld().setText(null);
        this.getGenehmigungDatum().setDate(null);
        this.getBemerkungenArea().setText(null);
    }

    public void updateForm() throws RuntimeException {
        if (this.fachdaten != null) {
            if (this.fachdaten.getBemerkungen() != null) {
                this.getBemerkungenArea().setText(this.fachdaten.getBemerkungen());
            }
            if (this.fachdaten.getNrbetriebsstaette() != null) {
                this.getNrBetriebsstaette().setText(this.fachdaten.getNrbetriebsstaette().toString());
            }
            if (this.fachdaten.getFirmenname() != null) {
                this.getFirmennameFeld().setText(this.fachdaten.getFirmenname());
            }
            if (this.fachdaten.getTelefon() != null) {
                this.getTelefonFeld().setText(this.fachdaten.getTelefon());
            }
            if (this.fachdaten.getTelefax() != null) {
                this.getTelefaxFeld().setText(this.fachdaten.getTelefax());
            }
            if (this.fachdaten.getAnsprechpartner() != null) {
                this.getAnsprechpartnerFeld().setText(this.fachdaten.getAnsprechpartner());
            }
            if (this.fachdaten.getDatumGen() != null) {
                this.getGenehmigungDatum().setDate(this.fachdaten.getDatumGen());
            }
        }
    }

    public void fetchFormData() throws RuntimeException {
        this.fachdaten = Anh52Fachdaten.getAnh52ByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("Anhang 52 Objekt aus DB geholt: ID" + this.fachdaten, "Anh52Panel.fetchFormData");
    }

    @Override
    public String getName() {
        return this.name;
    }

    private JButton getSaveAnh52Button() {
        if (this.saveAnh52Button == null) {
            this.saveAnh52Button = new JButton("Speichern");
            this.saveAnh52Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Anh52Panel.this.enableAll(false);
                    if (Anh52Panel.this.saveAnh52Daten()) {
                        Anh52Panel.this.hauptModul.getFrame().changeStatus("Anh 52 Objekt " + Anh52Panel.this.fachdaten.getId() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        Anh52Panel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern des Anh 40 Objekt!", HauptFrame.ERROR_COLOR);
                    }
                    Anh52Panel.this.hauptModul.fillForm();
                }
            });
        }
        return this.saveAnh52Button;
    }

    private JFormattedTextField getNrBetriebsstaette() {
        if (this.nrbetriebsstaetteFeld == null) {
            this.nrbetriebsstaetteFeld = new IntegerField();
        }
        return this.nrbetriebsstaetteFeld;
    }

    private JTextField getFirmennameFeld() {
        if (this.firmennameFeld == null) {
            this.firmennameFeld = new LimitedTextField(50);
        }
        return this.firmennameFeld;
    }

    private JTextField getTelefonFeld() {
        if (this.telefonFeld == null) {
            this.telefonFeld = new LimitedTextField(50);
        }
        return this.telefonFeld;
    }

    private JTextField getTelefaxFeld() {
        if (this.telefaxFeld == null) {
            this.telefaxFeld = new LimitedTextField(50);
        }
        return this.telefaxFeld;
    }

    private JTextField getAnsprechpartnerFeld() {
        if (this.ansprechpartnerFeld == null) {
            this.ansprechpartnerFeld = new LimitedTextField(50);
        }
        return this.ansprechpartnerFeld;
    }

    private TextFieldDateChooser getGenehmigungDatum() {
        if (this.datumGenChooser == null) {
            this.datumGenChooser = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.datumGenChooser;
    }

    private JTextArea getBemerkungenArea() {
        if (this.BemerkungenArea == null) {
            this.BemerkungenArea = new LimitedTextArea(252);
            this.BemerkungenArea.setLineWrap(true);
            this.BemerkungenArea.setWrapStyleWord(true);
        }
        return this.BemerkungenArea;
    }
}

