/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh50Fachdaten;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AnhEntsorger;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.editors.EntsorgerEditor;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class Anh50Panel
extends JPanel {
    private String name = "Zahnarzt";
    private BasisObjektBearbeiten hauptModul;
    private JTextField gefaehrdungsklasseFeld = null;
    private JCheckBox erloschenCheck = null;
    private JTextArea anh50BemerkungArea = null;
    private TextFieldDateChooser antragDatum = null;
    private TextFieldDateChooser genehmigungDatum = null;
    private TextFieldDateChooser wiedervorlageDatum = null;
    private JToolBar entsorBearbToolBar = null;
    private JButton entsorgBearbButton = null;
    private JButton saveAnh50Button = null;
    private JComboBox entsorgerBox = null;
    private Anh50Fachdaten fachdaten = null;
    private AnhEntsorger[] entsorg = null;
    private ActionListener editButtonListener;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;

    public Anh50Panel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:70dlu, 5dlu, 90dlu, r:90dlu, 5dlu, 20dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Fachdaten");
        builder.append("Antrag:", (Component)this.getAntragDatum());
        builder.nextLine();
        builder.append("Genehmigung:", (Component)this.getGenehmigungDatum());
        builder.nextLine();
        builder.append("Wiedervorlagen:", (Component)this.getWiedervorlageDatum());
        builder.nextLine();
        builder.append("Gef\u00e4hrdungsklasse:", (Component)this.getGefaehrdungsklasseFeld());
        builder.nextLine();
        builder.append("", (Component)this.getErloschenCheck());
        builder.nextLine();
        builder.appendSeparator("Entsorger");
        builder.append("Entsorger:", (Component)this.getEntsorgerBox(), 2);
        builder.append((Component)this.getEntsorBearbToolBar());
        builder.appendSeparator("Bemerkungen");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane bemerkungsScroller = new JScrollPane(this.getAnh50BemerkungArea(), 20, 31);
        builder.appendRow("fill:30dlu");
        builder.append((Component)bemerkungsScroller, 6);
        builder.appendSeparator("Verkn\u00fcpfte Objekte");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.appendRow("fill:100dlu");
        builder.append((Component)objektverknuepfungScroller, 6);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton(), (JButton)this.getSaveAnh50Button());
        builder.append((Component)buttonBar, 6);
    }

    public void fetchFormData() throws RuntimeException {
        this.fachdaten = Anh50Fachdaten.getAnh50ByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("Zahnarzt aus DB geholt: " + this.fachdaten, "Anh50Panel.fetchFormData");
        if (this.entsorg == null || this.entsorg.length == 0) {
            this.entsorg = AnhEntsorger.getEntsorg();
        }
    }

    public void updateForm() throws RuntimeException {
        if (this.entsorg != null) {
            this.getEntsorgerBox().setModel(new DefaultComboBoxModel<AnhEntsorger>(this.entsorg));
        }
        if (this.fachdaten != null) {
            if (this.fachdaten.getBemerkungen() != null) {
                this.getAnh50BemerkungArea().setText(this.fachdaten.getBemerkungen());
            }
            if (this.fachdaten.getDatumantrag() != null) {
                this.getAntragDatum().setDate(this.fachdaten.getDatumantrag());
            }
            if (this.fachdaten.getGenehmigung() != null) {
                this.getGenehmigungDatum().setDate(this.fachdaten.getGenehmigung());
            }
            if (this.fachdaten.getWiedervorlage() != null) {
                this.getWiedervorlageDatum().setDate(this.fachdaten.getWiedervorlage());
            }
            if (this.fachdaten.getGefaehrdungsklasse() != null) {
                this.getGefaehrdungsklasseFeld().setText(this.fachdaten.getGefaehrdungsklasse().toString());
            }
            if (this.fachdaten.getAnhEntsorger() != null) {
                this.getEntsorgerBox().setSelectedItem(this.fachdaten.getAnhEntsorger());
            }
            if (this.fachdaten.getErloschen() != null) {
                if (this.fachdaten.getErloschen().booleanValue()) {
                    this.getErloschenCheck().setSelected(true);
                } else {
                    this.getErloschenCheck().setSelected(false);
                }
            }
            this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
        }
    }

    public void clearForm() {
        this.getGefaehrdungsklasseFeld().setText(null);
        this.getAnh50BemerkungArea().setText(null);
        this.getAntragDatum().setDate(null);
        this.getGenehmigungDatum().setDate(null);
        this.getWiedervorlageDatum().setDate(null);
        this.getErloschenCheck().setSelected(false);
    }

    public void enableAll(boolean enabled) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    private boolean saveAnh50Daten() {
        String bemerkungen = this.anh50BemerkungArea.getText();
        if ("".equals(bemerkungen)) {
            this.fachdaten.setBemerkungen(null);
        } else {
            this.fachdaten.setBemerkungen(bemerkungen);
        }
        Date antrag = this.antragDatum.getDate();
        this.fachdaten.setDatumantrag(antrag);
        if (this.getErloschenCheck().isSelected()) {
            this.fachdaten.setErloschen(true);
        } else {
            this.fachdaten.setErloschen(false);
        }
        String gefaehrdungsklasse = this.gefaehrdungsklasseFeld.getText();
        if ("".equals(gefaehrdungsklasse)) {
            this.fachdaten.setGefaehrdungsklasse(null);
        } else {
            this.fachdaten.setGefaehrdungsklasse(gefaehrdungsklasse);
        }
        Date genehmigung = this.genehmigungDatum.getDate();
        this.fachdaten.setGenehmigung(genehmigung);
        Date wiedervorlage = this.wiedervorlageDatum.getDate();
        this.fachdaten.setWiedervorlage(wiedervorlage);
        if (this.getEntsorgerBox().getSelectedItem() != null) {
            this.fachdaten.setAnhEntsorger((AnhEntsorger)this.getEntsorgerBox().getSelectedItem());
            AUIKataster.debugOutput("Entsorger " + this.fachdaten.getAnhEntsorger() + " zugeordnet.", "Anh50Panel.saveAnh50Daten");
        } else {
            this.getEntsorgerBox().setSelectedIndex(1);
        }
        this.fachdaten.setAnhEntsorger((AnhEntsorger)this.getEntsorgerBox().getSelectedItem());
        boolean success = Anh50Fachdaten.saveFachdaten(this.fachdaten);
        if (success) {
            AUIKataster.debugOutput("Zahnarzt " + this.fachdaten.getBasisObjekt().getBasisBetreiber().getBetrname() + " gespeichert.", "Anh50Panel.saveAnh50Daten");
        } else {
            AUIKataster.debugOutput("Zahnarzt " + this.fachdaten + " konnte nicht gespeichert werden!", "Anh50Panel.saveAnh50Daten");
        }
        return success;
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.fachdaten == null) {
            this.fachdaten = new Anh50Fachdaten();
            this.fachdaten.setBasisObjekt(this.hauptModul.getObjekt());
            AnhEntsorger entsorg = new AnhEntsorger();
            entsorg.setEntsorgerid(1);
            this.fachdaten.setAnhEntsorger(entsorg);
            Anh50Fachdaten.saveFachdaten(this.fachdaten);
            AUIKataster.debugOutput("Neuer Zahnarzt " + this.fachdaten + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
        }
    }

    private JTextArea getAnh50BemerkungArea() {
        if (this.anh50BemerkungArea == null) {
            this.anh50BemerkungArea = new LimitedTextArea(255);
            this.anh50BemerkungArea.setLineWrap(true);
            this.anh50BemerkungArea.setWrapStyleWord(true);
        }
        return this.anh50BemerkungArea;
    }

    private TextFieldDateChooser getAntragDatum() {
        if (this.antragDatum == null) {
            this.antragDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.antragDatum;
    }

    private JCheckBox getErloschenCheck() {
        if (this.erloschenCheck == null) {
            this.erloschenCheck = new JCheckBox("Erloschen");
        }
        return this.erloschenCheck;
    }

    private JTextField getGefaehrdungsklasseFeld() {
        if (this.gefaehrdungsklasseFeld == null) {
            this.gefaehrdungsklasseFeld = new LimitedTextField(50);
        }
        return this.gefaehrdungsklasseFeld;
    }

    private TextFieldDateChooser getGenehmigungDatum() {
        if (this.genehmigungDatum == null) {
            this.genehmigungDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.genehmigungDatum;
    }

    private TextFieldDateChooser getWiedervorlageDatum() {
        if (this.wiedervorlageDatum == null) {
            this.wiedervorlageDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.wiedervorlageDatum;
    }

    private JComboBox getEntsorgerBox() {
        if (this.entsorgerBox == null) {
            this.entsorgerBox = new JComboBox();
        }
        return this.entsorgerBox;
    }

    private JButton getSaveAnh50Button() {
        if (this.saveAnh50Button == null) {
            this.saveAnh50Button = new JButton("Speichern");
            this.saveAnh50Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Anh50Panel.this.enableAll(false);
                    if (Anh50Panel.this.saveAnh50Daten()) {
                        Anh50Panel.this.hauptModul.getFrame().changeStatus("Zahnarzt " + Anh50Panel.this.fachdaten.getObjektid() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        Anh50Panel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern des Zahnarztes!", HauptFrame.ERROR_COLOR);
                    }
                    Anh50Panel.this.hauptModul.fillForm();
                }
            });
        }
        return this.saveAnh50Button;
    }

    private JButton getEntsorgBearbButton() {
        if (this.entsorgBearbButton == null) {
            this.entsorgBearbButton = new JButton(AuikUtils.getIcon(16, "edit.png", ""));
            this.entsorgBearbButton.setHorizontalAlignment(0);
            this.entsorgBearbButton.setToolTipText("Entsorger bearbeiten");
            this.entsorgBearbButton.setActionCommand("entsorger_edit");
            this.entsorgBearbButton.addActionListener(this.getEditButtonListener());
        }
        return this.entsorgBearbButton;
    }

    private JToolBar getEntsorBearbToolBar() {
        if (this.entsorBearbToolBar == null) {
            this.entsorBearbToolBar = new JToolBar();
            this.entsorBearbToolBar.setFloatable(false);
            this.entsorBearbToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            this.entsorBearbToolBar.add(this.getEntsorgBearbButton());
        }
        return this.entsorBearbToolBar;
    }

    private ActionListener getEditButtonListener() {
        if (this.editButtonListener == null) {
            this.editButtonListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String action = e.getActionCommand();
                    AnhEntsorger entsorg = (AnhEntsorger)Anh50Panel.this.getEntsorgerBox().getSelectedItem();
                    if ("entsorger_edit".equals(action) && entsorg != null) {
                        EntsorgerEditor editDialog = new EntsorgerEditor(entsorg, Anh50Panel.this.hauptModul.getFrame());
                        editDialog.setLocationRelativeTo(Anh50Panel.this.hauptModul.getFrame());
                        editDialog.setVisible(true);
                        editDialog.setEnabled(true);
                        entsorg = editDialog.getEntsorger();
                    }
                }
            };
        }
        return this.editButtonListener;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = Anh50Panel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = Anh50Panel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != Anh50Panel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                Anh50Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                Anh50Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            Anh50Panel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Anh50Panel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Anh50Panel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = Anh50Panel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && Anh50Panel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = Anh50Panel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(Anh50Panel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (Anh50Panel.this.objektVerknuepfungModel.removeRow(row)) {
                                Anh50Panel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                Anh50Panel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(Anh50Panel.this.hauptModul.getFrame(), Anh50Panel.this.fachdaten.getBasisObjekt(), Anh50Panel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }
}

