/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Fachdaten;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Anh49Panel
extends JPanel {
    private String name = "Anhang 49";
    private BasisObjektBearbeiten hauptModul;
    private JTextField sachbearbeiterFeld = null;
    private JTextField ansprechpartnerFeld = null;
    private JTextField sachkundelfaFeld = null;
    private JFormattedTextField durchgefuehrtFeld = null;
    private TextFieldDateChooser wannDatum = null;
    private JTextField analyseMonatFeld = null;
    private JFormattedTextField dekraTuevFeld = null;
    private JCheckBox mangelCheck = null;
    private JCheckBox behobenCheck = null;
    private TextFieldDateChooser fristDatum = null;
    private TextFieldDateChooser antragDatum = null;
    private TextFieldDateChooser genehmigungDatum = null;
    private TextFieldDateChooser aenderungDatum = null;
    private TextFieldDateChooser letzteAenderDatum = null;
    private JTextField anschreibenFeld = null;
    private TextFieldDateChooser wiedervorlageDatum = null;
    private JCheckBox abgemeldetCheck = null;
    private JCheckBox abwasserfreiCheck = null;
    private JCheckBox waschanlageCheck = null;
    private JCheckBox eSatzungCheck = null;
    private JTextArea anh49BemerkungArea = null;
    private JButton saveAnh49Button = null;
    private Anh49Fachdaten fachdaten = null;
    private ActionListener editButtonListener;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;

    public Anh49Panel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:50dlu, 5dlu, 90dlu, 10dlu, r:50dlu, 5dlu, 70dlu", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 5dlu, fill:100dlu, 5dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Bearbeitung", cc.xyw(1, 1, 3));
        builder.addLabel("Sachbearb.:", cc.xy(1, 3));
        builder.add((Component)this.getSachbearbeiterFeld(), cc.xy(3, 3));
        builder.addLabel("Ansprechpar.:", cc.xy(1, 5));
        builder.add((Component)this.getAnsprechpartnerFeld(), cc.xy(3, 5));
        builder.addLabel("Sachkde LFA:", cc.xy(1, 7));
        builder.add((Component)this.getSachkundelfaFeld(), cc.xy(3, 7));
        builder.addSeparator("Analyse", cc.xyw(1, 9, 3));
        builder.addLabel("Analyse dgft:", cc.xy(1, 11));
        builder.add((Component)this.getDurchgefuehrtFeld(), cc.xy(3, 11));
        builder.addLabel("wann:", cc.xy(1, 13));
        builder.add((Component)this.getWannDatum(), cc.xy(3, 13));
        builder.addLabel("Analysemonat:", cc.xy(1, 15));
        builder.add((Component)this.getAnalyseMonatFeld(), cc.xy(3, 15));
        builder.addSeparator("Kontrolle", cc.xyw(1, 17, 3));
        builder.addLabel("Dekra/T\u00dcV-T.:", cc.xy(1, 19));
        builder.add((Component)this.getDekraTuevFeld(), cc.xy(3, 19));
        builder.addLabel("Wiedervorlage:", cc.xy(1, 21));
        builder.add((Component)this.getWiedervorlageDatum(), cc.xy(3, 21));
        builder.add((Component)this.getMangelCheck(), cc.xy(3, 23));
        builder.addLabel("Frist:", cc.xy(1, 25));
        builder.add((Component)this.getFristDatum(), cc.xy(3, 25));
        builder.addSeparator("Erfassung", cc.xyw(5, 1, 3));
        builder.addLabel("Antrag vom:", cc.xy(5, 3));
        builder.add((Component)this.getAntragDatum(), cc.xy(7, 3));
        builder.addLabel("Genehmigung:", cc.xy(5, 5));
        builder.add((Component)this.getGenehmigungDatum(), cc.xy(7, 5));
        builder.addLabel("\u00c4nderungsgen.:", cc.xy(5, 7));
        builder.add((Component)this.getAenderungDatum(), cc.xy(7, 7));
        builder.addLabel("letzte \u00c4nder.:", cc.xy(5, 9));
        builder.add((Component)this.getLetzteAenderDatum(), cc.xy(7, 9));
        builder.addLabel("Anschreiben:", cc.xy(5, 11));
        builder.add((Component)this.getAnschreibenFeld(), cc.xy(7, 11));
        builder.add((Component)this.getAbgemeldetCheck(), cc.xy(5, 13, "l,d"));
        builder.add((Component)this.getAbwasserfreiCheck(), cc.xy(7, 13));
        builder.add((Component)this.getWaschanlageCheck(), cc.xy(5, 15, "l,d"));
        builder.add((Component)this.getESatzungCheck(), cc.xy(7, 15));
        builder.addSeparator("Bemerkungen", cc.xyw(5, 17, 3));
        JScrollPane bemerkungsScroller = new JScrollPane(this.getAnh49BemerkungArea(), 20, 31);
        builder.add((Component)bemerkungsScroller, cc.xywh(5, 19, 3, 7));
        builder.addSeparator("Verkn\u00fcpfte Objekte", cc.xyw(1, 27, 7));
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.appendRow("fill:100dlu");
        builder.add((Component)objektverknuepfungScroller, cc.xyw(1, 29, 7));
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton(), (JButton)this.getSaveAnh49Button());
        builder.add((Component)buttonBar, cc.xyw(1, 31, 7));
    }

    public void fetchFormData() {
        this.fachdaten = Anh49Fachdaten.getAnh49ByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("Anhang 49 Objekt aus DB geholt: " + this.fachdaten, "Anh49Panel.fetchFormData");
    }

    public void updateForm() {
        if (this.fachdaten != null) {
            if (this.fachdaten.getAbgemeldet() != null) {
                if (this.fachdaten.getAbgemeldet().booleanValue()) {
                    this.getAbgemeldetCheck().setSelected(true);
                } else {
                    this.getAbgemeldetCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getAbwasserfrei() != null) {
                if (this.fachdaten.getAbwasserfrei().booleanValue()) {
                    this.getAbwasserfreiCheck().setSelected(true);
                } else {
                    this.getAbwasserfreiCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getAenderungsgenehmigung() != null) {
                this.getAenderungDatum().setDate(this.fachdaten.getAenderungsgenehmigung());
            }
            if (this.fachdaten.getAnalysemonat() != null) {
                this.getAnalyseMonatFeld().setText(this.fachdaten.getAnalysemonat());
            }
            if (this.fachdaten.getBemerkungen() != null) {
                this.getAnh49BemerkungArea().setText(this.fachdaten.getBemerkungen());
            }
            if (this.fachdaten.getAnschreiben() != null) {
                this.getAnschreibenFeld().setText(this.fachdaten.getAnschreiben());
            }
            if (this.fachdaten.getWiedervorlage() != null) {
                this.getWiedervorlageDatum().setDate(this.fachdaten.getWiedervorlage());
            }
            if (this.fachdaten.getAnsprechpartnerIn() != null) {
                this.getAnsprechpartnerFeld().setText(this.fachdaten.getAnsprechpartnerIn().toString());
            }
            if (this.fachdaten.getAntragvom() != null) {
                this.getAntragDatum().setDate(this.fachdaten.getAntragvom());
            }
            if (this.fachdaten.getBehoben() != null) {
                if (this.fachdaten.getBehoben().booleanValue()) {
                    this.getBehobenCheck().setSelected(true);
                } else {
                    this.getBehobenCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getDekraTuevTermin() != null) {
                this.getDekraTuevFeld().setText(this.fachdaten.getDekraTuevTermin().toString());
            }
            if (this.fachdaten.getDurchgefuehrt() != null) {
                this.getDurchgefuehrtFeld().setText(this.fachdaten.getDurchgefuehrt().toString());
            }
            if (this.fachdaten.getESatzung() != null) {
                if (this.fachdaten.getESatzung().booleanValue()) {
                    this.getESatzungCheck().setSelected(true);
                } else {
                    this.getESatzungCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getFrist() != null) {
                this.getFristDatum().setDate(this.fachdaten.getFrist());
            }
            if (this.fachdaten.getGenehmigung() != null) {
                this.getGenehmigungDatum().setDate(this.fachdaten.getGenehmigung());
            }
            if (this.fachdaten.getLetztesAnschreiben() != null) {
                this.getLetzteAenderDatum().setDate(this.fachdaten.getLetztesAnschreiben());
            }
            if (this.fachdaten.getMaengel() != null) {
                if (this.fachdaten.getMaengel().booleanValue()) {
                    this.getMangelCheck().setSelected(true);
                } else {
                    this.getMangelCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getSachbearbeiterIn() != null) {
                this.getSachbearbeiterFeld().setText(this.fachdaten.getSachbearbeiterIn());
            }
            if (this.fachdaten.getSachkundelfa() != null) {
                this.getSachkundelfaFeld().setText(this.fachdaten.getSachkundelfa());
            }
            if (this.fachdaten.getSeitwann() != null) {
                this.getWannDatum().setDate(this.fachdaten.getSeitwann());
            }
            if (this.fachdaten.getWaschanlage() != null) {
                if (this.fachdaten.getWaschanlage().booleanValue()) {
                    this.getWaschanlageCheck().setSelected(true);
                } else {
                    this.getWaschanlageCheck().setSelected(false);
                }
            }
            this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
        } else {
            this.enableAll(false);
            this.hauptModul.getFrame().changeStatus("FEHLER: Kein Anhang 49 Objekt gefunden!", HauptFrame.ERROR_COLOR);
        }
    }

    public void clearForm() {
        this.getAbgemeldetCheck().setSelected(false);
        this.getAbwasserfreiCheck().setSelected(false);
        this.getAenderungDatum().setDate(null);
        this.getAnalyseMonatFeld().setText(null);
        this.getAnh49BemerkungArea().setText(null);
        this.getAnschreibenFeld().setText(null);
        this.getWiedervorlageDatum().setDate(null);
        this.getAnsprechpartnerFeld().setText(null);
        this.getAntragDatum().setDate(null);
        this.getBehobenCheck().setSelected(false);
        this.getDekraTuevFeld().setText(null);
        this.getDurchgefuehrtFeld().setText(null);
        this.getESatzungCheck().setSelected(false);
        this.getFristDatum().setDate(null);
        this.getGenehmigungDatum().setDate(null);
        this.getLetzteAenderDatum().setDate(null);
        this.getMangelCheck().setSelected(false);
        this.getSachbearbeiterFeld().setText(null);
        this.getSachkundelfaFeld().setText(null);
        this.getWannDatum().setDate(null);
        this.getWaschanlageCheck().setSelected(false);
    }

    public void enableAll(boolean enabled) {
        if (!enabled || this.fachdaten != null) {
            this.getAbgemeldetCheck().setEnabled(enabled);
            this.getAbwasserfreiCheck().setEnabled(enabled);
            this.getAenderungDatum().setEnabled(enabled);
            this.getAnalyseMonatFeld().setEnabled(enabled);
            this.getAnh49BemerkungArea().setEnabled(enabled);
            this.getAnschreibenFeld().setEnabled(enabled);
            this.getWiedervorlageDatum().setEnabled(enabled);
            this.getAnsprechpartnerFeld().setEnabled(enabled);
            this.getAntragDatum().setEnabled(enabled);
            this.getBehobenCheck().setEnabled(enabled);
            this.getDekraTuevFeld().setEnabled(enabled);
            this.getDurchgefuehrtFeld().setEnabled(enabled);
            this.getESatzungCheck().setEnabled(enabled);
            this.getFristDatum().setEnabled(enabled);
            this.getGenehmigungDatum().setEnabled(enabled);
            this.getLetzteAenderDatum().setEnabled(enabled);
            this.getMangelCheck().setEnabled(enabled);
            this.getSachbearbeiterFeld().setEnabled(enabled);
            this.getSachkundelfaFeld().setEnabled(enabled);
            this.getWannDatum().setEnabled(enabled);
            this.getWaschanlageCheck().setEnabled(enabled);
            this.getSaveAnh49Button().setEnabled(enabled);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Anh49Fachdaten getFachdaten() {
        return this.fachdaten;
    }

    private boolean saveAnh49Daten() {
        if (this.getAbgemeldetCheck().isSelected()) {
            this.fachdaten.setAbgemeldet(true);
        } else {
            this.fachdaten.setAbgemeldet(false);
        }
        if (this.getAbwasserfreiCheck().isSelected()) {
            this.fachdaten.setAbwasserfrei(true);
        } else {
            this.fachdaten.setAbwasserfrei(false);
        }
        String analysemnt = this.analyseMonatFeld.getText();
        if ("".equals(analysemnt)) {
            this.fachdaten.setAnalysemonat(null);
        } else {
            this.fachdaten.setAnalysemonat(analysemnt);
        }
        String bemerkungen = this.anh49BemerkungArea.getText();
        if ("".equals(bemerkungen)) {
            this.fachdaten.setBemerkungen(null);
        } else {
            this.fachdaten.setBemerkungen(bemerkungen);
        }
        String anschreiben = this.anschreibenFeld.getText();
        if ("".equals(anschreiben)) {
            this.fachdaten.setAnschreiben(null);
        } else {
            this.fachdaten.setAnschreiben(anschreiben);
        }
        Date wiedervorlage = this.wiedervorlageDatum.getDate();
        this.fachdaten.setWiedervorlage(wiedervorlage);
        String ansprechpartner = this.ansprechpartnerFeld.getText();
        if ("".equals(ansprechpartner)) {
            this.fachdaten.setAnsprechpartnerIn(null);
        } else {
            this.fachdaten.setAnsprechpartnerIn(ansprechpartner);
        }
        if (this.getBehobenCheck().isSelected()) {
            this.fachdaten.setBehoben(true);
        } else {
            this.fachdaten.setBehoben(false);
        }
        Integer dekratuev = ((IntegerField)this.dekraTuevFeld).getIntValue();
        this.fachdaten.setDekraTuevTermin(dekratuev);
        Integer durchgefuehrt = ((IntegerField)this.durchgefuehrtFeld).getIntValue();
        this.fachdaten.setDurchgefuehrt(durchgefuehrt);
        if (this.getESatzungCheck().isSelected()) {
            this.fachdaten.setESatzung(true);
        } else {
            this.fachdaten.setESatzung(false);
        }
        Date frist = this.fristDatum.getDate();
        this.fachdaten.setFrist(frist);
        Date antrag = this.antragDatum.getDate();
        this.fachdaten.setAntragvom(antrag);
        Date genehmigung = this.genehmigungDatum.getDate();
        this.fachdaten.setGenehmigung(genehmigung);
        Date aenderung = this.aenderungDatum.getDate();
        this.fachdaten.setAenderungsgenehmigung(aenderung);
        Date letzteaend = this.letzteAenderDatum.getDate();
        this.fachdaten.setLetztesAnschreiben(letzteaend);
        if (this.getMangelCheck().isSelected()) {
            this.fachdaten.setMaengel(true);
        } else {
            this.fachdaten.setMaengel(false);
        }
        String sachbearbeiter = this.sachbearbeiterFeld.getText();
        if ("".equals(sachbearbeiter)) {
            this.fachdaten.setSachbearbeiterIn(null);
        } else {
            this.fachdaten.setSachbearbeiterIn(sachbearbeiter);
        }
        String sachkunde = this.sachkundelfaFeld.getText();
        if ("".equals(sachkunde)) {
            this.fachdaten.setSachkundelfa(null);
        } else {
            this.fachdaten.setSachkundelfa(sachkunde);
        }
        Date wann = this.wannDatum.getDate();
        this.fachdaten.setSeitwann(wann);
        if (this.getWaschanlageCheck().isSelected()) {
            this.fachdaten.setWaschanlage(true);
        } else {
            this.fachdaten.setWaschanlage(false);
        }
        boolean success = Anh49Fachdaten.saveFachdaten(this.fachdaten);
        if (!success) {
            AUIKataster.debugOutput("Anh49 Objekt " + this.fachdaten + " konnte nicht gespeichert werden!", "Anh50Panel.saveAnh49Daten");
        }
        return success;
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.fachdaten == null) {
            this.fachdaten = new Anh49Fachdaten();
            this.fachdaten.setBasisObjekt(this.hauptModul.getObjekt());
            Anh49Fachdaten.saveFachdaten(this.fachdaten);
            AUIKataster.debugOutput("Neues Anh49 Objekt " + this.fachdaten + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
        }
    }

    private JCheckBox getAbgemeldetCheck() {
        if (this.abgemeldetCheck == null) {
            this.abgemeldetCheck = new JCheckBox("abgemeldet");
        }
        return this.abgemeldetCheck;
    }

    private JCheckBox getAbwasserfreiCheck() {
        if (this.abwasserfreiCheck == null) {
            this.abwasserfreiCheck = new JCheckBox("abwasserfrei");
        }
        return this.abwasserfreiCheck;
    }

    private TextFieldDateChooser getAenderungDatum() {
        if (this.aenderungDatum == null) {
            this.aenderungDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.aenderungDatum;
    }

    private JTextField getAnalyseMonatFeld() {
        if (this.analyseMonatFeld == null) {
            this.analyseMonatFeld = new LimitedTextField(50);
        }
        return this.analyseMonatFeld;
    }

    private JTextArea getAnh49BemerkungArea() {
        if (this.anh49BemerkungArea == null) {
            this.anh49BemerkungArea = new LimitedTextArea(150);
            this.anh49BemerkungArea.setLineWrap(true);
            this.anh49BemerkungArea.setWrapStyleWord(true);
        }
        return this.anh49BemerkungArea;
    }

    private JTextField getAnschreibenFeld() {
        if (this.anschreibenFeld == null) {
            this.anschreibenFeld = new LimitedTextField(50);
        }
        return this.anschreibenFeld;
    }

    private TextFieldDateChooser getWiedervorlageDatum() {
        if (this.wiedervorlageDatum == null) {
            this.wiedervorlageDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.wiedervorlageDatum;
    }

    private JTextField getAnsprechpartnerFeld() {
        if (this.ansprechpartnerFeld == null) {
            this.ansprechpartnerFeld = new LimitedTextField(50);
        }
        return this.ansprechpartnerFeld;
    }

    private TextFieldDateChooser getAntragDatum() {
        if (this.antragDatum == null) {
            this.antragDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.antragDatum;
    }

    private JCheckBox getBehobenCheck() {
        if (this.behobenCheck == null) {
            this.behobenCheck = new JCheckBox();
        }
        return this.behobenCheck;
    }

    private JFormattedTextField getDekraTuevFeld() {
        if (this.dekraTuevFeld == null) {
            this.dekraTuevFeld = new IntegerField();
        }
        return this.dekraTuevFeld;
    }

    private JFormattedTextField getDurchgefuehrtFeld() {
        if (this.durchgefuehrtFeld == null) {
            this.durchgefuehrtFeld = new IntegerField();
        }
        return this.durchgefuehrtFeld;
    }

    private JCheckBox getESatzungCheck() {
        if (this.eSatzungCheck == null) {
            this.eSatzungCheck = new JCheckBox("E-Satzung");
        }
        return this.eSatzungCheck;
    }

    private TextFieldDateChooser getFristDatum() {
        if (this.fristDatum == null) {
            this.fristDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.fristDatum;
    }

    private TextFieldDateChooser getGenehmigungDatum() {
        if (this.genehmigungDatum == null) {
            this.genehmigungDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.genehmigungDatum;
    }

    private TextFieldDateChooser getLetzteAenderDatum() {
        if (this.letzteAenderDatum == null) {
            this.letzteAenderDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.letzteAenderDatum;
    }

    private JCheckBox getMangelCheck() {
        if (this.mangelCheck == null) {
            this.mangelCheck = new JCheckBox("Mangel");
        }
        return this.mangelCheck;
    }

    private JTextField getSachbearbeiterFeld() {
        if (this.sachbearbeiterFeld == null) {
            this.sachbearbeiterFeld = new LimitedTextField(50);
        }
        return this.sachbearbeiterFeld;
    }

    private JTextField getSachkundelfaFeld() {
        if (this.sachkundelfaFeld == null) {
            this.sachkundelfaFeld = new LimitedTextField(50);
        }
        return this.sachkundelfaFeld;
    }

    private TextFieldDateChooser getWannDatum() {
        if (this.wannDatum == null) {
            this.wannDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.wannDatum;
    }

    private JCheckBox getWaschanlageCheck() {
        if (this.waschanlageCheck == null) {
            this.waschanlageCheck = new JCheckBox("Waschanlage");
        }
        return this.waschanlageCheck;
    }

    private JButton getSaveAnh49Button() {
        if (this.saveAnh49Button == null) {
            this.saveAnh49Button = new JButton("Speichern");
            this.saveAnh49Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Anh49Panel.this.enableAll(false);
                    if (Anh49Panel.this.saveAnh49Daten()) {
                        Anh49Panel.this.hauptModul.getFrame().changeStatus("Anhang 49-Objekt erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        Anh49Panel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern des Objekts!", HauptFrame.ERROR_COLOR);
                    }
                    Anh49Panel.this.hauptModul.fillForm();
                }
            });
        }
        return this.saveAnh49Button;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = Anh49Panel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = Anh49Panel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != Anh49Panel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                Anh49Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                Anh49Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            Anh49Panel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Anh49Panel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Anh49Panel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = Anh49Panel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && Anh49Panel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = Anh49Panel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(Anh49Panel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (Anh49Panel.this.objektVerknuepfungModel.removeRow(row)) {
                                Anh49Panel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                Anh49Panel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(Anh49Panel.this.hauptModul.getFrame(), Anh49Panel.this.fachdaten.getBasisObjekt(), Anh49Panel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }
}

