/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif_lite.component.Factory;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Abscheiderdetails;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Fachdaten;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Ortstermine;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.editors.AbscheiderEditor;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.SelectTable;
import de.bielefeld.umweltamt.aui.utils.TabAction;
import de.bielefeld.umweltamt.aui.utils.TableFocusListener;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.EditableListTableModel;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class Anh49DetailsPanel
extends JPanel {
    private String name = "Abscheider-Details";
    private BasisObjektBearbeiten hauptModul;
    private Anh49Fachdaten fachdaten;
    private Anh49AbscheiderModel abscheiderModel;
    private Anh49OrtsterminModel ortsterminModel;
    private JTable abscheiderTabelle;
    private Action abscheiderLoeschAction;
    private Action abscheiderNeuAction;
    private JPopupMenu abscheiderPopup;
    private JTable ortsterminTabelle;
    private Action ortsterminLoeschenAction;
    private JPopupMenu ortsterminPopup;
    private JButton speichernButton;

    public Anh49DetailsPanel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        this.abscheiderModel = new Anh49AbscheiderModel();
        this.ortsterminModel = new Anh49OrtsterminModel();
        TableFocusListener tfl = TableFocusListener.getInstance();
        this.getAbscheiderTabelle().addFocusListener(tfl);
        JScrollPane abscheiderScroller = new JScrollPane(this.getAbscheiderTabelle(), 20, 31);
        JScrollPane ortsterminScroller = new JScrollPane(this.getOrtsterminTabelle(), 20, 31);
        abscheiderScroller.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Anh49DetailsPanel.this.showAbscheiderPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Anh49DetailsPanel.this.showAbscheiderPopup(e);
            }
        });
        TabAction ta = new TabAction();
        ta.addComp(this.getAbscheiderTabelle());
        ta.addComp(this.getOrtsterminTabelle());
        JSplitPane tabellenSplit = Factory.createStrippedSplitPane(0, abscheiderScroller, ortsterminScroller, 0.5);
        FormLayout layout = new FormLayout("150dlu:grow, 100dlu", "100dlu:grow, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.add((Component)tabellenSplit, cc.xyw(1, 1, 2));
        builder.add((Component)this.getSpeichernButton(), cc.xy(2, 3));
    }

    private Action getAbscheiderLoeschAction() {
        if (this.abscheiderLoeschAction == null) {
            this.abscheiderLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = Anh49DetailsPanel.this.getAbscheiderTabelle().getSelectedRow();
                    if (row != -1 && Anh49DetailsPanel.this.getAbscheiderTabelle().getEditingRow() == -1) {
                        Anh49Abscheiderdetails abscheider = Anh49DetailsPanel.this.abscheiderModel.getRow(row);
                        if (Anh49DetailsPanel.this.hauptModul.getFrame().showQuestion("Soll der Abscheider " + abscheider + " wirklich inkl. aller Detailinformationen gel\u00f6scht werden?", "L\u00f6schen best\u00e4tigen")) {
                            Anh49DetailsPanel.this.abscheiderModel.removeRow(row);
                            AUIKataster.debugOutput("Abscheider " + abscheider.getLage() + " wurde gel\u00f6scht!");
                        } else {
                            AUIKataster.debugOutput("L\u00f6schen von " + abscheider.getLage() + " wurde abgebrochen!");
                        }
                    }
                }
            };
            this.abscheiderLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.abscheiderLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.abscheiderLoeschAction;
    }

    private Action getAbscheiderNeuAction() {
        if (this.abscheiderNeuAction == null) {
            this.abscheiderNeuAction = new AbstractAction("Neuer Abscheider"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Anh49Abscheiderdetails neuerAbscheider = new Anh49Abscheiderdetails();
                    neuerAbscheider.setAnh49Fachdaten(Anh49DetailsPanel.this.fachdaten);
                    Anh49DetailsPanel.this.editAbscheider(neuerAbscheider);
                }
            };
            this.abscheiderNeuAction.putValue("MnemonicKey", new Integer(78));
        }
        return this.abscheiderNeuAction;
    }

    public void editAbscheider(Anh49Abscheiderdetails absch) {
        AbscheiderEditor editDialog = new AbscheiderEditor(absch, this.hauptModul.getFrame());
        editDialog.setLocationRelativeTo(this.hauptModul.getFrame());
        editDialog.setVisible(true);
        if (editDialog.wasSaved() && editDialog.getDetails() != null) {
            this.abscheiderModel.updateList();
            Anh49Abscheiderdetails details = editDialog.getDetails();
            int row = this.abscheiderModel.getList().indexOf(details);
            if (row != -1) {
                this.getAbscheiderTabelle().setRowSelectionInterval(row, row);
                this.getAbscheiderTabelle().scrollRectToVisible(this.getAbscheiderTabelle().getCellRect(row, 0, true));
            }
        }
    }

    private void showAbscheiderPopup(MouseEvent e) {
        if (this.abscheiderPopup == null) {
            this.abscheiderPopup = new JPopupMenu("Abscheider");
            JMenuItem loeschItem = new JMenuItem(this.getAbscheiderLoeschAction());
            this.abscheiderPopup.add(loeschItem);
            JMenuItem neuItem = new JMenuItem(this.getAbscheiderNeuAction());
            this.abscheiderPopup.add(neuItem);
        }
        if (e.isPopupTrigger()) {
            Point origin = e.getPoint();
            int row = this.abscheiderTabelle.rowAtPoint(origin);
            if (row != -1) {
                this.getAbscheiderLoeschAction().setEnabled(true);
                this.abscheiderTabelle.setRowSelectionInterval(row, row);
            } else {
                this.getAbscheiderLoeschAction().setEnabled(false);
            }
            this.abscheiderPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getOrtsterminLoeschAction() {
        if (this.ortsterminLoeschenAction == null) {
            this.ortsterminLoeschenAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Anh49Ortstermine ot;
                    int row = Anh49DetailsPanel.this.getOrtsterminTabelle().getSelectedRow();
                    if (row != -1 && Anh49DetailsPanel.this.getOrtsterminTabelle().getEditingRow() == -1 && (ot = Anh49DetailsPanel.this.ortsterminModel.getRow(row)) != null) {
                        if (Anh49DetailsPanel.this.hauptModul.getFrame().showQuestion("Soll der Ortstermin " + ot + " gel\u00f6scht werden?", "L\u00f6schen best\u00e4tigen")) {
                            Anh49DetailsPanel.this.ortsterminModel.removeRow(row);
                            AUIKataster.debugOutput("Ortstermin " + ot.getOrtsterminid() + " wurde gel\u00f6scht!");
                        } else {
                            AUIKataster.debugOutput("L\u00f6schen von " + ot.getOrtsterminid() + " wurde abgebrochen!");
                        }
                    }
                }
            };
            this.ortsterminLoeschenAction.putValue("MnemonicKey", new Integer(76));
            this.ortsterminLoeschenAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.ortsterminLoeschenAction;
    }

    private void showOrtsterminPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.ortsterminPopup == null) {
            this.ortsterminPopup = new JPopupMenu("Ortstermin");
            JMenuItem loeschItem = new JMenuItem(this.getOrtsterminLoeschAction());
            this.ortsterminPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.ortsterminTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.ortsterminTabelle.setRowSelectionInterval(row, row);
            if (row < this.ortsterminModel.getList().size()) {
                this.getOrtsterminLoeschAction().setEnabled(true);
            } else {
                this.getOrtsterminLoeschAction().setEnabled(false);
            }
            this.ortsterminPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private JTable getAbscheiderTabelle() {
        if (this.abscheiderTabelle == null) {
            this.abscheiderTabelle = new JTable(this.abscheiderModel);
            this.abscheiderTabelle.setAutoResizeMode(1);
            this.abscheiderTabelle.setSelectionMode(0);
            this.abscheiderTabelle.setColumnSelectionAllowed(false);
            DefaultTableCellRenderer centeredRenderer = new DefaultTableCellRenderer();
            centeredRenderer.setHorizontalAlignment(0);
            TableColumn column = null;
            for (int i = 0; i < this.abscheiderTabelle.getColumnCount(); ++i) {
                column = this.abscheiderTabelle.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setCellRenderer(centeredRenderer);
                    column.setMaxWidth(100);
                    column.setPreferredWidth(75);
                    continue;
                }
                if (i != 1) continue;
                column.setCellRenderer(centeredRenderer);
                column.setMaxWidth(80);
                column.setPreferredWidth(60);
            }
            this.abscheiderTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = Anh49DetailsPanel.this.abscheiderTabelle.rowAtPoint(origin);
                        if (row != -1) {
                            Anh49Abscheiderdetails absch = (Anh49Abscheiderdetails)Anh49DetailsPanel.this.abscheiderModel.getObjectAtRow(row);
                            AUIKataster.debugOutput("Doppelklick auf: " + absch, "Anh49DetailsPanel.abscheiderTabelle");
                            Anh49DetailsPanel.this.editAbscheider(absch);
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Anh49DetailsPanel.this.showAbscheiderPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Anh49DetailsPanel.this.showAbscheiderPopup(e);
                }
            });
            this.abscheiderTabelle.getInputMap().put((KeyStroke)this.getAbscheiderLoeschAction().getValue("AcceleratorKey"), this.getAbscheiderLoeschAction().getValue("Name"));
            this.abscheiderTabelle.getActionMap().put(this.getAbscheiderLoeschAction().getValue("Name"), this.getAbscheiderLoeschAction());
        }
        return this.abscheiderTabelle;
    }

    private JTable getOrtsterminTabelle() {
        if (this.ortsterminTabelle == null) {
            this.ortsterminTabelle = new SelectTable(this.ortsterminModel);
            this.ortsterminTabelle.setAutoResizeMode(1);
            TableColumn column = null;
            for (int i = 0; i < this.ortsterminTabelle.getColumnCount(); ++i) {
                column = this.ortsterminTabelle.getColumnModel().getColumn(i);
                if (i != 0) continue;
                column.setMaxWidth(100);
                column.setPreferredWidth(75);
            }
            this.ortsterminTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Anh49DetailsPanel.this.showOrtsterminPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Anh49DetailsPanel.this.showOrtsterminPopup(e);
                }
            });
            this.ortsterminTabelle.getInputMap().put((KeyStroke)this.getOrtsterminLoeschAction().getValue("AcceleratorKey"), this.getOrtsterminLoeschAction().getValue("Name"));
            this.ortsterminTabelle.getActionMap().put(this.getOrtsterminLoeschAction().getValue("Name"), this.getOrtsterminLoeschAction());
        }
        return this.ortsterminTabelle;
    }

    public void speichernOrtstermin() {
        List otListe = this.ortsterminModel.getList();
        for (int i = 0; i < otListe.size(); ++i) {
            Anh49Ortstermine ot = (Anh49Ortstermine)otListe.get(i);
            Anh49Ortstermine.saveOrUpdateOrtstermin(ot);
        }
        this.ortsterminModel.updateList();
    }

    public void setFachdaten(Anh49Fachdaten fachdaten) {
        this.fachdaten = fachdaten;
    }

    public void updateForm() {
        if (this.fachdaten != null) {
            this.abscheiderModel.setFachdaten(this.fachdaten);
            this.ortsterminModel.setFachdaten(this.fachdaten);
        }
    }

    public void clearForm() {
        this.abscheiderModel.setList(new ArrayList());
        this.ortsterminModel.setList(new ArrayList());
    }

    public void enableAll(boolean enabled) {
        if (!enabled || this.fachdaten != null) {
            this.getAbscheiderTabelle().setEnabled(enabled);
            this.getOrtsterminTabelle().setEnabled(enabled);
            this.getSpeichernButton().setEnabled(enabled);
            this.getAbscheiderLoeschAction().setEnabled(enabled);
            this.getAbscheiderNeuAction().setEnabled(enabled);
            this.getOrtsterminLoeschAction().setEnabled(enabled);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private JButton getSpeichernButton() {
        if (this.speichernButton == null) {
            this.speichernButton = new JButton("Ortstermine speichern");
            this.speichernButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Anh49DetailsPanel.this.speichernOrtstermin();
                }
            });
        }
        return this.speichernButton;
    }

    private class Anh49OrtsterminModel
    extends EditableListTableModel {
        private Anh49Fachdaten fachdaten;

        public Anh49OrtsterminModel() {
            super(new String[]{"Datum", "SachbearbeiterIn", "Bemerkung"}, false, true);
        }

        private void setFachdaten(Anh49Fachdaten fachdaten) {
            this.fachdaten = fachdaten;
            this.updateList();
        }

        @Override
        public Object getColumnValue(Object objectAtRow, int columnIndex) {
            String tmp;
            Anh49Ortstermine ot = (Anh49Ortstermine)objectAtRow;
            switch (columnIndex) {
                case 0: {
                    tmp = AuikUtils.getStringFromDate(ot.getDatum());
                    break;
                }
                case 1: {
                    tmp = ot.getSachbearbeiterIn();
                    break;
                }
                case 2: {
                    tmp = ot.getBemerkungen();
                    break;
                }
                default: {
                    tmp = null;
                }
            }
            return tmp;
        }

        @Override
        public boolean objectRemoved(Object objectAtRow) {
            Anh49Ortstermine removedOt = (Anh49Ortstermine)objectAtRow;
            boolean removed = removedOt.getOrtsterminid() != null ? Anh49Ortstermine.removeOrtstermin(removedOt) : true;
            return removed;
        }

        @Override
        public void updateList() {
            if (this.fachdaten != null) {
                this.setList(Anh49Ortstermine.getOrtstermine(this.fachdaten));
            }
            this.fireTableDataChanged();
        }

        @Override
        public void editObject(Object objectAtRow, int columnIndex, Object newValue) {
            Anh49Ortstermine ot = (Anh49Ortstermine)objectAtRow;
            String tmp = (String)newValue;
            switch (columnIndex) {
                case 0: {
                    DateFormat format = DateFormat.getDateInstance(3);
                    try {
                        Date tmpDate = format.parse(tmp);
                        ot.setDatum(tmpDate);
                    }
                    catch (ParseException e) {
                        Anh49DetailsPanel.this.hauptModul.getFrame().changeStatus("Bitte geben Sie das Datum in der Form MM.TT.JJJJ ein!", HauptFrame.ERROR_COLOR);
                    }
                    break;
                }
                case 1: {
                    if (tmp.length() > 50) {
                        tmp = tmp.substring(0, 50);
                    }
                    ot.setSachbearbeiterIn(tmp);
                    break;
                }
                case 2: {
                    if (tmp.length() > 255) {
                        tmp = tmp.substring(0, 255);
                    }
                    ot.setBemerkungen(tmp);
                    break;
                }
            }
        }

        @Override
        public Object newObject() {
            Anh49Ortstermine ot = new Anh49Ortstermine();
            ot.setAnh49Fachdaten(this.fachdaten);
            ot.setDatum(new Date());
            return ot;
        }

        public Anh49Ortstermine getRow(int rowIndex) {
            return (Anh49Ortstermine)this.getObjectAtRow(rowIndex);
        }
    }

    private class Anh49AbscheiderModel
    extends ListTableModel {
        private Anh49Fachdaten fachdaten;

        public Anh49AbscheiderModel() {
            super(new String[]{"Abscheider", "Von", "Lage", "Bemerkung"}, false, true);
        }

        public void setFachdaten(Anh49Fachdaten fachdaten) {
            this.fachdaten = fachdaten;
            this.updateList();
        }

        @Override
        public Object getColumnValue(Object objectAtRow, int columnIndex) {
            Object tmp;
            Anh49Abscheiderdetails details = (Anh49Abscheiderdetails)objectAtRow;
            switch (columnIndex) {
                case 0: {
                    tmp = details.getAbscheidernr();
                    break;
                }
                case 1: {
                    tmp = details.getVon();
                    break;
                }
                case 2: {
                    tmp = details.getLage();
                    break;
                }
                case 3: {
                    tmp = details.getBemerkung();
                    break;
                }
                default: {
                    tmp = null;
                }
            }
            return tmp;
        }

        @Override
        public boolean objectRemoved(Object objectAtRow) {
            Anh49Abscheiderdetails removedAbsch = (Anh49Abscheiderdetails)objectAtRow;
            boolean removed = removedAbsch.getAbscheiderid() != null ? Anh49Abscheiderdetails.removeAbscheider(removedAbsch) : true;
            return removed;
        }

        @Override
        public void updateList() {
            if (this.fachdaten != null) {
                this.setList(Anh49Abscheiderdetails.getAbscheiderDetails(this.fachdaten));
            }
            this.fireTableDataChanged();
        }

        public Anh49Abscheiderdetails getRow(int rowIndex) {
            return (Anh49Abscheiderdetails)this.getObjectAtRow(rowIndex);
        }
    }
}

